/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import org.evomaster.client.java.instrumentation.object.ClassToSchema;
import org.evomaster.client.java.instrumentation.object.JsonTaint;

public class JsonUtils {
    public static String readStream(InputStream src) {
        String content = new BufferedReader(new InputStreamReader(src, Charset.defaultCharset())).lines().collect(Collectors.joining(System.lineSeparator()));
        return content;
    }

    public static InputStream toStream(String content) {
        return new ByteArrayInputStream(content.getBytes(Charset.defaultCharset()));
    }

    public static InputStream analyzeClass(InputStream entityStream, Class<Object> type) {
        String content = JsonUtils.readStream(entityStream);
        ClassToSchema.registerSchemaIfNeeded(type);
        JsonTaint.handlePossibleJsonTaint(content, type, false);
        return JsonUtils.toStream(content);
    }

    public static String getStringFromReader(Reader reader) {
        StringBuilder s = new StringBuilder();
        try {
            int character;
            while ((character = reader.read()) != -1) {
                s.append((char)character);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return s.toString();
    }

    public static Reader stringToReader(String content) {
        return new StringReader(content);
    }
}

