/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.util.Objects;
import org.evomaster.client.java.distance.heuristics.DistanceHelper;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.NumberParsingUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;

public class FloatClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return Float.class;
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true, category=ReplacementCategory.BASE)
    public static float parseFloat(String input, String idTemplate) {
        if (ExecutionTracer.isTaintInput(input)) {
            ExecutionTracer.addStringSpecialization(input, new StringSpecializationInfo(StringSpecialization.FLOAT, null));
        }
        if (idTemplate == null) {
            return Float.parseFloat(input);
        }
        try {
            float res = Float.parseFloat(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(1.0, 0.1));
            return res;
        }
        catch (NullPointerException | NumberFormatException e) {
            double h = NumberParsingUtils.getParsingHeuristicValueForFloat(input);
            ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.EXCEPTION, new Truthness(h, 1.0));
            throw e;
        }
    }

    @Replacement(type=ReplacementType.BOOLEAN, category=ReplacementCategory.BASE)
    public static boolean equals(Float caller, Object anObject, String idTemplate) {
        Truthness t;
        Objects.requireNonNull(caller);
        if (idTemplate == null) {
            return caller.equals(anObject);
        }
        if (anObject == null || !(anObject instanceof Float)) {
            t = new Truthness(0.05, 1.0);
        } else {
            Float anotherFloat = (Float)anObject;
            if (caller.equals(anotherFloat)) {
                t = new Truthness(1.0, 0.1);
            } else {
                double base = 0.1;
                double distance = DistanceHelper.getDistanceToEquality(caller.floatValue(), anotherFloat.floatValue());
                double h = DistanceHelper.heuristicFromScaledDistanceWithBase(base, distance);
                t = new Truthness(h, 1.0);
            }
        }
        ExecutionTracer.executedReplacedMethod(idTemplate, ReplacementType.BOOLEAN, t);
        return caller.equals(anObject);
    }

    @Replacement(type=ReplacementType.EXCEPTION, replacingStatic=true, category=ReplacementCategory.BASE)
    public static Float valueOf(String input, String idTemplate) {
        return Float.valueOf(FloatClassReplacement.parseFloat(input, idTemplate));
    }
}

