/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.classes;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.evomaster.client.java.instrumentation.HostnameResolutionInfo;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ExternalServiceUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.MethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.staticstate.ExecutionTracer;
import org.evomaster.client.java.instrumentation.staticstate.MethodReplacementPreserveSemantics;

public class InetAddressClassReplacement
implements MethodReplacementClass {
    @Override
    public Class<?> getTargetClass() {
        return InetAddress.class;
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.NET, replacingStatic=true, usageFilter=UsageFilter.ANY)
    public static InetAddress getByName(String host) throws UnknownHostException {
        return InetAddressClassReplacement.getAllByName(host)[0];
    }

    @Replacement(type=ReplacementType.TRACKER, category=ReplacementCategory.NET, replacingStatic=true, usageFilter=UsageFilter.ANY)
    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        if (host == null || host.isEmpty() || ExternalServiceUtils.isValidIP(host) || ExternalServiceUtils.skipHostname(host) || ExecutionTracer.skipHostname(host) || MethodReplacementPreserveSemantics.shouldPreserveSemantics) {
            return InetAddress.getAllByName(host);
        }
        if (ExecutionTracer.hasLocalAddressForHost(host)) {
            String ip = ExecutionTracer.getLocalAddress(host);
            return InetAddress.getAllByName(ip);
        }
        try {
            InetAddress[] inetAddress = InetAddress.getAllByName(host);
            ExecutionTracer.addHostnameInfo(new HostnameResolutionInfo(host, inetAddress[0].getHostAddress()));
            return InetAddress.getAllByName("127.0.0.2");
        }
        catch (UnknownHostException e) {
            ExecutionTracer.addHostnameInfo(new HostnameResolutionInfo(host, null));
            throw e;
        }
    }
}

