/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.coverage.methodreplacement.thirdpartyclasses;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.JsonUtils;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.Replacement;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyCast;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.ThirdPartyMethodReplacementClass;
import org.evomaster.client.java.instrumentation.coverage.methodreplacement.UsageFilter;
import org.evomaster.client.java.instrumentation.object.ClassToSchema;
import org.evomaster.client.java.instrumentation.object.JsonTaint;
import org.evomaster.client.java.instrumentation.shared.ReplacementCategory;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.utils.SimpleLogger;

public class JacksonObjectMapperClassReplacement
extends ThirdPartyMethodReplacementClass {
    private static final JacksonObjectMapperClassReplacement singleton = new JacksonObjectMapperClassReplacement();

    @Override
    protected String getNameOfThirdPartyTargetClass() {
        return "   com.fasterxml.jackson.databind.ObjectMapper".trim();
    }

    private static void analyzeClass(Class<?> valueType, String content, boolean isArray) {
        ClassToSchema.registerSchemaIfNeeded(valueType);
        JsonTaint.handlePossibleJsonTaint(content, valueType, isArray);
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="Jackson_ObjectMapper_readValue_InputStream_Generic_class", usageFilter=UsageFilter.ANY, category=ReplacementCategory.EXT_0)
    public static <T> T readValue(Object caller, InputStream src, Class<T> valueType) throws Throwable {
        Objects.requireNonNull(caller);
        String content = JsonUtils.readStream(src);
        JacksonObjectMapperClassReplacement.analyzeClass(valueType, content, false);
        src = JsonUtils.toStream(content);
        Method original = JacksonObjectMapperClassReplacement.getOriginal(singleton, "Jackson_ObjectMapper_readValue_InputStream_Generic_class", caller);
        try {
            return (T)original.invoke(caller, src, valueType);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="Jackson_ObjectMapper_readValue_InputStream_JavaType_class", usageFilter=UsageFilter.ANY, category=ReplacementCategory.EXT_0)
    public static <T> T readValue(Object caller, InputStream src, @ThirdPartyCast(actualType="  com.fasterxml.jackson.databind.JavaType") Object valueType) throws Throwable {
        Objects.requireNonNull(caller);
        String content = JsonUtils.readStream(src);
        JacksonObjectMapperClassReplacement.analyzeJavaType(content, valueType);
        src = JsonUtils.toStream(content);
        Method original = JacksonObjectMapperClassReplacement.getOriginal(singleton, "Jackson_ObjectMapper_readValue_InputStream_JavaType_class", caller);
        try {
            return (T)original.invoke(caller, src, valueType);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="Jackson_ObjectMapper_readValue_String_JavaType_class", usageFilter=UsageFilter.ANY, category=ReplacementCategory.EXT_0)
    public static <T> T readValue_EM_0(Object caller, String content, @ThirdPartyCast(actualType="  com.fasterxml.jackson.databind.JavaType") Object valueType) throws Throwable {
        Objects.requireNonNull(caller);
        JacksonObjectMapperClassReplacement.analyzeJavaType(content, valueType);
        Method original = JacksonObjectMapperClassReplacement.getOriginal(singleton, "Jackson_ObjectMapper_readValue_String_JavaType_class", caller);
        try {
            return (T)original.invoke(caller, content, valueType);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static void analyzeJavaType(String content, Object valueType) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String typeName = valueType.getClass().getSimpleName();
        if (typeName.equals("CollectionLikeType") || typeName.equals("CollectionType")) {
            Object contentType = valueType.getClass().getMethod("getContentType", new Class[0]).invoke(valueType, new Object[0]);
            Class typeClass = (Class)contentType.getClass().getMethod("getRawClass", new Class[0]).invoke(contentType, new Object[0]);
            JacksonObjectMapperClassReplacement.analyzeClass(typeClass, content, true);
        } else {
            Class typeClass = (Class)valueType.getClass().getMethod("getRawClass", new Class[0]).invoke(valueType, new Object[0]);
            JacksonObjectMapperClassReplacement.analyzeClass(typeClass, content, false);
        }
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="Jackson_ObjectMapper_readValue_String_TypeReference_class", usageFilter=UsageFilter.ANY, category=ReplacementCategory.EXT_0)
    public static <T> T readValue_EM_1(Object caller, String content, @ThirdPartyCast(actualType="  com.fasterxml.jackson.core.type.TypeReference") Object valueTypeRef) throws Throwable {
        Objects.requireNonNull(caller);
        Class<?> classObjectMapper = caller.getClass();
        while (!classObjectMapper.getSimpleName().equals("ObjectMapper")) {
            if ((classObjectMapper = classObjectMapper.getSuperclass()) != null) continue;
            SimpleLogger.error("EvoMaster instrumentation wrongly applied to " + caller.getClass().getName());
            break;
        }
        Field _typeFactoryField = null;
        if (classObjectMapper != null) {
            try {
                _typeFactoryField = classObjectMapper.getDeclaredField("_typeFactory");
            }
            catch (NoSuchFieldException e) {
                SimpleLogger.warn("" + classObjectMapper.getName() + " does not have a field called _typeFactory");
            }
        }
        if (_typeFactoryField == null) {
            Method original = JacksonObjectMapperClassReplacement.getOriginal(singleton, "Jackson_ObjectMapper_readValue_String_TypeReference_class", caller);
            try {
                return (T)original.invoke(caller, content, valueTypeRef);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        _typeFactoryField.setAccessible(true);
        Object _typeFactory = _typeFactoryField.get(caller);
        Method constructType = Arrays.stream(_typeFactory.getClass().getDeclaredMethods()).filter(m -> m.getName().equals("constructType")).filter(m -> m.getParameterTypes().length == 1).filter(m -> m.getParameterTypes()[0].getName().endsWith("TypeReference")).findFirst().orElse(null);
        Object javaType = constructType.invoke(_typeFactory, valueTypeRef);
        return JacksonObjectMapperClassReplacement.readValue_EM_0(caller, content, javaType);
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="Jackson_ObjectMapper_readValue_String_Generic_class", usageFilter=UsageFilter.ANY, category=ReplacementCategory.EXT_0)
    public static <T> T readValue(Object caller, String content, Class<T> valueType) throws Throwable {
        Objects.requireNonNull(caller);
        JacksonObjectMapperClassReplacement.analyzeClass(valueType, content, false);
        Method original = JacksonObjectMapperClassReplacement.getOriginal(singleton, "Jackson_ObjectMapper_readValue_String_Generic_class", caller);
        try {
            return (T)original.invoke(caller, content, valueType);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Replacement(replacingStatic=false, type=ReplacementType.TRACKER, id="Jackson_ObjectMapper_convertValue_Generic_class", usageFilter=UsageFilter.ANY, category=ReplacementCategory.EXT_0)
    public static <T> T convertValue(Object caller, Object fromValue, Class<T> toValueType) throws Throwable {
        Objects.requireNonNull(caller);
        ClassToSchema.registerSchemaIfNeeded(toValueType);
        if (fromValue instanceof String) {
            boolean isArray = false;
            JsonTaint.handlePossibleJsonTaint((String)fromValue, toValueType, isArray);
        }
        Method original = JacksonObjectMapperClassReplacement.getOriginal(singleton, "Jackson_ObjectMapper_convertValue_Generic_class", caller);
        try {
            return (T)original.invoke(caller, fromValue, toValueType);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

