/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.instrumentation.staticstate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.evomaster.client.java.distance.heuristics.Truthness;
import org.evomaster.client.java.instrumentation.Action;
import org.evomaster.client.java.instrumentation.AdditionalInfo;
import org.evomaster.client.java.instrumentation.ExecutedSqlCommand;
import org.evomaster.client.java.instrumentation.ExternalService;
import org.evomaster.client.java.instrumentation.ExternalServiceInfo;
import org.evomaster.client.java.instrumentation.ExternalServiceMapping;
import org.evomaster.client.java.instrumentation.HostnameResolutionInfo;
import org.evomaster.client.java.instrumentation.KillSwitchException;
import org.evomaster.client.java.instrumentation.MongoCollectionSchema;
import org.evomaster.client.java.instrumentation.MongoFindCommand;
import org.evomaster.client.java.instrumentation.OpenSearchCommand;
import org.evomaster.client.java.instrumentation.RedisCommand;
import org.evomaster.client.java.instrumentation.TargetInfo;
import org.evomaster.client.java.instrumentation.heuristic.HeuristicsForJumps;
import org.evomaster.client.java.instrumentation.shared.ClassName;
import org.evomaster.client.java.instrumentation.shared.ObjectiveNaming;
import org.evomaster.client.java.instrumentation.shared.ReplacementType;
import org.evomaster.client.java.instrumentation.shared.StringSpecialization;
import org.evomaster.client.java.instrumentation.shared.StringSpecializationInfo;
import org.evomaster.client.java.instrumentation.shared.TaintInputName;
import org.evomaster.client.java.instrumentation.shared.TaintType;
import org.evomaster.client.java.instrumentation.staticstate.ObjectiveRecorder;
import org.evomaster.client.java.instrumentation.staticstate.UnitsInfoRecorder;

public class ExecutionTracer {
    private static boolean executingInitSql = false;
    private static boolean executingInitMongo = false;
    private static boolean executingInitRedis = false;
    private static boolean executingAction = false;
    private static final Map<String, TargetInfo> objectiveCoverage = new ConcurrentHashMap<String, TargetInfo>(65536);
    private static int actionIndex = 0;
    private static String actionName = null;
    private static Set<String> inputVariables = new HashSet<String>();
    private static Map<String, ExternalServiceMapping> externalServiceMapping = new HashMap<String, ExternalServiceMapping>();
    private static Map<String, String> localAddressMapping = new HashMap<String, String>();
    private static final List<AdditionalInfo> additionalInfoList = new ArrayList<AdditionalInfo>();
    private static final List<Thread> sleepingThreads = new CopyOnWriteArrayList<Thread>();
    private static int expensiveOperation = 0;
    private static final Object lock = new Object();
    private static List<ExternalService> skippedExternalServices = new CopyOnWriteArrayList<ExternalService>();
    private static volatile boolean killSwitch = false;
    private static volatile String lastCallerClass = null;
    public static final String SET_LAST_CALLER_CLASS_METHOD_NAME = "setLastCallerClass";
    public static final String SET_LAST_CALLER_CLASS_DESC = "(Ljava/lang/String;)V";
    public static final String COMPLETED_LAST_EXECUTED_STATEMENT_NAME = "completedLastExecutedStatement";
    public static final String COMPLETED_LAST_EXECUTED_STATEMENT_DESCRIPTOR = "()V";
    public static final String EXECUTED_LINE_METHOD_NAME = "executedLine";
    public static final String EXECUTED_LINE_DESCRIPTOR = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V";
    public static final String EXECUTING_METHOD_METHOD_NAME = "executingMethod";
    public static final String EXECUTING_METHOD_DESCRIPTOR = "(Ljava/lang/String;IIZ)V";
    public static final String EXECUTING_CHECKCAST_METHOD_NAME = "executingCheckCast";
    public static final String EXECUTING_CHECKCAST_DESCRIPTOR = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;II)Ljava/lang/Object;";
    public static final String EXECUTED_CHECKCAST_METHOD_NAME = "executedCheckCast";
    public static final String EXECUTED_CHECKCAST_DESCRIPTOR = "(Ljava/lang/Object;Ljava/lang/String;II)V";
    public static final String EXECUTING_BRANCH_JUMP_METHOD_NAME = "executingBranchJump";
    public static final String JUMP_DESC_1_VALUE = "(IILjava/lang/String;II)V";
    public static final String JUMP_DESC_2_VALUES = "(IIILjava/lang/String;II)V";
    public static final String JUMP_DESC_OBJECTS = "(Ljava/lang/Object;Ljava/lang/Object;ILjava/lang/String;II)V";
    public static final String JUMP_DESC_NULL = "(Ljava/lang/Object;ILjava/lang/String;II)V";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            objectiveCoverage.clear();
            actionIndex = 0;
            actionName = null;
            additionalInfoList.clear();
            additionalInfoList.add(new AdditionalInfo());
            inputVariables = new HashSet<String>();
            killSwitch = false;
            expensiveOperation = 0;
            executingAction = false;
            sleepingThreads.clear();
            lastCallerClass = null;
            skippedExternalServices = new ArrayList<ExternalService>();
        }
    }

    public static String getActionName() {
        return actionName;
    }

    public static void setLastCallerClass(String className) {
        lastCallerClass = ClassName.get(className).getFullNameWithDots();
    }

    public static ClassLoader getLastCallerClassLoader() {
        return UnitsInfoRecorder.getInstance().getClassLoaders(ExecutionTracer.getLastCallerClass()).get(0);
    }

    public static String getLastCallerClass() {
        return lastCallerClass;
    }

    public static void reportSleeping() {
        sleepingThreads.add(Thread.currentThread());
    }

    public static boolean isKillSwitch() {
        return killSwitch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKillSwitch(boolean killSwitch) {
        ExecutionTracer.killSwitch = killSwitch;
        if (killSwitch) {
            Object object = lock;
            synchronized (object) {
                for (Thread t : sleepingThreads) {
                    if (!t.isAlive()) continue;
                    t.interrupt();
                }
                sleepingThreads.clear();
            }
        }
    }

    public static boolean isExecutingInitSql() {
        return executingInitSql;
    }

    public static void setExecutingInitSql(boolean executingInitSql) {
        ExecutionTracer.executingInitSql = executingInitSql;
    }

    public static void setExecutingInitMongo(boolean executingInitMongo) {
        ExecutionTracer.executingInitMongo = executingInitMongo;
    }

    public static void setExecutingInitRedis(boolean executingInitRedis) {
        ExecutionTracer.executingInitRedis = executingInitRedis;
    }

    public static boolean isExecutingAction() {
        return executingAction;
    }

    public static void setExecutingAction(boolean executingAction) {
        ExecutionTracer.executingAction = executingAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAction(Action action) {
        Object object = lock;
        synchronized (object) {
            ExecutionTracer.setKillSwitch(false);
            expensiveOperation = 0;
            if (action.getIndex() != actionIndex) {
                actionIndex = action.getIndex();
                additionalInfoList.add(new AdditionalInfo());
            }
            actionName = action.getName();
            if (action.getInputVariables() != null && !action.getInputVariables().isEmpty()) {
                inputVariables = action.getInputVariables();
            }
            if (action.getIndex() == 0) {
                externalServiceMapping = action.getExternalServiceMapping();
                localAddressMapping = action.getLocalAddressMapping();
                skippedExternalServices = action.getSkippedExternalServices();
            }
        }
    }

    public static void increaseExpensiveOperationCount() {
        ++expensiveOperation;
    }

    public static boolean isTooManyExpensiveOperations() {
        return expensiveOperation >= 50;
    }

    public static boolean isTaintInput(String input) {
        return TaintInputName.isTaintInput(input) || inputVariables.contains(input);
    }

    public static void handleExtraParamTaint(String left, String right) {
        if (left == null || left.isEmpty() || right == null || right.isEmpty()) {
            return;
        }
        boolean taintedLeft = left.equals("EMextraParam123");
        boolean taintedRight = right.equals("EMextraParam123");
        if (taintedLeft && taintedRight) {
            return;
        }
        if (taintedLeft) {
            ExecutionTracer.addQueryParameter(right);
        }
        if (taintedRight) {
            ExecutionTracer.addQueryParameter(left);
        }
    }

    public static void handleExtraHeaderTaint(String left, String right) {
        if (left == null || left.isEmpty() || right == null || right.isEmpty()) {
            return;
        }
        boolean taintedLeft = left.equals("x-EMextraHeader123");
        boolean taintedRight = right.equals("x-EMextraHeader123");
        if (taintedLeft && taintedRight) {
            return;
        }
        if (taintedLeft) {
            ExecutionTracer.addHeader(right);
        }
        if (taintedRight) {
            ExecutionTracer.addHeader(left);
        }
    }

    public static void handleTaintForStringEquals(String left, String right, boolean ignoreCase) {
        StringSpecialization type;
        if (left == null || right == null) {
            return;
        }
        boolean taintedLeft = ExecutionTracer.isTaintInput(left);
        boolean taintedRight = ExecutionTracer.isTaintInput(right);
        if (taintedLeft && taintedRight) {
            if (ignoreCase ? left.equalsIgnoreCase(right) : left.equals(right)) {
                return;
            }
            if (!TaintInputName.isTaintInput(left) || !TaintInputName.isTaintInput(right)) {
                return;
            }
            if (ExecutionTracer.shouldSkipTaint()) {
                return;
            }
            String id = left + "___" + right;
            ExecutionTracer.addStringSpecialization(left, new StringSpecializationInfo(StringSpecialization.EQUAL, id));
            ExecutionTracer.addStringSpecialization(right, new StringSpecializationInfo(StringSpecialization.EQUAL, id));
            return;
        }
        StringSpecialization stringSpecialization = type = ignoreCase ? StringSpecialization.CONSTANT_IGNORE_CASE : StringSpecialization.CONSTANT;
        if (taintedLeft || taintedRight) {
            if (ExecutionTracer.shouldSkipTaint()) {
                return;
            }
            if (taintedLeft) {
                ExecutionTracer.addStringSpecialization(left, new StringSpecializationInfo(type, right));
            } else {
                ExecutionTracer.addStringSpecialization(right, new StringSpecializationInfo(type, left));
            }
        }
    }

    private static boolean shouldSkipTaint() {
        return false;
    }

    public static TaintType getTaintType(String input) {
        if (input == null) {
            return TaintType.NONE;
        }
        if (ExecutionTracer.isTaintInput(input)) {
            return TaintType.FULL_MATCH;
        }
        if (TaintInputName.includesTaintInput(input) || inputVariables.stream().anyMatch(v -> input.contains((CharSequence)v))) {
            return TaintType.PARTIAL_MATCH;
        }
        return TaintType.NONE;
    }

    public static List<AdditionalInfo> exposeAdditionalInfoList() {
        return additionalInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AdditionalInfo getCurrentAdditionalInfo() {
        Object object = lock;
        synchronized (object) {
            return additionalInfoList.get(actionIndex);
        }
    }

    public static void markRawAccessOfHttpBodyPayload() {
        ExecutionTracer.getCurrentAdditionalInfo().setRawAccessOfHttpBodyPayload(true);
    }

    public static void addParsedDtoName(String name) {
        ExecutionTracer.getCurrentAdditionalInfo().addParsedDtoName(name);
    }

    public static void addQueryParameter(String param) {
        ExecutionTracer.getCurrentAdditionalInfo().addQueryParameter(param);
    }

    public static void addHeader(String header) {
        ExecutionTracer.getCurrentAdditionalInfo().addHeader(header);
    }

    public static void addStringSpecialization(String taintInputName, StringSpecializationInfo info) {
        ExecutionTracer.getCurrentAdditionalInfo().addSpecialization(taintInputName, info);
    }

    public static void addSqlInfo(ExecutedSqlCommand info) {
        if (!executingInitSql) {
            ExecutionTracer.getCurrentAdditionalInfo().addSqlInfo(info);
        }
    }

    public static void addMongoInfo(MongoFindCommand info) {
        if (!executingInitMongo) {
            ExecutionTracer.getCurrentAdditionalInfo().addMongoInfo(info);
        }
    }

    public static void addOpenSearchInfo(OpenSearchCommand info) {
        ExecutionTracer.getCurrentAdditionalInfo().addOpenSearchInfo(info);
    }

    public static void addRedisCommand(RedisCommand info) {
        if (!executingInitRedis) {
            ExecutionTracer.getCurrentAdditionalInfo().addRedisCommand(info);
        }
    }

    public static void addMongoCollectionType(MongoCollectionSchema mongoCollectionSchema) {
        if (!executingInitMongo) {
            ExecutionTracer.getCurrentAdditionalInfo().addMongoCollectionType(mongoCollectionSchema);
        }
    }

    public static void markLastExecutedStatement(String lastLine, String lastMethod) {
        ExecutionTracer.getCurrentAdditionalInfo().pushLastExecutedStatement(lastLine, lastMethod);
    }

    public static String getLastExecutedStatement() {
        return ExecutionTracer.getCurrentAdditionalInfo().getLastExecutedStatement();
    }

    public static void completedLastExecutedStatement() {
        ExecutionTracer.getCurrentAdditionalInfo().popLastExecutedStatement();
    }

    public static Map<String, TargetInfo> getInternalReferenceToObjectiveCoverage() {
        return objectiveCoverage;
    }

    public static int getNumberOfObjectives() {
        return objectiveCoverage.size();
    }

    public static int getNumberOfObjectives(String prefix) {
        return (int)objectiveCoverage.entrySet().stream().filter(e -> prefix == null || ((String)e.getKey()).startsWith(prefix)).count();
    }

    public static int getNumberOfNonCoveredObjectives(String prefix) {
        return ExecutionTracer.getNonCoveredObjectives(prefix).size();
    }

    public static Set<String> getNonCoveredObjectives(String prefix) {
        return objectiveCoverage.entrySet().stream().filter(e -> prefix == null || ((String)e.getKey()).startsWith(prefix)).filter(e -> ((TargetInfo)e.getValue()).value < 1.0).map(e -> (String)e.getKey()).collect(Collectors.toSet());
    }

    public static Double getValue(String id) {
        return ExecutionTracer.objectiveCoverage.get((Object)id).value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateObjective(String id, double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Invalid value " + value + " out of range [0,1]");
        }
        Object object = lock;
        synchronized (object) {
            if (objectiveCoverage.containsKey(id)) {
                double previous = ExecutionTracer.objectiveCoverage.get((Object)id).value;
                if (value > previous) {
                    objectiveCoverage.put(id, new TargetInfo(null, id, value, actionIndex));
                }
            } else {
                objectiveCoverage.put(id, new TargetInfo(null, id, value, actionIndex));
            }
        }
        ObjectiveRecorder.update(id, value);
    }

    public static void executedNumericComparison(String idTemplate, double lt, double eq, double gt) {
        ExecutionTracer.updateObjective(ObjectiveNaming.numericComparisonObjectiveName(idTemplate, -1), lt);
        ExecutionTracer.updateObjective(ObjectiveNaming.numericComparisonObjectiveName(idTemplate, 0), eq);
        ExecutionTracer.updateObjective(ObjectiveNaming.numericComparisonObjectiveName(idTemplate, 1), gt);
    }

    public static void executedReplacedMethod(String idTemplate, ReplacementType type, Truthness t) {
        assert (t.getOfTrue() != 0.0 && t.getOfFalse() != 0.0);
        String idTrue = ObjectiveNaming.methodReplacementObjectiveName(idTemplate, true, type);
        String idFalse = ObjectiveNaming.methodReplacementObjectiveName(idTemplate, false, type);
        ExecutionTracer.updateObjective(idTrue, t.getOfTrue());
        ExecutionTracer.updateObjective(idFalse, t.getOfFalse());
    }

    public static void executedLine(String className, String methodName, String descriptor, int line) {
        boolean initClass;
        if (ExecutionTracer.isKillSwitch() && !(initClass = Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(e -> e.getMethodName().equals("<clinit>")))) {
            throw new KillSwitchException();
        }
        String lineId = ObjectiveNaming.lineObjectiveName(className, line);
        String classId = ObjectiveNaming.classObjectiveName(className);
        ExecutionTracer.updateObjective(lineId, 1.0);
        ExecutionTracer.updateObjective(classId, 1.0);
        String lastLine = className + "_" + line + "_" + methodName;
        String lastMethod = className + "_" + methodName + "_" + descriptor;
        ExecutionTracer.markLastExecutedStatement(lastLine, lastMethod);
    }

    public static void executingMethod(String className, int line, int index, boolean completed) {
        String id = ObjectiveNaming.successCallObjectiveName(className, line, index);
        if (completed) {
            ExecutionTracer.updateObjective(id, 1.0);
        } else {
            ExecutionTracer.updateObjective(id, 0.5);
        }
    }

    public static Object executingCheckCast(Object value, String classType, String className, int line, int index) {
        String id = ObjectiveNaming.checkcastObjectiveName(className, line, index);
        if (value == null) {
            ExecutionTracer.updateObjective(id, 0.1);
        }
        if (value instanceof String && ExecutionTracer.isTaintInput((String)value) && !classType.equals("java/lang/String") && !classType.equals("java/lang/CharSequence") && !classType.equals("java/lang/Object")) {
            ExecutionTracer.updateObjective(id, 0.5);
            ExecutionTracer.addStringSpecialization((String)value, new StringSpecializationInfo(StringSpecialization.CAST_TO_TYPE, classType));
        }
        return value;
    }

    public static void executedCheckCast(Object value, String className, int line, int index) {
        if (value != null) {
            String id = ObjectiveNaming.checkcastObjectiveName(className, line, index);
            ExecutionTracer.updateObjective(id, 1.0);
        }
    }

    private static void updateBranch(String className, int line, int branchId, Truthness t, int opcode) {
        String forThen = ObjectiveNaming.branchObjectiveName(className, line, branchId, true, opcode);
        String forElse = ObjectiveNaming.branchObjectiveName(className, line, branchId, false, opcode);
        ExecutionTracer.updateObjective(forElse, t.getOfTrue());
        ExecutionTracer.updateObjective(forThen, t.getOfFalse());
    }

    public static void executingBranchJump(int value, int opcode, String className, int line, int branchId) {
        Truthness t = HeuristicsForJumps.getForSingleValueJump(value, opcode);
        ExecutionTracer.updateBranch(className, line, branchId, t, opcode);
    }

    public static void executingBranchJump(int firstValue, int secondValue, int opcode, String className, int line, int branchId) {
        Truthness t = HeuristicsForJumps.getForValueComparison(firstValue, secondValue, opcode);
        ExecutionTracer.updateBranch(className, line, branchId, t, opcode);
    }

    public static void executingBranchJump(Object first, Object second, int opcode, String className, int line, int branchId) {
        Truthness t = HeuristicsForJumps.getForObjectComparison(first, second, opcode);
        ExecutionTracer.updateBranch(className, line, branchId, t, opcode);
    }

    public static void executingBranchJump(Object obj, int opcode, String className, int line, int branchId) {
        Truthness t = HeuristicsForJumps.getForNullComparison(obj, opcode);
        ExecutionTracer.updateBranch(className, line, branchId, t, opcode);
    }

    public static void addHostnameInfo(HostnameResolutionInfo hostnameResolutionInfo) {
        ExecutionTracer.getCurrentAdditionalInfo().addHostnameInfo(hostnameResolutionInfo);
        if (!executingAction) {
            ObjectiveRecorder.registerHostnameResolutionInfoAtSutStartupTime(hostnameResolutionInfo);
        }
    }

    public static void addExternalServiceHost(ExternalServiceInfo hostInfo) {
        ExecutionTracer.getCurrentAdditionalInfo().addExternalService(hostInfo);
        if (!executingAction) {
            ObjectiveRecorder.registerExternalServiceInfoAtSutStartupTime(hostInfo);
        }
    }

    public static void addEmployedDefaultWMHost(ExternalServiceInfo hostInfo) {
        ExecutionTracer.getCurrentAdditionalInfo().addEmployedDefaultWM(hostInfo);
    }

    public static String getExternalMappingForSignature(String signature) {
        if (externalServiceMapping.containsKey(signature)) {
            return externalServiceMapping.get(signature).getLocalIPAddress();
        }
        return null;
    }

    public static String getExternalMappingForHostname(String hostname) {
        return ((ExternalServiceMapping)externalServiceMapping.entrySet().stream().filter(e -> ((ExternalServiceMapping)e.getValue()).getRemoteHostname().equals(hostname)).findFirst().get().getValue()).getLocalIPAddress();
    }

    public static boolean hasActiveExternalMappingForSignature(String signature) {
        return externalServiceMapping.containsKey(signature);
    }

    public static boolean hasMockServerForHostname(String hostname) {
        return externalServiceMapping.entrySet().stream().anyMatch(e -> ((ExternalServiceMapping)e.getValue()).getLocalIPAddress().equals(hostname));
    }

    public static boolean hasLocalAddressForHost(String hostname) {
        return localAddressMapping.containsKey(hostname);
    }

    public static boolean hasMappingForLocalAddress(String localAddress) {
        return localAddressMapping.containsValue(localAddress);
    }

    public static String getRemoteHostname(String localAddress) {
        return localAddressMapping.entrySet().stream().filter(e -> ((String)e.getValue()).equals(localAddress)).map(Map.Entry::getKey).findFirst().get().toString();
    }

    public static String getLocalAddress(String hostname) {
        return localAddressMapping.get(hostname);
    }

    public static String getDefaultSinkholeAddress() {
        return "127.0.0.2";
    }

    public static boolean skipHostname(String hostname) {
        return skippedExternalServices.stream().anyMatch(e -> e.getHostname().equals(hostname.toLowerCase()));
    }

    public static boolean skipHostnameAndPort(String hostname, int port) {
        return skippedExternalServices.stream().anyMatch(e -> e.getHostname().equals(hostname.toLowerCase()) && e.getPort() == port);
    }

    static {
        ExecutionTracer.reset();
    }
}

