/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.heuristic;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.evomaster.client.java.sql.heuristic.SqlBaseTableReference;
import org.evomaster.client.java.sql.heuristic.SqlDerivedTableReference;
import org.evomaster.client.java.sql.heuristic.SqlTableReference;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.delete.Delete;
import shaded.net.sf.jsqlparser.statement.select.FromItem;
import shaded.net.sf.jsqlparser.statement.select.Join;
import shaded.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.select.WithItem;
import shaded.net.sf.jsqlparser.statement.update.Update;

class TableAliasResolver {
    private final Deque<TreeMap<String, SqlTableReference>> stackOfTableAliases = new ArrayDeque<TreeMap<String, SqlTableReference>>();

    public void enterTableAliasContext(Statement statement) {
        Objects.requireNonNull(statement, "statement cannot be null");
        this.createNewAliasContext();
        if (statement instanceof Update) {
            this.processUpdate((Update)statement);
        } else if (statement instanceof Delete) {
            this.processDelete((Delete)statement);
        } else if (statement instanceof Select) {
            this.processSelect((Select)statement);
        } else {
            throw new IllegalArgumentException("Unsupported SQL statement type: " + statement.getClass().getName());
        }
    }

    private void processJoins(List<Join> joins) {
        Objects.requireNonNull(joins, "joins cannot be null");
        for (Join join : joins) {
            this.processFromItem(join.getRightItem());
        }
    }

    private void processUpdate(Update update) {
        Objects.requireNonNull(update, "update cannot be null");
        if (update.getWithItemsList() != null) {
            this.processWithItemsList(update.getWithItemsList());
        }
        this.processFromItem(update.getTable());
        if (update.getStartJoins() != null) {
            this.processJoins(update.getStartJoins());
        }
        if (update.getFromItem() != null) {
            this.processFromItem(update.getFromItem());
        }
        if (update.getJoins() != null) {
            this.processJoins(update.getJoins());
        }
    }

    private void processDelete(Delete delete) {
        Objects.requireNonNull(delete, "delete cannot be null");
        if (delete.getWithItemsList() != null) {
            this.processWithItemsList(delete.getWithItemsList());
        }
        this.processFromItem(delete.getTable());
        if (delete.getJoins() != null) {
            this.processJoins(delete.getJoins());
        }
    }

    private void processSelect(Select select) {
        Objects.requireNonNull(select, "select cannot be null");
        if (select.getWithItemsList() != null) {
            this.processWithItemsList(select.getWithItemsList());
        }
        if (select instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)select);
        } else if (select instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)select;
            if (parenthesedSelect.getAlias() != null) {
                String lowerCaseAliasName = parenthesedSelect.getAlias().getName();
                this.stackOfTableAliases.peek().put(lowerCaseAliasName, new SqlDerivedTableReference(parenthesedSelect));
            }
            Select innerSelect = parenthesedSelect.getSelect();
            this.processSelect(innerSelect);
        }
    }

    private void createNewAliasContext() {
        this.stackOfTableAliases.push(new TreeMap(String.CASE_INSENSITIVE_ORDER));
    }

    private void processWithItemsList(List<WithItem> withItemsList) {
        for (WithItem withItem : withItemsList) {
            if (withItem.getAlias() == null) continue;
            String aliasName = withItem.getAlias().getName();
            String lowerCaseAliasName = aliasName.toLowerCase();
            Select subquery = withItem.getSelect();
            SqlDerivedTableReference derivedSqlTableReference = new SqlDerivedTableReference(subquery);
            this.stackOfTableAliases.peek().put(lowerCaseAliasName, derivedSqlTableReference);
        }
    }

    private void processPlainSelect(PlainSelect select) {
        Objects.requireNonNull(select, "select cannot be null");
        PlainSelect plainSelect = select;
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem());
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.processFromItem(join.getRightItem());
            }
        }
    }

    private void processFromItem(FromItem fromItem) {
        ParenthesedSelect subSelect;
        Objects.requireNonNull(fromItem, "fromItem cannot be null");
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            if (table.getAlias() != null) {
                String lowerCaseAliasName = table.getAlias().getName().toLowerCase();
                this.stackOfTableAliases.peek().put(lowerCaseAliasName, new SqlBaseTableReference(table.getFullyQualifiedName()));
            }
        } else if (fromItem instanceof ParenthesedSelect && (subSelect = (ParenthesedSelect)fromItem).getAlias() != null) {
            String lowerCaseAliasName = subSelect.getAlias().getName().toLowerCase();
            this.stackOfTableAliases.peek().put(lowerCaseAliasName, new SqlDerivedTableReference(subSelect));
        }
    }

    public SqlTableReference resolveTableReference(String alias) {
        if (!this.isAliasDeclaredInAnyContext(alias)) {
            throw new IllegalArgumentException("Alias not found in any context: " + alias);
        }
        for (Map map : this.stackOfTableAliases) {
            if (!map.containsKey(alias)) continue;
            return (SqlTableReference)map.get(alias);
        }
        throw new IllegalArgumentException("Alias not found in any context: " + alias);
    }

    public void exitTableAliasContext() {
        this.stackOfTableAliases.pop();
    }

    public int getContextDepth() {
        return this.stackOfTableAliases.size();
    }

    public boolean isAliasDeclaredInCurrentContext(String alias) {
        Objects.requireNonNull(alias, "alias cannot be null");
        if (this.stackOfTableAliases.isEmpty()) {
            throw new IllegalArgumentException("Alias stack is empty. Cannot resolve alias: " + alias);
        }
        String lowerCaseAliasName = alias.toLowerCase();
        return this.stackOfTableAliases.peek().containsKey(lowerCaseAliasName);
    }

    public boolean isAliasDeclaredInAnyContext(String alias) {
        Objects.requireNonNull(alias, "alias cannot be null");
        String lowerCaseAliasName = alias.toLowerCase();
        for (Map map : this.stackOfTableAliases) {
            if (!map.containsKey(lowerCaseAliasName)) continue;
            return true;
        }
        return false;
    }
}

