/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.update.Update;
import org.evomaster.client.java.sql.internal.ParserUtils;

public class ColumnTableAnalyzer {
    public static Set<String> getDeletedTables(String delete) {
        if (!ParserUtils.isDelete(delete)) {
            throw new IllegalArgumentException("Input string is not a valid SQL DELETE: " + delete);
        }
        HashSet<String> set = new HashSet<String>();
        Delete stmt = (Delete)ParserUtils.asStatement(delete);
        Table table = stmt.getTable();
        if (table == null) {
            throw new IllegalArgumentException("Cannot handle delete: " + delete);
        }
        set.add(table.getName());
        return set;
    }

    public static Map<String, Set<String>> getInsertedDataFields(String insert) {
        if (!ParserUtils.isInsert(insert)) {
            throw new IllegalArgumentException("Input string is not a valid SQL INSERT: " + insert);
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        Insert stmt = (Insert)ParserUtils.asStatement(insert);
        Table table = stmt.getTable();
        if (table == null) {
            throw new IllegalArgumentException("Cannot handle insert: " + insert);
        }
        ColumnTableAnalyzer.handleTable(map, table);
        return map;
    }

    public static Map<String, Set<String>> getUpdatedDataFields(String update) {
        if (!ParserUtils.isUpdate(update)) {
            throw new IllegalArgumentException("Input string is not a valid SQL INSERT: " + update);
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        Update stmt = (Update)ParserUtils.asStatement(update);
        Table table = stmt.getTable();
        if (table == null) {
            throw new IllegalArgumentException("Cannot handle update: " + update);
        }
        ColumnTableAnalyzer.handleTable(map, table);
        return map;
    }

    public static Map<String, Set<String>> getSelectReadDataFields(String select) {
        if (!ParserUtils.isSelect(select)) {
            throw new IllegalArgumentException("Input string is not a valid SQL SELECT: " + select);
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        Select stmt = (Select)ParserUtils.asStatement(select);
        SelectBody selectBody = stmt.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            FromItem fromItem = plainSelect.getFromItem();
            if (fromItem == null) {
                return map;
            }
            ColumnTableAnalyzer.extractUsedColumnsAndTables(map, fromItem);
            List joins = plainSelect.getJoins();
            if (joins != null) {
                for (Join join : joins) {
                    FromItem rightItem = join.getRightItem();
                    ColumnTableAnalyzer.extractUsedColumnsAndTables(map, rightItem);
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot handle select: " + select);
        }
        return map;
    }

    private static void handleTable(Map<String, Set<String>> map, Table table) {
        Set columns = map.computeIfAbsent(table.getName(), k -> new HashSet());
        if (!columns.contains("*")) {
            columns.add("*");
        }
    }

    private static void extractUsedColumnsAndTables(Map<String, Set<String>> map, FromItem fromItem) {
        if (!(fromItem instanceof Table)) {
            throw new IllegalArgumentException("Cannot handle fromItem: " + fromItem.toString());
        }
        Table table = (Table)fromItem;
        ColumnTableAnalyzer.handleTable(map, table);
    }
}

