/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.evomaster.client.java.sql.internal.ParserUtils;

public class SelectTransformer {
    public static String addFieldsToSelect(String select) {
        Select stmt = SelectTransformer.asSelectStatement(select);
        SelectBody selectBody = stmt.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            Expression where = plainSelect.getWhere();
            if (where == null) {
                return select;
            }
            final List fields = plainSelect.getSelectItems();
            boolean allColumns = fields.stream().anyMatch(f -> f instanceof AllColumns || f instanceof AllTableColumns);
            if (!allColumns) {
                where.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

                    public void visit(Column column) {
                        String target = column.toString();
                        boolean found = false;
                        for (SelectItem si : fields) {
                            SelectExpressionItem field = (SelectExpressionItem)si;
                            String exp = field.getExpression().toString();
                            if (!target.equals(exp)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            SelectExpressionItem item = new SelectExpressionItem();
                            item.setExpression((Expression)column);
                            fields.add(item);
                        }
                    }
                });
            }
        }
        return stmt.toString();
    }

    public static String removeOperations(String select) {
        Select stmt = SelectTransformer.asSelectStatement(select);
        SelectBody selectBody = stmt.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            plainSelect.getSelectItems().removeIf(item -> item instanceof SelectExpressionItem && ((SelectExpressionItem)item).getExpression() instanceof Function);
        }
        return stmt.toString();
    }

    public static String removeConstraints(String select) {
        Select stmt = SelectTransformer.asSelectStatement(select);
        SelectBody selectBody = stmt.getSelectBody();
        SelectTransformer.handleSelectBody(selectBody);
        return stmt.toString();
    }

    private static Select asSelectStatement(String select) {
        Statement stmt = ParserUtils.asStatement(select);
        if (!(stmt instanceof Select)) {
            throw new IllegalArgumentException("SQL statement is not a SELECT: " + select);
        }
        return (Select)stmt;
    }

    private static void handleSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            plainSelect.setWhere(null);
            plainSelect.setLimit(null);
            plainSelect.setGroupByElement(null);
        } else if (selectBody instanceof SetOperationList) {
            for (SelectBody select : ((SetOperationList)selectBody).getSelects()) {
                SelectTransformer.handleSelectBody(select);
            }
        } else {
            throw new RuntimeException("Cannot handle " + selectBody.getClass());
        }
    }
}

