/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import org.evomaster.client.java.controller.api.dto.database.execution.SqlExecutionLogDto;
import org.evomaster.client.java.controller.api.dto.database.execution.SqlExecutionsDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbSchemaDto;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.evomaster.client.java.sql.internal.ColumnTableAnalyzer;
import org.evomaster.client.java.sql.internal.EvaluatedSqlCommand;
import org.evomaster.client.java.sql.internal.HeuristicsCalculator;
import org.evomaster.client.java.sql.internal.ParserUtils;
import org.evomaster.client.java.sql.internal.SelectTransformer;
import org.evomaster.client.java.sql.internal.SqlDistanceWithMetrics;
import org.evomaster.client.java.sql.internal.SqlNameContext;
import org.evomaster.client.java.sql.internal.TaintHandler;
import org.evomaster.client.java.utils.SimpleLogger;

public class SqlHandler {
    private static final Set<String> booleanConstantNames = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("t", "true", "f", "false", "yes", "y", "no", "n", "on", "off", "unknown")));
    private final TaintHandler taintHandler;
    private final List<String> buffer;
    private final List<EvaluatedSqlCommand> distances;
    private final Map<String, Set<String>> queriedData;
    private final Map<String, Set<String>> updatedData;
    private final Map<String, Set<String>> insertedData;
    private final Map<String, Set<String>> failedWhere;
    private final List<String> deletedData;
    private final List<SqlExecutionLogDto> executedInfo;
    private int numberOfSqlCommands;
    private volatile Connection connection;
    private volatile boolean calculateHeuristics;
    private volatile boolean extractSqlExecution;
    private volatile boolean advancedHeuristics;
    private volatile DbSchemaDto schema;

    public SqlHandler(TaintHandler taintHandler) {
        this.taintHandler = taintHandler;
        this.buffer = new CopyOnWriteArrayList<String>();
        this.distances = new ArrayList<EvaluatedSqlCommand>();
        this.queriedData = new ConcurrentHashMap<String, Set<String>>();
        this.updatedData = new ConcurrentHashMap<String, Set<String>>();
        this.insertedData = new ConcurrentHashMap<String, Set<String>>();
        this.failedWhere = new ConcurrentHashMap<String, Set<String>>();
        this.deletedData = new CopyOnWriteArrayList<String>();
        this.executedInfo = new CopyOnWriteArrayList<SqlExecutionLogDto>();
        this.calculateHeuristics = true;
        this.numberOfSqlCommands = 0;
    }

    public void reset() {
        this.buffer.clear();
        this.distances.clear();
        this.queriedData.clear();
        this.updatedData.clear();
        this.insertedData.clear();
        this.failedWhere.clear();
        this.deletedData.clear();
        this.executedInfo.clear();
        this.numberOfSqlCommands = 0;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setSchema(DbSchemaDto schema) {
        this.schema = schema;
    }

    public void handle(SqlExecutionLogDto sql) {
        this.executedInfo.add(sql);
        this.handle(sql.command);
    }

    public void handle(String sql) {
        Objects.requireNonNull(sql);
        if (!this.calculateHeuristics && !this.extractSqlExecution) {
            return;
        }
        ++this.numberOfSqlCommands;
        if (!ParserUtils.canParseSqlStatement(sql)) {
            SimpleLogger.warn((String)("Cannot parse SQL statement: " + sql));
            return;
        }
        this.buffer.add(sql);
        if (ParserUtils.isSelect(sql)) {
            SqlHandler.mergeNewData(this.queriedData, ColumnTableAnalyzer.getSelectReadDataFields(sql));
        } else if (ParserUtils.isDelete(sql)) {
            this.deletedData.addAll(ColumnTableAnalyzer.getDeletedTables(sql));
        } else if (ParserUtils.isInsert(sql)) {
            SqlHandler.mergeNewData(this.insertedData, ColumnTableAnalyzer.getInsertedDataFields(sql));
        } else if (ParserUtils.isUpdate(sql)) {
            SqlHandler.mergeNewData(this.updatedData, ColumnTableAnalyzer.getUpdatedDataFields(sql));
        }
    }

    public SqlExecutionsDto getExecutionDto() {
        if (!this.calculateHeuristics && !this.extractSqlExecution) {
            return null;
        }
        SqlExecutionsDto sqlExecutionsDto = new SqlExecutionsDto();
        sqlExecutionsDto.queriedData.putAll(this.queriedData);
        sqlExecutionsDto.failedWhere.putAll(this.failedWhere);
        sqlExecutionsDto.insertedData.putAll(this.insertedData);
        sqlExecutionsDto.updatedData.putAll(this.updatedData);
        sqlExecutionsDto.deletedData.addAll(this.deletedData);
        sqlExecutionsDto.numberOfSqlCommands = this.numberOfSqlCommands;
        sqlExecutionsDto.sqlExecutionLogDtoList.addAll(this.executedInfo);
        return sqlExecutionsDto;
    }

    public List<EvaluatedSqlCommand> getEvaluatedSqlCommands() {
        if (this.connection == null || !this.calculateHeuristics) {
            return this.distances;
        }
        this.buffer.forEach(sql -> {
            if (!ParserUtils.isSelectOne(sql) && (ParserUtils.isSelect(sql) || ParserUtils.isDelete(sql) || ParserUtils.isUpdate(sql))) {
                SqlDistanceWithMetrics dist = this.computeDistance((String)sql);
                this.distances.add(new EvaluatedSqlCommand((String)sql, dist));
            }
        });
        this.buffer.clear();
        return this.distances;
    }

    private SqlDistanceWithMetrics computeDistance(String command) {
        Statement statement;
        if (this.connection == null) {
            throw new IllegalStateException("Trying to calculate SQL distance with no DB connection");
        }
        try {
            statement = CCJSqlParserUtil.parse((String)command);
        }
        catch (Exception e) {
            SimpleLogger.uniqueWarn((String)("Cannot handle SQL command: " + command + "\n" + e));
            return new SqlDistanceWithMetrics(Double.MAX_VALUE, 0);
        }
        Map<String, Set<String>> columns = this.extractColumnsInvolvedInWhere(statement);
        SqlDistanceWithMetrics dist = columns.isEmpty() ? new SqlDistanceWithMetrics(0.0, 0) : this.getDistanceForWhere(command, columns);
        if (dist.sqlDistance > 0.0) {
            SqlHandler.mergeNewData(this.failedWhere, columns);
        }
        return dist;
    }

    private SqlDistanceWithMetrics getDistanceForWhere(String command, Map<String, Set<String>> columns) {
        QueryResult data;
        String select;
        if (ParserUtils.isSelect(command)) {
            select = SelectTransformer.addFieldsToSelect(command);
            select = SelectTransformer.removeConstraints(select);
            select = SelectTransformer.removeOperations(select);
        } else {
            if (columns.size() > 1) {
                SimpleLogger.uniqueWarn((String)("Cannot analyze: " + command));
            }
            Map.Entry<String, Set<String>> mapping = columns.entrySet().iterator().next();
            select = this.createSelectForSingleTable(mapping.getKey(), mapping.getValue());
        }
        try {
            data = SqlScriptRunner.execCommand(this.connection, select);
        }
        catch (SQLException e) {
            SimpleLogger.uniqueWarn((String)("Failed to execute query for retrieving data for computing SQL heuristics: " + select));
            return new SqlDistanceWithMetrics(Double.MAX_VALUE, 0);
        }
        return HeuristicsCalculator.computeDistance(command, data, this.schema, this.taintHandler, this.advancedHeuristics);
    }

    private String createSelectForSingleTable(String tableName, Set<String> columns) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ");
        String variables = String.join((CharSequence)", ", columns);
        buffer.append(variables);
        buffer.append(" FROM ");
        buffer.append(tableName);
        return buffer.toString();
    }

    public Map<String, Set<String>> extractColumnsInvolvedInWhere(Statement statement) {
        final HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        Expression where = ParserUtils.getWhere(statement);
        if (where == null) {
            return data;
        }
        final SqlNameContext context = new SqlNameContext(statement);
        if (this.schema != null) {
            context.setSchema(this.schema);
        }
        ExpressionVisitorAdapter visitor = new ExpressionVisitorAdapter(){

            public void visit(Column column) {
                String tn = context.getTableName(column);
                if (tn.equalsIgnoreCase("___unnamed_table___")) {
                    return;
                }
                String cn = column.getColumnName().toLowerCase();
                if (!context.hasColumn(tn, cn)) {
                    if (!booleanConstantNames.contains(cn)) {
                        SimpleLogger.warn((String)("Cannot find column '" + cn + "' in table '" + tn + "'"));
                    }
                    return;
                }
                data.putIfAbsent(tn, new HashSet());
                Set set = (Set)data.get(tn);
                set.add(cn);
            }
        };
        where.accept((ExpressionVisitor)visitor);
        return data;
    }

    private static void mergeNewData(Map<String, Set<String>> current, Map<String, Set<String>> toAdd) {
        for (Map.Entry<String, Set<String>> e : toAdd.entrySet()) {
            String key = e.getKey();
            Set<String> values = e.getValue();
            Set<String> existing = current.get(key);
            if (existing != null && existing.contains("*")) continue;
            if (existing == null) {
                existing = new HashSet<String>(values);
                current.put(key, existing);
            } else {
                existing.addAll(values);
            }
            if (existing.size() <= 1 || !existing.contains("*")) continue;
            existing.clear();
            existing.add("*");
        }
    }

    public boolean isCalculateHeuristics() {
        return this.calculateHeuristics;
    }

    public boolean isExtractSqlExecution() {
        return this.extractSqlExecution;
    }

    public void setCalculateHeuristics(boolean calculateHeuristics) {
        this.calculateHeuristics = calculateHeuristics;
    }

    public void setExtractSqlExecution(boolean extractSqlExecution) {
        this.extractSqlExecution = extractSqlExecution;
    }

    public boolean isAdvancedHeuristics() {
        return this.advancedHeuristics;
    }

    public void setAdvancedHeuristics(boolean advancedHeuristics) {
        this.advancedHeuristics = advancedHeuristics;
    }
}

