/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evomaster.client.java.controller.api.dto.database.schema.DatabaseType;
import org.evomaster.client.java.sql.DbCleaner;
import org.evomaster.client.java.sql.DbCleanerTestBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.testcontainers.containers.GenericContainer;

public class DbCleanerMySQLTest
extends DbCleanerTestBase {
    private static final String DB_NAME = "test";
    private static final int PORT = 3306;
    private static final String MYSQL_VERSION = "8.0.27";
    public static final GenericContainer mysql = new GenericContainer("mysql:8.0.27").withEnv((Map)new HashMap<String, String>(){
        {
            this.put("MYSQL_ROOT_PASSWORD", "root");
            this.put("MYSQL_DATABASE", DbCleanerMySQLTest.DB_NAME);
            this.put("MYSQL_USER", DbCleanerMySQLTest.DB_NAME);
            this.put("MYSQL_PASSWORD", DbCleanerMySQLTest.DB_NAME);
        }
    }).withExposedPorts(new Integer[]{3306});
    private static Connection connection;

    @BeforeAll
    public static void initClass() throws Exception {
        mysql.start();
        String host = mysql.getContainerIpAddress();
        int port = mysql.getMappedPort(3306);
        String url = "jdbc:mysql://" + host + ":" + port + "/" + DB_NAME;
        connection = DriverManager.getConnection(url, DB_NAME, DB_NAME);
    }

    @AfterAll
    public static void afterClass() throws Exception {
        connection.close();
        mysql.stop();
    }

    @AfterEach
    public void afterTest() throws SQLException {
        DbCleaner.dropDatabaseTables((Connection)connection, (String)DB_NAME, null, (DatabaseType)this.getDbType());
    }

    @Override
    protected Connection getConnection() {
        return connection;
    }

    @Override
    protected void clearDatabase(List<String> tablesToSkip, List<String> tableToClean) {
        DbCleaner.clearDatabase((Connection)connection, (String)DB_NAME, tablesToSkip, tableToClean, (DatabaseType)DatabaseType.MYSQL);
    }

    @Override
    protected DatabaseType getDbType() {
        return DatabaseType.MYSQL;
    }
}

