/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import org.evomaster.client.java.controller.api.dto.database.execution.SqlExecutionLogDto;
import org.evomaster.client.java.controller.api.dto.database.execution.SqlExecutionsDto;
import org.evomaster.client.java.controller.api.dto.database.operations.InsertionDto;
import org.evomaster.client.java.controller.api.dto.database.schema.DbInfoDto;
import org.evomaster.client.java.sql.QueryResult;
import org.evomaster.client.java.sql.SqlScriptRunner;
import org.evomaster.client.java.sql.internal.ColumnTableAnalyzer;
import org.evomaster.client.java.sql.internal.HeuristicsCalculator;
import org.evomaster.client.java.sql.internal.QueryResultTransformer;
import org.evomaster.client.java.sql.internal.SelectTransformer;
import org.evomaster.client.java.sql.internal.SqlCommandWithDistance;
import org.evomaster.client.java.sql.internal.SqlDistanceWithMetrics;
import org.evomaster.client.java.sql.internal.SqlNameContext;
import org.evomaster.client.java.sql.internal.SqlParserUtils;
import org.evomaster.client.java.sql.internal.TaintHandler;
import org.evomaster.client.java.utils.SimpleLogger;

public class SqlHandler {
    private static final Set<String> booleanConstantNames = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("t", "true", "f", "false", "yes", "y", "no", "n", "on", "off", "unknown")));
    private final TaintHandler taintHandler;
    private final List<SqlExecutionLogDto> bufferedSqlCommands;
    private final List<SqlCommandWithDistance> distances;
    private final Map<String, Set<String>> queriedData;
    private final Map<String, Set<String>> updatedData;
    private final Map<String, Set<String>> insertedData;
    private final Map<String, Set<String>> failedWhere;
    private final List<String> deletedData;
    private final List<SqlExecutionLogDto> executedSqlCommands;
    private int numberOfSqlCommands;
    private int sqlParseFailureCount;
    private volatile Connection connection;
    private volatile boolean calculateHeuristics;
    private volatile boolean extractSqlExecution;
    private volatile boolean advancedHeuristics;
    private volatile DbInfoDto schema;

    public SqlHandler(TaintHandler taintHandler) {
        this.taintHandler = taintHandler;
        this.bufferedSqlCommands = new CopyOnWriteArrayList<SqlExecutionLogDto>();
        this.distances = new ArrayList<SqlCommandWithDistance>();
        this.queriedData = new ConcurrentHashMap<String, Set<String>>();
        this.updatedData = new ConcurrentHashMap<String, Set<String>>();
        this.insertedData = new ConcurrentHashMap<String, Set<String>>();
        this.failedWhere = new ConcurrentHashMap<String, Set<String>>();
        this.deletedData = new CopyOnWriteArrayList<String>();
        this.executedSqlCommands = new CopyOnWriteArrayList<SqlExecutionLogDto>();
        this.calculateHeuristics = true;
        this.numberOfSqlCommands = 0;
        this.sqlParseFailureCount = 0;
    }

    public void reset() {
        this.bufferedSqlCommands.clear();
        this.distances.clear();
        this.queriedData.clear();
        this.updatedData.clear();
        this.insertedData.clear();
        this.failedWhere.clear();
        this.deletedData.clear();
        this.executedSqlCommands.clear();
        this.numberOfSqlCommands = 0;
        this.sqlParseFailureCount = 0;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setSchema(DbInfoDto schema) {
        this.schema = schema;
    }

    public void handle(SqlExecutionLogDto sqlExecutionLogDto) {
        this.executedSqlCommands.add(sqlExecutionLogDto);
        String sqlCommand = sqlExecutionLogDto.sqlCommand;
        Objects.requireNonNull(sqlCommand);
        if (!this.calculateHeuristics && !this.extractSqlExecution) {
            return;
        }
        ++this.numberOfSqlCommands;
        if (!SqlParserUtils.canParseSqlStatement(sqlCommand)) {
            ++this.sqlParseFailureCount;
            SimpleLogger.warn((String)("Cannot parse SQL statement: " + sqlCommand));
            return;
        }
        this.bufferedSqlCommands.add(sqlExecutionLogDto);
        if (SqlParserUtils.isSelect(sqlCommand)) {
            SqlHandler.mergeNewData(this.queriedData, ColumnTableAnalyzer.getSelectReadDataFields(sqlCommand));
        } else if (SqlParserUtils.isDelete(sqlCommand)) {
            this.deletedData.addAll(ColumnTableAnalyzer.getDeletedTables(sqlCommand));
        } else if (SqlParserUtils.isInsert(sqlCommand)) {
            SqlHandler.mergeNewData(this.insertedData, ColumnTableAnalyzer.getInsertedDataFields(sqlCommand));
        } else if (SqlParserUtils.isUpdate(sqlCommand)) {
            SqlHandler.mergeNewData(this.updatedData, ColumnTableAnalyzer.getUpdatedDataFields(sqlCommand));
        }
    }

    public SqlExecutionsDto getExecutionDto() {
        if (!this.calculateHeuristics && !this.extractSqlExecution) {
            return null;
        }
        SqlExecutionsDto sqlExecutionsDto = new SqlExecutionsDto();
        sqlExecutionsDto.queriedData.putAll(this.queriedData);
        sqlExecutionsDto.failedWhere.putAll(this.failedWhere);
        sqlExecutionsDto.insertedData.putAll(this.insertedData);
        sqlExecutionsDto.updatedData.putAll(this.updatedData);
        sqlExecutionsDto.deletedData.addAll(this.deletedData);
        sqlExecutionsDto.numberOfSqlCommands = this.numberOfSqlCommands;
        sqlExecutionsDto.sqlParseFailureCount = this.sqlParseFailureCount;
        sqlExecutionsDto.sqlExecutionLogDtoList.addAll(this.executedSqlCommands);
        return sqlExecutionsDto;
    }

    private boolean isValidSqlCommandForDistanceEvaluation(String sqlCommand) {
        return !SqlParserUtils.isSelectOne(sqlCommand) && (SqlParserUtils.isSelect(sqlCommand) || SqlParserUtils.isDelete(sqlCommand) || SqlParserUtils.isUpdate(sqlCommand));
    }

    public List<SqlCommandWithDistance> getSqlDistances(List<InsertionDto> successfulInitSqlInsertions, boolean queryFromDatabase) {
        if (this.connection == null || !this.calculateHeuristics) {
            return this.distances;
        }
        if (!this.bufferedSqlCommands.isEmpty()) {
            this.bufferedSqlCommands.forEach(sqlExecutionLogDto -> {
                String sqlCommand = sqlExecutionLogDto.sqlCommand;
                if (!sqlExecutionLogDto.threwSqlExeception && this.isValidSqlCommandForDistanceEvaluation(sqlCommand)) {
                    Statement parsedStatement = SqlParserUtils.parseSqlCommand(sqlCommand);
                    SqlDistanceWithMetrics sqlDistance = this.computeDistance(sqlCommand, parsedStatement, successfulInitSqlInsertions, queryFromDatabase);
                    this.distances.add(new SqlCommandWithDistance(sqlCommand, sqlDistance));
                }
            });
            this.bufferedSqlCommands.clear();
        }
        return this.distances;
    }

    private SqlDistanceWithMetrics computeDistance(String sqlCommand, Statement parsedStatement, List<InsertionDto> successfulInitSqlInsertions, boolean queryFromDatabase) {
        if (this.connection == null) {
            throw new IllegalStateException("Trying to calculate SQL distance with no DB connection");
        }
        Map<String, Set<String>> columns = this.extractColumnsInvolvedInWhere(parsedStatement);
        SqlDistanceWithMetrics dist = columns.isEmpty() || queryFromDatabase ? this.getDistanceForWhere(sqlCommand, columns) : this.getDistanceForWhereBasedOnInsertion(sqlCommand, columns, successfulInitSqlInsertions);
        if (dist.sqlDistance > 0.0) {
            SqlHandler.mergeNewData(this.failedWhere, columns);
        }
        return dist;
    }

    private SqlDistanceWithMetrics getDistanceForWhereBasedOnInsertion(String sqlCommand, Map<String, Set<String>> columns, List<InsertionDto> insertionDtos) {
        QueryResult[] data = QueryResultTransformer.convertInsertionDtosToQueryResults(insertionDtos, columns, this.schema);
        assert (data != null);
        return HeuristicsCalculator.computeDistance(sqlCommand, this.schema, this.taintHandler, this.advancedHeuristics, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SqlDistanceWithMetrics getDistanceForWhere(String sqlCommand, Map<String, Set<String>> columns) {
        String select;
        if (!(SqlParserUtils.isSelect(sqlCommand) || SqlParserUtils.isDelete(sqlCommand) || SqlParserUtils.isUpdate(sqlCommand))) {
            throw new IllegalArgumentException("Cannot compute distance for sql command: " + sqlCommand);
        }
        if (SqlParserUtils.isSelect(sqlCommand)) {
            select = SelectTransformer.addFieldsToSelect(sqlCommand);
            select = SelectTransformer.removeConstraints(select);
            select = SelectTransformer.removeOperations(select);
        } else {
            Set<String> columnNames;
            String tableName;
            if (columns.size() > 1) {
                SimpleLogger.uniqueWarn((String)("Cannot analyze: " + sqlCommand));
            }
            if (columns.isEmpty()) {
                if (SqlParserUtils.isUpdate(sqlCommand)) {
                    Map<String, Set<String>> mapping = ColumnTableAnalyzer.getUpdatedDataFields(sqlCommand);
                    if (mapping.size() != 1) {
                        throw new IllegalArgumentException("Cannot handle delete: " + sqlCommand);
                    }
                    tableName = mapping.entrySet().iterator().next().getKey();
                    columnNames = Collections.singleton("*");
                } else {
                    if (!SqlParserUtils.isDelete(sqlCommand)) throw new IllegalStateException("SQL command should only be SELECT, UPDATE or DELETE");
                    Set<String> deletedTables = ColumnTableAnalyzer.getDeletedTables(sqlCommand);
                    if (deletedTables.size() != 1) {
                        throw new IllegalArgumentException("Cannot handle delete: " + sqlCommand);
                    }
                    tableName = deletedTables.iterator().next();
                    columnNames = Collections.singleton("*");
                }
            } else {
                Map.Entry<String, Set<String>> tableToColumns = columns.entrySet().iterator().next();
                tableName = tableToColumns.getKey();
                columnNames = tableToColumns.getValue();
            }
            select = this.createSelectForSingleTable(tableName, columnNames);
        }
        try {
            QueryResult data = SqlScriptRunner.execCommand(this.connection, select);
            return HeuristicsCalculator.computeDistance(sqlCommand, this.schema, this.taintHandler, this.advancedHeuristics, data);
        }
        catch (SQLException e) {
            SimpleLogger.uniqueWarn((String)("Failed to execute query for retrieving data for computing SQL heuristics: " + select));
            return new SqlDistanceWithMetrics(Double.MAX_VALUE, 0, true);
        }
    }

    private String createSelectForSingleTable(String tableName, Set<String> columns) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ");
        String variables = String.join((CharSequence)", ", columns);
        buffer.append(variables);
        buffer.append(" FROM ");
        buffer.append(tableName);
        return buffer.toString();
    }

    public Map<String, Set<String>> extractColumnsInvolvedInWhere(Statement statement) {
        final HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        Expression where = SqlParserUtils.getWhere(statement);
        if (where == null) {
            return data;
        }
        final SqlNameContext context = new SqlNameContext(statement);
        if (this.schema != null) {
            context.setSchema(this.schema);
        }
        ExpressionVisitorAdapter visitor = new ExpressionVisitorAdapter(){

            public void visit(Column column) {
                String tn = context.getTableName(column);
                if (tn.equalsIgnoreCase("___unnamed_table___")) {
                    return;
                }
                String cn = column.getColumnName().toLowerCase();
                if (!context.hasColumn(tn, cn)) {
                    if (!booleanConstantNames.contains(cn)) {
                        SimpleLogger.warn((String)("Cannot find column '" + cn + "' in table '" + tn + "'"));
                    }
                    return;
                }
                data.putIfAbsent(tn, new HashSet());
                Set set = (Set)data.get(tn);
                set.add(cn);
            }
        };
        where.accept((ExpressionVisitor)visitor);
        return data;
    }

    private static void mergeNewData(Map<String, Set<String>> current, Map<String, Set<String>> toAdd) {
        for (Map.Entry<String, Set<String>> e : toAdd.entrySet()) {
            String key = e.getKey();
            Set<String> values = e.getValue();
            Set<String> existing = current.get(key);
            if (existing != null && existing.contains("*")) continue;
            if (existing == null) {
                existing = new HashSet<String>(values);
                current.put(key, existing);
            } else {
                existing.addAll(values);
            }
            if (existing.size() <= 1 || !existing.contains("*")) continue;
            existing.clear();
            existing.add("*");
        }
    }

    public boolean isCalculateHeuristics() {
        return this.calculateHeuristics;
    }

    public boolean isExtractSqlExecution() {
        return this.extractSqlExecution;
    }

    public void setCalculateHeuristics(boolean calculateHeuristics) {
        this.calculateHeuristics = calculateHeuristics;
    }

    public void setExtractSqlExecution(boolean extractSqlExecution) {
        this.extractSqlExecution = extractSqlExecution;
    }

    public boolean isAdvancedHeuristics() {
        return this.advancedHeuristics;
    }

    public void setAdvancedHeuristics(boolean advancedHeuristics) {
        this.advancedHeuristics = advancedHeuristics;
    }
}

