/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql;

public enum SqlDataType {
    BOOL,
    BOOLEAN,
    INT,
    INTEGER,
    INT2,
    INT4,
    SMALLINT,
    TINYINT,
    INT8,
    BIGINT,
    BIGSERIAL,
    DOUBLE,
    DOUBLE_PRECISION,
    FLOAT,
    REAL,
    FLOAT4,
    FLOAT8,
    DEC,
    DECIMAL,
    TIMESTAMP,
    TIMESTAMPZ,
    TIMETZ,
    DATE,
    DATETIME,
    TIME,
    CHAR,
    CHARACTER,
    CHARACTER_LARGE_OBJECT,
    TINYTEXT,
    TEXT,
    LONGTEXT,
    VARCHAR,
    CLOB,
    CHARACTER_VARYING,
    VARCHAR_IGNORECASE,
    MEDIUMTEXT,
    LONGBLOB,
    MEDIUMBLOB,
    TINYBLOB;


    public static SqlDataType fromString(String input) {
        String normalized = input.toUpperCase().replace(' ', '_');
        return SqlDataType.valueOf(normalized);
    }

    public static boolean isStringType(SqlDataType dataType) {
        switch (dataType) {
            case CHAR: 
            case CHARACTER: 
            case CHARACTER_LARGE_OBJECT: 
            case TINYTEXT: 
            case TEXT: 
            case LONGTEXT: 
            case VARCHAR: 
            case CHARACTER_VARYING: 
            case VARCHAR_IGNORECASE: 
            case CLOB: 
            case MEDIUMTEXT: 
            case LONGBLOB: 
            case MEDIUMBLOB: 
            case TINYBLOB: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDateTimeType(SqlDataType dataType) {
        switch (dataType) {
            case TIMESTAMP: 
            case TIMESTAMPZ: 
            case TIMETZ: 
            case DATE: 
            case DATETIME: 
            case TIME: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDoubleType(SqlDataType dataType) {
        switch (dataType) {
            case DOUBLE: 
            case DOUBLE_PRECISION: 
            case FLOAT: 
            case REAL: 
            case FLOAT4: 
            case FLOAT8: 
            case DEC: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLongType(SqlDataType dataType) {
        switch (dataType) {
            case INT8: 
            case BIGINT: 
            case BIGSERIAL: {
                return true;
            }
        }
        return false;
    }

    public static boolean isByteType(SqlDataType dataType) {
        switch (dataType) {
            case TINYINT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isShortType(SqlDataType dataType) {
        switch (dataType) {
            case INT2: 
            case SMALLINT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntegerType(SqlDataType dataType) {
        switch (dataType) {
            case INT: 
            case INTEGER: 
            case INT4: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBooleanType(SqlDataType dataType) {
        switch (dataType) {
            case BOOL: 
            case BOOLEAN: {
                return true;
            }
        }
        return false;
    }
}

