/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.source.cache;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.graphwalker.java.source.cache.Cache;
import org.graphwalker.java.source.cache.CacheEntry;
import org.graphwalker.java.source.cache.CacheException;

public final class SimpleCache
implements Cache<Path, CacheEntry> {
    private static final Type type = new TypeToken<HashMap<String, CacheEntry>>(){}.getType();
    private static final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    private final Path path;
    private final Map<String, CacheEntry> storage = new HashMap<String, CacheEntry>();

    public SimpleCache(Path path) {
        this.path = path.resolve(Paths.get("cache.json", new String[0]));
        this.read();
    }

    private void read() {
        if (Files.exists(this.path, new LinkOption[0])) {
            try {
                String json = new String(Files.readAllBytes(this.path), Charset.forName("UTF-8"));
                Map data = (Map)gson.fromJson(json, type);
                this.storage.putAll(data);
            }
            catch (IOException e) {
                throw new CacheException(e);
            }
        }
    }

    private void save() {
        try {
            String json = gson.toJson(this.storage);
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            Files.write(this.path, json.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    @Override
    public CacheEntry get(Path key) {
        return this.storage.get(key.toString());
    }

    @Override
    public void add(Path key, CacheEntry value) {
        this.storage.put(key.toString(), value);
        this.save();
    }

    @Override
    public boolean contains(Path key) {
        return this.storage.containsKey(key.toString());
    }
}

