/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.test;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.graphwalker.core.generator.PathGenerator;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Element;
import org.graphwalker.dsl.antlr.generator.GeneratorFactory;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.ContextFactoryException;
import org.graphwalker.io.factory.ContextFactoryScanner;
import org.graphwalker.java.test.Result;
import org.graphwalker.java.test.TestExecutor;

public final class TestBuilder {
    private List<Context> contexts = new ArrayList<Context>();
    @Deprecated
    private Path model;
    @Deprecated
    private Context context;
    @Deprecated
    private PathGenerator generator;
    @Deprecated
    private String start;

    public TestBuilder addModel(String model) {
        return this.addModel(Paths.get(model, new String[0]));
    }

    public TestBuilder addModel(Path model) {
        this.contexts.add(this.createContext(model, null, null, null));
        return this;
    }

    public TestBuilder addModel(String model, PathGenerator pathGenerator) {
        return this.addModel(Paths.get(model, new String[0]), pathGenerator);
    }

    public TestBuilder addModel(Path model, PathGenerator pathGenerator) {
        this.contexts.add(this.createContext(model, null, pathGenerator, null));
        return this;
    }

    public TestBuilder addModel(String model, PathGenerator pathGenerator, String start) {
        return this.addModel(Paths.get(model, new String[0]), pathGenerator, start);
    }

    public TestBuilder addModel(Path model, PathGenerator pathGenerator, String start) {
        this.contexts.add(this.createContext(model, null, pathGenerator, start));
        return this;
    }

    public TestBuilder addModel(String model, Context context) {
        return this.addModel(Paths.get(model, new String[0]), context);
    }

    public TestBuilder addModel(Path model, Context context) {
        this.contexts.add(this.createContext(model, context, null, null));
        return this;
    }

    private Context createContext(Path model, Context context, PathGenerator pathGenerator, String start) {
        Context newContext;
        ContextFactory factory = ContextFactoryScanner.get((Path)model);
        try {
            newContext = null != context ? factory.create(model, context) : factory.create(model);
            if (null != pathGenerator) {
                newContext.setPathGenerator(pathGenerator);
            }
            if (null != start) {
                newContext.setNextElement((Element)newContext.getModel().findElements(start).get(0));
            }
        }
        catch (Throwable t) {
            throw new ContextFactoryException("Failed to create context", t);
        }
        return newContext;
    }

    public TestBuilder addContext(Context context) {
        this.contexts.add(context);
        return this;
    }

    public TestBuilder addClass(Class<? extends Context> testClass) {
        this.contexts.add(this.createContext(testClass));
        return this;
    }

    public TestBuilder addClass(Class<? extends Context> testClass, String pathGenerator) {
        return this.addClass(testClass, GeneratorFactory.parse((String)pathGenerator));
    }

    public TestBuilder addClass(Class<? extends Context> testClass, PathGenerator pathGenerator) {
        Context context = this.createContext(testClass);
        context.setPathGenerator(pathGenerator);
        this.contexts.add(context);
        return this;
    }

    private Context createContext(Class<? extends Context> testClass) {
        try {
            return testClass.newInstance();
        }
        catch (Throwable t) {
            throw new ContextFactoryException("Failed to create context", t);
        }
    }

    public Result execute(boolean ignoreError) {
        if (this.contexts.isEmpty()) {
            return new TestExecutor(this.build()).execute(ignoreError);
        }
        return new TestExecutor(this.contexts).execute(ignoreError);
    }

    public Result execute() {
        return this.execute(false);
    }

    @Deprecated
    public TestBuilder setModel(String model) {
        return this.setModel(Paths.get(model, new String[0]));
    }

    @Deprecated
    public TestBuilder setModel(Path model) {
        this.model = model;
        return this;
    }

    @Deprecated
    public TestBuilder setContext(Context context) {
        this.context = context;
        return this;
    }

    @Deprecated
    public TestBuilder setPathGenerator(PathGenerator generator) {
        this.generator = generator;
        return this;
    }

    @Deprecated
    public TestBuilder setStart(String start) {
        this.start = start;
        return this;
    }

    @Deprecated
    public Context build() {
        ContextFactory factory = ContextFactoryScanner.get((Path)this.model);
        try {
            return factory.create(this.model, this.context).setPathGenerator(this.generator).setNextElement((Element)this.context.getModel().findElements(this.start).get(0));
        }
        catch (Throwable t) {
            throw new ContextFactoryException("Failed to create context", t);
        }
    }
}

