/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Reflections {
    private static final Logger logger = LoggerFactory.getLogger(Reflections.class);
    private static final Class[] NO_ARGS = new Class[0];

    public static Class<?> loadClass(ClassLoader classLoader, Class<?> type) {
        try {
            return classLoader.loadClass(type.getName());
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Object newInstance(ClassLoader classLoader, Class<?> type) {
        try {
            return Reflections.loadClass(classLoader, type).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error(e.getCause().getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Object newInstance(Constructor<?> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error(e.getCause().getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Object invoke(Object object, Method method, Object ... arguments) {
        try {
            return method.invoke(object, arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error(e.getCause().getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(Class<?> type, String name, Class ... parameters) {
        try {
            return type.getMethod(name, parameters);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Constructor<?> getConstructor(ClassLoader classLoader, Class<?> type, Class<?> parameters) {
        try {
            return Reflections.loadClass(classLoader, type).getConstructor(parameters);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static Object get(Object object, Class<?> type, String name) {
        Method method = Reflections.getMethod(type, name, NO_ARGS);
        return Reflections.invoke(object, method, new Object[0]);
    }
}

