/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Scanner;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.framing.BinaryFrame;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.util.Charsetfunctions;
import org.java_websocket.util.KeyUtils;
import org.java_websocket.util.SocketUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Issue847Test {
    private static Thread thread;
    private static ServerSocket serverSocket;
    private static int port;
    private static final int NUMBER_OF_TESTS = 20;
    @Parameterized.Parameter
    public int size;

    @Parameterized.Parameters
    public static Collection<Integer[]> data() {
        ArrayList<Integer[]> ret = new ArrayList<Integer[]>(20);
        for (int i = 1; i <= 21; ++i) {
            ret.add(new Integer[]{(int)Math.round(Math.pow(2.0, i))});
        }
        return ret;
    }

    @BeforeClass
    public static void startServer() throws Exception {
        port = SocketUtil.getAvailablePort();
        thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    serverSocket = new ServerSocket(port);
                    serverSocket.setReuseAddress(true);
                    block4: while (true) {
                        Socket client = null;
                        try {
                            client = serverSocket.accept();
                            Scanner in = new Scanner(client.getInputStream());
                            String seckey = "";
                            boolean useMask = false;
                            int size = 0;
                            OutputStream os = client.getOutputStream();
                            while (true) {
                                if (!in.hasNext()) continue block4;
                                String input = in.nextLine();
                                if (input.startsWith("Sec-WebSocket-Key: ")) {
                                    seckey = input.split(" ")[1];
                                }
                                if (input.startsWith("Upgrade")) {
                                    os.write(Charsetfunctions.asciiBytes((String)("HTTP/1.1 101 Websocket Connection Upgrade\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n" + KeyUtils.getSecKey(seckey) + "\r\n")));
                                    os.flush();
                                    Thread.sleep(10L);
                                    Draft_6455 draft_6455 = new Draft_6455();
                                    BinaryFrame binaryFrame = new BinaryFrame();
                                    binaryFrame.setPayload(ByteBuffer.allocate(size));
                                    binaryFrame.setTransferemasked(useMask);
                                    ByteBuffer byteBuffer = draft_6455.createBinaryFrame((Framedata)binaryFrame);
                                    byte[] bytes = byteBuffer.array();
                                    int first = size / 2;
                                    os.write(bytes, 0, first);
                                    os.flush();
                                    Thread.sleep(5L);
                                    os.write(bytes, first, bytes.length - first);
                                    os.flush();
                                    continue block4;
                                }
                                if (!input.startsWith("GET ")) continue;
                                String testCase = input.split(" ")[1];
                                String[] strings = testCase.split("/");
                                useMask = Boolean.valueOf(strings[1]);
                                size = Integer.valueOf(strings[2]);
                            }
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)"There should be no exception");
                    return;
                }
            }
        });
        thread.start();
    }

    @AfterClass
    public static void successTests() throws IOException {
        serverSocket.close();
        thread.interrupt();
    }

    @Test(timeout=5000L)
    public void testIncrementalFrameUnmasked() throws Exception {
        this.testIncrementalFrame(false, this.size);
    }

    @Test(timeout=5000L)
    public void testIncrementalFrameMsked() throws Exception {
        this.testIncrementalFrame(true, this.size);
    }

    private void testIncrementalFrame(boolean useMask, int size) throws Exception {
        final boolean[] threadReturned = new boolean[]{false};
        WebSocketClient webSocketClient = new WebSocketClient(new URI("ws://localhost:" + port + "/" + useMask + "/" + size)){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String message) {
                Assert.fail((String)"There should not be a message!");
            }

            public void onMessage(ByteBuffer message) {
                threadReturned[0] = true;
                this.close();
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
                ex.printStackTrace();
            }
        };
        Thread finalThread = new Thread((Runnable)webSocketClient);
        finalThread.start();
        finalThread.join();
        if (!threadReturned[0]) {
            Assert.fail((String)"Error");
        }
    }
}

