/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.CountDownLatch;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SSLContextUtil;
import org.java_websocket.util.SocketUtil;
import org.junit.Test;

public class Issue764Test {
    private CountDownLatch countClientDownLatch = new CountDownLatch(2);
    private CountDownLatch countServerDownLatch = new CountDownLatch(1);

    @Test(timeout=2000L)
    public void testIssue() throws IOException, URISyntaxException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, CertificateException, InterruptedException {
        int port = SocketUtil.getAvailablePort();
        WebSocketClient webSocket = new WebSocketClient(new URI("wss://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
                Issue764Test.this.countClientDownLatch.countDown();
                Issue764Test.this.countServerDownLatch.countDown();
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
            }
        };
        MyWebSocketServer server = new MyWebSocketServer(port, webSocket, this.countServerDownLatch);
        SSLContext sslContext = SSLContextUtil.getContext();
        server.setWebSocketFactory((WebSocketServerFactory)new DefaultSSLWebSocketServerFactory(sslContext));
        webSocket.setSocketFactory((SocketFactory)sslContext.getSocketFactory());
        server.start();
        this.countServerDownLatch.await();
        webSocket.connectBlocking();
        webSocket.reconnectBlocking();
        this.countClientDownLatch.await();
    }

    private static class MyWebSocketServer
    extends WebSocketServer {
        private final WebSocketClient webSocket;
        private final CountDownLatch countServerDownLatch;

        public MyWebSocketServer(int port, WebSocketClient webSocket, CountDownLatch countServerDownLatch) {
            super(new InetSocketAddress(port));
            this.webSocket = webSocket;
            this.countServerDownLatch = countServerDownLatch;
        }

        public void onOpen(WebSocket conn, ClientHandshake handshake) {
        }

        public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        }

        public void onMessage(WebSocket conn, String message) {
        }

        public void onError(WebSocket conn, Exception ex) {
            ex.printStackTrace();
        }

        public void onStart() {
            this.countServerDownLatch.countDown();
        }
    }
}

