/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.PCMElement;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.impl.CellImpl;
import org.opencompare.api.java.util.PCMVisitor;

public class ProductImpl
implements Product {
    private pcm.Product kProduct;

    public ProductImpl(pcm.Product kProduct) {
        this.kProduct = kProduct;
    }

    public pcm.Product getkProduct() {
        return this.kProduct;
    }

    public String getName() {
        return this.kProduct.getName();
    }

    public void setName(String s) {
        this.kProduct.setName(s);
    }

    public List<Cell> getCells() {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (pcm.Cell kCell : this.kProduct.getCells()) {
            cells.add(new CellImpl(kCell));
        }
        return cells;
    }

    public void addCell(Cell cell) {
        this.kProduct.addCells(((CellImpl)cell).getkCell());
    }

    public void removeCell(Cell cell) {
        this.kProduct.removeCells(((CellImpl)cell).getkCell());
    }

    public Cell findCell(Feature feature) {
        for (Cell cell : this.getCells()) {
            if (!cell.getFeature().equals(feature)) continue;
            return cell;
        }
        return null;
    }

    public void accept(PCMVisitor visitor) {
        visitor.visit((Product)this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Product(" + this.getName() + ")");
        result.append("(");
        for (Cell cell : this.getCells()) {
            result.append(cell.toString());
        }
        result.append(")");
        return result.toString();
    }

    public boolean equals(Object o) {
        HashSet<Cell> productCellsSet;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductImpl product = (ProductImpl)o;
        if (this.getName() == null && product.getName() != null) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(product.getName())) {
            return false;
        }
        HashSet<Cell> thisCellsSet = new HashSet<Cell>(this.getCells());
        return thisCellsSet.equals(productCellsSet = new HashSet<Cell>(product.getCells()));
    }

    public int hashCode() {
        return Objects.hash(this.getName(), new HashSet<Cell>(this.getCells()));
    }

    public PCMElement clone(PCMFactory factory) {
        Product copy = factory.createProduct();
        copy.setName(this.getName());
        for (Cell cell : this.getCells()) {
            copy.addCell((Cell)cell.clone(factory));
        }
        return copy;
    }
}

