/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IONode<T> {
    private T content;
    private List<IONode<T>> children = new ArrayList<IONode<T>>();
    private Set<Integer> positions = new HashSet<Integer>();

    public IONode(T content) {
        this.content = content;
    }

    public T getContent() {
        return this.content;
    }

    public void setContent(T content) {
        this.content = content;
    }

    public List<IONode<T>> getChildren() {
        return this.children;
    }

    public Set<Integer> getPositions() {
        return this.positions;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public List<IONode<T>> getLeaves() {
        ArrayList<IONode<T>> result = new ArrayList<IONode<T>>();
        if (this.isLeaf()) {
            result.add(this);
        } else {
            for (IONode<T> child : this.children) {
                result.addAll(child.getLeaves());
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IONode ioNode = (IONode)o;
        if (this.content != null ? !this.content.equals(ioNode.content) : ioNode.content != null) {
            return false;
        }
        return !(this.children == null ? ioNode.children != null : !this.children.equals(ioNode.children));
    }

    public int hashCode() {
        int result = this.content != null ? this.content.hashCode() : 0;
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IONode{content=" + this.content + '}';
    }
}

