/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import processing.app.RunnerListener;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.mode.java.JavaBuild;
import processing.mode.java.JavaEditor;
import processing.mode.java.VariableInspector;
import processing.mode.java.debug.ArrayFieldNode;
import processing.mode.java.debug.ClassLoadListener;
import processing.mode.java.debug.FieldNode;
import processing.mode.java.debug.LineBreakpoint;
import processing.mode.java.debug.LineID;
import processing.mode.java.debug.LocalVariableNode;
import processing.mode.java.debug.VariableNode;
import processing.mode.java.runner.Runner;

public class Debugger {
    protected JavaEditor editor;
    protected Runner runtime;
    protected boolean started = false;
    protected boolean paused = false;
    protected ThreadReference currentThread;
    protected String mainClassName;
    protected ReferenceType mainClass;
    protected Set<ReferenceType> classes = new HashSet<ReferenceType>();
    protected List<ClassLoadListener> classLoadListeners = new ArrayList<ClassLoadListener>();
    protected String srcPath;
    protected List<LineBreakpoint> breakpoints = new ArrayList<LineBreakpoint>();
    protected StepRequest requestedStep;
    protected Map<LineID, LineID> runtimeLineChanges = new HashMap<LineID, LineID>();
    protected Set<String> runtimeTabsTracked = new HashSet<String>();
    protected VMEventListener vmEventListener = this::vmEvent;

    public Debugger(JavaEditor editor) {
        this.editor = editor;
    }

    public VirtualMachine vm() {
        if (this.runtime != null) {
            return this.runtime.vm();
        }
        return null;
    }

    public JavaEditor getEditor() {
        return this.editor;
    }

    public ReferenceType getMainClass() {
        if (this.isStarted()) {
            return this.mainClass;
        }
        return null;
    }

    public ReferenceType getClass(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals(this.mainClassName)) {
            return this.mainClass;
        }
        for (ReferenceType rt : this.classes) {
            if (!rt.name().equals(name)) continue;
            return rt;
        }
        return null;
    }

    public void addClassLoadListener(ClassLoadListener listener) {
        this.classLoadListeners.add(listener);
    }

    public void removeClassLoadListener(ClassLoadListener listener) {
        this.classLoadListeners.remove(listener);
    }

    public synchronized void startDebug() {
        if (this.isStarted()) {
            return;
        }
        this.editor.statusBusy();
        this.editor.clearConsole();
        this.editor.variableInspector().reset();
        this.editor.prepareRun();
        this.editor.activateDebug();
        try {
            Sketch sketch = this.editor.getSketch();
            JavaBuild build = new JavaBuild(sketch);
            Debugger.log(Level.INFO, "building sketch: {0}", sketch.getName());
            this.mainClassName = build.build(true);
            Debugger.log(Level.INFO, "class: {0}", this.mainClassName);
            this.srcPath = build.getSrcFolder().getPath();
            Debugger.log(Level.INFO, "build src: {0}", this.srcPath);
            Debugger.log(Level.INFO, "build bin: {0}", build.getBinFolder().getPath());
            if (this.mainClassName != null) {
                Debugger.log(Level.INFO, "launching debuggee runtime");
                this.runtime = new Runner(build, (RunnerListener)this.editor);
                VirtualMachine vm = this.runtime.debug(null);
                if (vm == null) {
                    Debugger.log(Level.SEVERE, "error 37: launch failed");
                }
                VMEventReader eventThread = new VMEventReader(vm.eventQueue(), this.vmEventListener);
                eventThread.start();
                this.startTrackingLineChanges();
                this.editor.statusBusy();
            }
        }
        catch (Exception e) {
            this.editor.statusError(e);
        }
    }

    public synchronized void stopDebug() {
        this.editor.variableInspector().lock();
        if (this.runtime != null) {
            Debugger.log(Level.INFO, "closing runtime");
            this.runtime.close();
            this.runtime = null;
            this.classes.clear();
            this.editor.clearCurrentLine();
        }
        this.stopTrackingLineChanges();
        this.started = false;
        this.editor.deactivateDebug();
        this.editor.deactivateContinue();
        this.editor.deactivateStep();
        this.editor.statusEmpty();
    }

    public synchronized void continueDebug() {
        this.editor.activateContinue();
        this.editor.variableInspector().lock();
        this.editor.clearCurrentLine();
        if (!this.isStarted()) {
            this.startDebug();
        } else if (this.isPaused()) {
            this.runtime.vm().resume();
            this.paused = false;
            this.editor.statusBusy();
        }
    }

    protected void step(int stepDepth) {
        if (!this.isStarted()) {
            this.startDebug();
        } else if (this.isPaused()) {
            this.editor.variableInspector().lock();
            this.editor.activateStep();
            this.requestedStep = this.runtime.vm().eventRequestManager().createStepRequest(this.currentThread, -2, stepDepth);
            this.requestedStep.addCountFilter(1);
            this.requestedStep.enable();
            this.paused = false;
            this.runtime.vm().resume();
            this.editor.statusBusy();
        }
    }

    public synchronized void stepOver() {
        this.step(2);
    }

    public synchronized void stepInto() {
        this.step(1);
    }

    public synchronized void stepOut() {
        this.step(3);
    }

    synchronized void setBreakpoint() {
        this.setBreakpoint(this.editor.getCurrentLineID());
    }

    synchronized void setBreakpoint(int lineIdx) {
        this.setBreakpoint(this.editor.getLineIDInCurrentTab(lineIdx));
    }

    synchronized void setBreakpoint(LineID line) {
        if (this.isStarted() && !this.isPaused()) {
            return;
        }
        if (this.hasBreakpoint(line)) {
            return;
        }
        this.breakpoints.add(new LineBreakpoint(line, this));
        Debugger.log(Level.INFO, "set breakpoint on line {0}", line);
    }

    synchronized void removeBreakpoint() {
        this.removeBreakpoint(this.editor.getCurrentLineID().lineIdx());
    }

    void removeBreakpoint(int lineIdx) {
        if (this.isBusy()) {
            return;
        }
        LineBreakpoint bp = this.breakpointOnLine(this.editor.getLineIDInCurrentTab(lineIdx));
        if (bp != null) {
            bp.remove();
            this.breakpoints.remove(bp);
            Debugger.log(Level.INFO, "removed breakpoint {0}", bp);
        }
    }

    synchronized void clearBreakpoints() {
        if (this.isBusy()) {
            Debugger.log(Level.WARNING, "busy");
            return;
        }
        for (LineBreakpoint bp : this.breakpoints) {
            bp.remove();
        }
        this.breakpoints.clear();
    }

    synchronized void clearBreakpoints(String tabFilename) {
        if (this.isBusy()) {
            Debugger.log(Level.WARNING, "busy");
            return;
        }
        Iterator<LineBreakpoint> i = this.breakpoints.iterator();
        while (i.hasNext()) {
            LineBreakpoint bp = i.next();
            if (!bp.lineID().fileName().equals(tabFilename)) continue;
            bp.remove();
            i.remove();
        }
    }

    LineBreakpoint breakpointOnLine(LineID line) {
        for (LineBreakpoint bp : this.breakpoints) {
            if (!bp.isOnLine(line)) continue;
            return bp;
        }
        return null;
    }

    synchronized void toggleBreakpoint(int lineIdx) {
        LineID line = this.editor.getLineIDInCurrentTab(lineIdx);
        int index = line.lineIdx();
        if (this.hasBreakpoint(line)) {
            this.removeBreakpoint(index);
        } else if (this.editor.getLineText(index).trim().length() != 0) {
            this.setBreakpoint(index);
        }
    }

    protected boolean hasBreakpoint(LineID line) {
        LineBreakpoint bp = this.breakpointOnLine(line);
        return bp != null;
    }

    synchronized List<LineBreakpoint> getBreakpoints(String tabFilename) {
        ArrayList<LineBreakpoint> list = new ArrayList<LineBreakpoint>();
        for (LineBreakpoint bp : this.breakpoints) {
            if (!bp.lineID().fileName().equals(tabFilename)) continue;
            list.add(bp);
        }
        return list;
    }

    public synchronized void vmEvent(EventSet es) {
        for (Event e : es) {
            Debugger.log(Level.INFO, "*** VM Event: {0}", e.toString());
            if (e instanceof VMStartEvent) {
                this.vmStartEvent();
                continue;
            }
            if (e instanceof ClassPrepareEvent) {
                this.vmClassPrepareEvent((ClassPrepareEvent)e);
                continue;
            }
            if (e instanceof BreakpointEvent) {
                this.vmBreakPointEvent((BreakpointEvent)e);
                continue;
            }
            if (e instanceof StepEvent) {
                this.vmStepEvent((StepEvent)e);
                continue;
            }
            if (e instanceof VMDisconnectEvent) {
                this.stopDebug();
                continue;
            }
            if (!(e instanceof VMDeathEvent)) continue;
            this.started = false;
            this.editor.statusEmpty();
        }
    }

    private void vmStartEvent() {
        Debugger.log(Level.INFO, "requesting event on main class load: {0}", this.mainClassName);
        ClassPrepareRequest mainClassPrepare = this.runtime.vm().eventRequestManager().createClassPrepareRequest();
        mainClassPrepare.addClassFilter(this.mainClassName);
        mainClassPrepare.enable();
        for (SketchCode tab : this.editor.getSketch().getCode()) {
            if (!tab.isExtension("java")) continue;
            Debugger.log(Level.INFO, "requesting event on class load: {0}", tab.getPrettyName());
            ClassPrepareRequest customClassPrepare = this.runtime.vm().eventRequestManager().createClassPrepareRequest();
            customClassPrepare.addClassFilter(tab.getPrettyName());
            customClassPrepare.enable();
        }
        this.runtime.vm().resume();
    }

    private void vmClassPrepareEvent(ClassPrepareEvent ce) {
        ReferenceType rt = ce.referenceType();
        this.currentThread = ce.thread();
        this.paused = true;
        if (rt.name().equals(this.mainClassName)) {
            this.mainClass = rt;
            Debugger.log(Level.INFO, "main class load: {0}", rt.name());
            this.started = true;
        } else {
            this.classes.add(rt);
            Debugger.log(Level.INFO, "class load: {0}", rt.name());
        }
        for (ClassLoadListener listener : this.classLoadListeners) {
            if (listener == null) continue;
            listener.classLoaded(rt);
        }
        this.paused = false;
        this.runtime.vm().resume();
    }

    private void vmBreakPointEvent(BreakpointEvent be) {
        this.currentThread = be.thread();
        this.updateVariableInspector(this.currentThread);
        final LineID newCurrentLine = this.locationToLineID(be.location());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Debugger.this.editor.setCurrentLine(newCurrentLine);
                Debugger.this.editor.deactivateStep();
                Debugger.this.editor.deactivateContinue();
            }
        });
        if (this.requestedStep != null) {
            this.runtime.vm().eventRequestManager().deleteEventRequest(this.requestedStep);
            this.requestedStep = null;
        }
        this.resumeOtherThreads(this.currentThread);
        this.paused = true;
        this.editor.statusHalted();
    }

    private void vmStepEvent(StepEvent se) {
        this.currentThread = se.thread();
        this.updateVariableInspector(this.currentThread);
        final LineID newCurrentLine = this.locationToLineID(se.location());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Debugger.this.editor.setCurrentLine(newCurrentLine);
                Debugger.this.editor.deactivateStep();
                Debugger.this.editor.deactivateContinue();
            }
        });
        EventRequestManager mgr = this.runtime.vm().eventRequestManager();
        mgr.deleteEventRequest(se.request());
        this.requestedStep = null;
        this.paused = true;
        this.editor.statusHalted();
        if (!this.locationIsVisible(se.location())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Debugger.this.stepOutIntoViewOrContinue();
                }
            });
        }
    }

    protected boolean locationIsVisible(Location l) {
        return this.locationToLineID(l) != null;
    }

    protected void stepOutIntoViewOrContinue() {
        try {
            List<StackFrame> frames = this.currentThread.frames();
            if (frames.size() > 1 && this.locationIsVisible(frames.get(1).location())) {
                this.stepOut();
                return;
            }
            this.continueDebug();
        }
        catch (IncompatibleThreadStateException ex) {
            Debugger.log(Level.SEVERE, null, ex);
        }
    }

    public synchronized boolean isStarted() {
        return this.started && this.runtime != null && this.runtime.vm() != null;
    }

    public synchronized boolean isPaused() {
        return this.isStarted() && this.paused && this.currentThread != null && this.currentThread.isSuspended();
    }

    public synchronized boolean isBusy() {
        return this.isStarted() && !this.isPaused();
    }

    protected void printStackTrace(ThreadReference t) {
        if (!t.isSuspended()) {
            return;
        }
        try {
            System.out.println("stack trace for thread " + t.name() + ":");
            int i = 0;
            for (StackFrame f : t.frames()) {
                System.out.println(i++ + ": " + f.toString());
            }
        }
        catch (IncompatibleThreadStateException ex) {
            Debugger.log(Level.SEVERE, null, ex);
        }
    }

    protected void resumeOtherThreads(ThreadReference t) {
        if (!this.isStarted()) {
            return;
        }
        for (ThreadReference other : this.vm().allThreads()) {
            if (other.equals(t) || !other.isSuspended()) continue;
            other.resume();
        }
    }

    public synchronized void printThreads() {
        if (!this.isPaused()) {
            return;
        }
        System.out.println("threads:");
        for (ThreadReference t : this.vm().allThreads()) {
            this.printThread(t);
        }
    }

    protected void printThread(ThreadReference t) {
        System.out.println(t.name());
        System.out.println("   is suspended: " + t.isSuspended());
        System.out.println("   is at breakpoint: " + t.isAtBreakpoint());
        System.out.println("   status: " + this.threadStatusToString(t.status()));
    }

    protected String threadStatusToString(int status) {
        switch (status) {
            case 3: {
                return "THREAD_STATUS_MONITOR";
            }
            case 5: {
                return "THREAD_STATUS_NOT_STARTED";
            }
            case 1: {
                return "THREAD_STATUS_RUNNING";
            }
            case 2: {
                return "THREAD_STATUS_SLEEPING";
            }
            case -1: {
                return "THREAD_STATUS_UNKNOWN";
            }
            case 4: {
                return "THREAD_STATUS_WAIT";
            }
            case 0: {
                return "THREAD_STATUS_ZOMBIE";
            }
        }
        return "";
    }

    protected void printLocalVariables(ThreadReference t) {
        if (!t.isSuspended()) {
            return;
        }
        try {
            if (t.frameCount() == 0) {
                System.out.println("call stack empty");
            } else {
                StackFrame sf = t.frame(0);
                List<LocalVariable> locals = sf.visibleVariables();
                if (locals.isEmpty()) {
                    System.out.println("no local variables");
                    return;
                }
                for (LocalVariable lv : locals) {
                    System.out.println(lv.typeName() + " " + lv.name() + " = " + sf.getValue(lv));
                }
            }
        }
        catch (IncompatibleThreadStateException ex) {
            Debugger.log(Level.SEVERE, null, ex);
        }
        catch (AbsentInformationException ex) {
            System.out.println("local variable information not available");
        }
    }

    protected void updateVariableInspector(ThreadReference t) {
        if (!t.isSuspended()) {
            return;
        }
        try {
            if (t.frameCount() == 0) {
                Debugger.log(Level.WARNING, "call stack empty");
            } else {
                final VariableInspector vi = this.editor.variableInspector();
                final List<DefaultMutableTreeNode> stackTrace = this.getStackTrace(t);
                final List<VariableNode> locals = this.getLocals(t, 0);
                final String currentLocation = this.currentLocation(t);
                final List<VariableNode> thisFields = this.getThisFields(t, 0, true);
                final List<VariableNode> declaredThisFields = this.getThisFields(t, 0, false);
                final String thisName = this.thisName(t);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        vi.updateCallStack(stackTrace, "Call Stack");
                        vi.updateLocals(locals, "Locals at " + currentLocation);
                        vi.updateThisFields(thisFields, "Class " + thisName);
                        vi.updateDeclaredThisFields(declaredThisFields, "Class " + thisName);
                        vi.unlock();
                        vi.rebuild();
                    }
                });
            }
        }
        catch (IncompatibleThreadStateException ex) {
            Debugger.log(Level.SEVERE, null, ex);
        }
    }

    protected String thisName(ThreadReference t) {
        try {
            if (!t.isSuspended() || t.frameCount() == 0) {
                return "";
            }
            ObjectReference ref = t.frame(0).thisObject();
            return ref == null ? "" : ref.referenceType().name();
        }
        catch (IncompatibleThreadStateException ex) {
            Debugger.log(Level.SEVERE, null, ex);
            return "";
        }
    }

    protected String currentLocation(ThreadReference t) {
        try {
            if (!t.isSuspended() || t.frameCount() == 0) {
                return "";
            }
            return this.locationToString(t.frame(0).location());
        }
        catch (IncompatibleThreadStateException ex) {
            Debugger.log(Level.SEVERE, null, ex);
            return "";
        }
    }

    protected String locationToString(Location loc) {
        LineID line = this.locationToLineID(loc);
        int lineNumber = line != null ? line.lineIdx() + 1 : loc.lineNumber();
        return loc.declaringType().name() + "." + loc.method().name() + ":" + lineNumber;
    }

    protected List<VariableNode> getLocals(ThreadReference t, int depth) {
        ArrayList<VariableNode> vars = new ArrayList<VariableNode>();
        try {
            if (t.frameCount() > 0) {
                StackFrame sf = t.frame(0);
                for (LocalVariable lv : sf.visibleVariables()) {
                    Value val = sf.getValue(lv);
                    LocalVariableNode var = new LocalVariableNode(lv.name(), lv.typeName(), val, lv, sf);
                    if (depth > 0) {
                        var.addChildren(this.getFields(val, depth - 1, true));
                    }
                    vars.add(var);
                }
            }
        }
        catch (IncompatibleThreadStateException ex) {
            Debugger.log(Level.SEVERE, null, ex);
        }
        catch (AbsentInformationException ex) {
            Debugger.log(Level.WARNING, "local variable information not available", ex);
        }
        return vars;
    }

    protected List<VariableNode> getThisFields(ThreadReference t, int depth, boolean includeInherited) {
        try {
            if (t.frameCount() > 0) {
                StackFrame sf = t.frame(0);
                ObjectReference thisObj = sf.thisObject();
                return this.getFields(thisObj, depth, includeInherited);
            }
        }
        catch (IncompatibleThreadStateException ex) {
            Debugger.log(Level.SEVERE, null, ex);
        }
        return new ArrayList<VariableNode>();
    }

    protected List<VariableNode> getFields(Value value, int depth, int maxDepth, boolean includeInherited) {
        ArrayList<VariableNode> vars = new ArrayList<VariableNode>();
        if (depth <= maxDepth) {
            if (value instanceof ArrayReference) {
                return this.getArrayFields((ArrayReference)value);
            }
            if (value instanceof ObjectReference) {
                ObjectReference obj = (ObjectReference)value;
                List<Field> fields = includeInherited ? obj.referenceType().visibleFields() : obj.referenceType().fields();
                for (Field field : fields) {
                    Value val = obj.getValue(field);
                    FieldNode var = new FieldNode(field.name(), field.typeName(), val, field, obj);
                    if (val != null) {
                        var.addChildren(this.getFields(val, depth + 1, maxDepth, includeInherited));
                    }
                    vars.add(var);
                }
            }
        }
        return vars;
    }

    public List<VariableNode> getFields(Value value, int maxDepth, boolean includeInherited) {
        return this.getFields(value, 0, maxDepth, includeInherited);
    }

    protected List<VariableNode> getArrayFields(ArrayReference array) {
        ArrayList<VariableNode> fields = new ArrayList<VariableNode>();
        if (array != null) {
            String arrayType = array.type().name();
            if (arrayType.endsWith("[]")) {
                arrayType = arrayType.substring(0, arrayType.length() - 2);
            }
            int i = 0;
            for (Value val : array.getValues()) {
                ArrayFieldNode var = new ArrayFieldNode("[" + i + "]", arrayType, val, array, i);
                fields.add(var);
                ++i;
            }
        }
        return fields;
    }

    protected List<DefaultMutableTreeNode> getStackTrace(ThreadReference t) {
        ArrayList<DefaultMutableTreeNode> stack = new ArrayList<DefaultMutableTreeNode>();
        try {
            for (StackFrame f : t.frames()) {
                stack.add(new DefaultMutableTreeNode(this.locationToString(f.location())));
            }
        }
        catch (IncompatibleThreadStateException ex) {
            Debugger.log(Level.SEVERE, null, ex);
        }
        return stack;
    }

    protected void printThis(ThreadReference t) {
        if (!t.isSuspended()) {
            return;
        }
        try {
            if (t.frameCount() == 0) {
                System.out.println("call stack empty");
            } else {
                StackFrame sf = t.frame(0);
                ObjectReference thisObject = sf.thisObject();
                if (thisObject != null) {
                    ReferenceType type = thisObject.referenceType();
                    System.out.println("fields in this (" + type.name() + "):");
                    for (Field f : type.visibleFields()) {
                        System.out.println(f.typeName() + " " + f.name() + " = " + thisObject.getValue(f));
                    }
                } else {
                    System.out.println("can't get this (in native or static method)");
                }
            }
        }
        catch (IncompatibleThreadStateException ex) {
            Debugger.log(Level.SEVERE, null, ex);
        }
    }

    protected void printSourceLocation(ThreadReference t) {
        try {
            if (t.frameCount() == 0) {
                System.out.println("call stack empty");
            } else {
                Location l = t.frame(0).location();
                this.printSourceLocation(l);
            }
        }
        catch (IncompatibleThreadStateException ex) {
            Debugger.log(Level.SEVERE, null, ex);
        }
    }

    protected void printSourceLocation(Location l) {
        try {
            System.out.println("in method " + l.method() + ":");
            System.out.println(this.getSourceLine(l.sourcePath(), l.lineNumber(), 2));
        }
        catch (AbsentInformationException ex) {
            Debugger.log(Level.SEVERE, null, ex);
        }
    }

    protected String getSourceLine(String filePath, int lineNo, int radius) {
        if (lineNo == -1) {
            Debugger.log(Level.SEVERE, "invalid line number: {0}", lineNo);
            return "";
        }
        File f = new File(this.srcPath + File.separator + filePath);
        String output = "";
        try {
            String line;
            BufferedReader r = new BufferedReader(new FileReader(f));
            for (int i = 1; i <= lineNo + radius && (line = r.readLine()) != null; ++i) {
                if (i < lineNo - radius) continue;
                if (i > lineNo - radius) {
                    output = output + "\n";
                }
                output = output + f.getName() + ":" + i + (i == lineNo ? " =>  " : "     ") + line;
            }
            r.close();
            return output;
        }
        catch (FileNotFoundException ex) {
            return f.getName() + ":" + lineNo;
        }
        catch (IOException ex) {
            Debugger.log(Level.SEVERE, null, ex);
            return "";
        }
    }

    protected void printType(ReferenceType rt) {
        System.out.println("ref.type: " + rt);
        System.out.println("name: " + rt.name());
        try {
            System.out.println("sourceName: " + rt.sourceName());
        }
        catch (AbsentInformationException ex) {
            System.out.println("sourceName: unknown");
        }
        System.out.println("methods:");
        for (Method m : rt.methods()) {
            System.out.println(m.toString());
        }
    }

    protected LineID locationToLineID(Location l) {
        try {
            return this.javaToSketchLine(new LineID(l.sourceName(), l.lineNumber() - 1));
        }
        catch (AbsentInformationException ex) {
            Debugger.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public LineID javaToSketchLine(LineID javaLine) {
        Sketch sketch = this.editor.getSketch();
        SketchCode tab = this.editor.getTab(javaLine.fileName());
        if (tab != null && tab.isExtension("java")) {
            return this.originalToRuntimeLine(javaLine);
        }
        if (!javaLine.fileName().equals(sketch.getName() + ".java")) {
            return null;
        }
        for (int i = sketch.getCodeCount() - 1; i >= 0; --i) {
            tab = sketch.getCode(i);
            if (!tab.isExtension("pde") || tab.getPreprocOffset() > javaLine.lineIdx()) continue;
            int index = javaLine.lineIdx() - tab.getPreprocOffset();
            return this.originalToRuntimeLine(new LineID(tab.getFileName(), index));
        }
        return null;
    }

    protected LineID originalToRuntimeLine(LineID line) {
        LineID transformed = this.runtimeLineChanges.get(line);
        if (transformed == null) {
            return line;
        }
        return transformed;
    }

    protected LineID runtimeToOriginalLine(LineID line) {
        for (Map.Entry<LineID, LineID> entry : this.runtimeLineChanges.entrySet()) {
            if (!entry.getValue().equals(line)) continue;
            return entry.getKey();
        }
        return line;
    }

    public LineID sketchToJavaLine(LineID sketchLine) {
        SketchCode tab = this.editor.getTab((sketchLine = this.runtimeToOriginalLine(sketchLine)).fileName());
        if (tab == null) {
            return null;
        }
        if (tab.isExtension("java")) {
            return sketchLine;
        }
        LineID javaLine = new LineID(this.editor.getSketch().getName() + ".java", sketchLine.lineIdx() + tab.getPreprocOffset());
        return javaLine;
    }

    protected void startTrackingLineChanges() {
        SketchCode tab = this.editor.getSketch().getCurrentCode();
        if (this.runtimeTabsTracked.contains(tab.getFileName())) {
            return;
        }
        for (int i = 0; i < tab.getLineCount(); ++i) {
            LineID old = new LineID(tab.getFileName(), i);
            LineID tracked = new LineID(tab.getFileName(), i);
            tracked.startTracking(this.editor.currentDocument());
            this.runtimeLineChanges.put(old, tracked);
        }
        this.runtimeTabsTracked.add(tab.getFileName());
    }

    protected void stopTrackingLineChanges() {
        for (LineID tracked : this.runtimeLineChanges.values()) {
            tracked.stopTracking();
        }
        this.runtimeLineChanges.clear();
        this.runtimeTabsTracked.clear();
    }

    private static void log(Level level, String msg) {
        Logger.getLogger(Debugger.class.getName()).log(level, msg);
    }

    private static void log(Level level, String msg, Object obj) {
        Logger.getLogger(Debugger.class.getName()).log(level, msg, obj);
    }

    protected static class VMEventReader
    extends Thread {
        EventQueue eventQueue;
        VMEventListener listener;

        public VMEventReader(EventQueue eventQueue, VMEventListener listener) {
            super("VM Event Thread");
            this.eventQueue = eventQueue;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    EventSet eventSet = this.eventQueue.remove();
                    this.listener.vmEvent(eventSet);
                }
            }
            catch (VMDisconnectedException e) {
                Logger.getLogger(VMEventReader.class.getName()).log(Level.INFO, "VMEventReader quit on VM disconnect");
            }
            catch (Exception e) {
                Logger.getLogger(VMEventReader.class.getName()).log(Level.SEVERE, "VMEventReader quit", e);
            }
        }
    }

    protected static interface VMEventListener {
        public void vmEvent(EventSet var1);
    }
}

