/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.data.CommandArgPrefixes;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.struct.Relation;

public abstract class AbstractOption<T>
extends AbstractOperand<T>
implements Option<T> {
    private String _shortOption;
    private String _longOption;

    public AbstractOption(String string, String string2, Class<T> clazz, String string3, String string4) {
        super(clazz, string3, string4);
        if (string != null && (!string.startsWith(CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix()) || string.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix()))) {
            throw new IllegalArgumentException("Your short-option \"" + string + "\" must start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        if (string2 != null && !string2.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix())) {
            throw new IllegalArgumentException("Your long-option \"" + string2 + "\" must start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        this._shortOption = string;
        this._longOption = string2;
    }

    protected AbstractOption(String string, String string2, Class<T> clazz, String string3) {
        super(clazz, null, string3);
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("You must provide at least a short-option or a long-option!");
        }
        if (!string.startsWith(CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix()) || string.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix())) {
            throw new IllegalArgumentException("Your short-option \"" + string + "\" must start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        if (!string2.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix())) {
            throw new IllegalArgumentException("Your long-option \"" + string2 + "\" must start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        this._shortOption = string;
        this._longOption = string2;
    }

    public AbstractOption(Relation<String, T> relation, Class<T> clazz) {
        super(relation, clazz);
    }

    @Override
    public List<Operand<T>> parseArgs(String[] stringArray, String[] stringArray2) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        Relation<String, String> relation = CliUtility.getOptionArgument(this, stringArray, stringArray2);
        if (relation != null) {
            ArrayList<Operand<T>> arrayList = new ArrayList<Operand<T>>();
            arrayList.add(this);
            this.setArgs(new String[]{(String)relation.getKey(), (String)relation.getValue()});
            this.setValue(this.toType((String)relation.getValue()));
            return arrayList;
        }
        if (CliUtility.contains(stringArray, this.getShortOption())) {
            throw new ParseArgsException(stringArray, "Missing value; the short-option \"" + this.getShortOption() + "\" requires a value.");
        }
        if (CliUtility.contains(stringArray, this.getLongOption())) {
            throw new ParseArgsException(stringArray, "Missing value; the long-option \"" + this.getLongOption() + "\" requires a value.");
        }
        throw new UnknownArgsException(stringArray, "Neither the short-option \"" + this.getShortOption() + "\" nor the long-option \"" + this.getLongOption() + "\"  was found in the command line arguments; at least one of them must be specified.");
    }

    @Override
    public String getShortOption() {
        return this._shortOption;
    }

    @Override
    public String getLongOption() {
        return this._longOption;
    }

    @Override
    public String toSyntax(SyntaxNotation syntaxNotation, String string, String string2) {
        string = string == null ? "" : string;
        string2 = string2 == null ? "" : string2;
        return string + (this.getShortOption() != null ? this.getShortOption() : this.getLongOption()) + (String)(this.getAlias() != null ? " " + CliUtility.toParameterSpec(this) : "") + string2;
    }

    @Override
    public String toState() {
        String string = null;
        if (this.getShortOption() != null) {
            string = this.getShortOption();
        } else if (this.getLongOption() != null) {
            string = this.getLongOption();
        }
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(":=");
            if (this.getValue() != null) {
                if (this.getValue() instanceof String) {
                    stringBuilder.append('\"');
                }
                stringBuilder.append(this.getValue().toString());
                if (this.getValue() instanceof String) {
                    stringBuilder.append('\"');
                }
            } else {
                stringBuilder.append("null");
            }
            return stringBuilder.toString();
        }
        return "null";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected String[] getOptionPrefixes() {
        OperatingSystem operatingSystem = OperatingSystem.toOperatingSystem();
        if (operatingSystem == OperatingSystem.MAC) {
            return CommandArgPrefixes.POSIX.toPrefixes();
        }
        if (operatingSystem == OperatingSystem.UNIX) {
            return CommandArgPrefixes.POSIX.toPrefixes();
        }
        if (operatingSystem == OperatingSystem.WINDOWS) {
            return CommandArgPrefixes.WINDOWS.toPrefixes();
        }
        return CommandArgPrefix.toPrefixes();
    }

    @Override
    protected void setValue(T t) {
        super.setValue(t);
    }

    @Override
    protected void setArgs(String[] stringArray) {
        super.setArgs(stringArray);
    }
}

