/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractSyntaxable;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.struct.Relation;
import org.refcodes.textual.VerboseTextBuilder;

public abstract class AbstractOperand<T>
extends AbstractSyntaxable
implements Operand<T> {
    private Class<T> _type;
    private String _alias;
    private String _description;
    private String[] _args = null;
    protected T _value = null;

    public AbstractOperand(Class<T> clazz, String string, String string2) {
        this._type = clazz;
        this._alias = string;
        this._description = string2;
    }

    public AbstractOperand(Relation<String, T> relation, Class<T> clazz) {
        this._alias = (String)relation.getKey();
        this._value = relation.getValue();
        this._type = clazz;
    }

    public List<Operand<T>> parseArgs(String[] stringArray, String[] stringArray2) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        int n = -1;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (CliUtility.isOptionArgument(stringArray[i]) || n != -1 && n + -1 != i) continue;
            n = i;
        }
        if (n != -1) {
            ArrayList<Operand<T>> arrayList = new ArrayList<Operand<T>>();
            arrayList.add(this);
            this.setValue(this.toType(stringArray[n]));
            this.setArgs(new String[]{stringArray[n]});
            return arrayList;
        }
        throw new UnknownArgsException(stringArray, "Unable to determine an operand (not being prefixed with " + new VerboseTextBuilder().withElements((Object[])CommandArgPrefix.toPrefixes()).toString() + ").");
    }

    public String getDescription() {
        return this._description;
    }

    @Override
    public String toSyntax(SyntaxNotation syntaxNotation, String string, String string2, String string3) {
        string = string == null ? "" : string;
        string2 = string2 == null ? "" : string2;
        string3 = string3 == null ? "" : string3;
        return CliUtility.toParameterSpec(this, string2, string3);
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    public Class<T> getType() {
        return this._type;
    }

    @Override
    public T getValue() {
        return this._value;
    }

    @Override
    public String[] getArgs() {
        return this._args;
    }

    public void reset() {
        this._args = null;
        this._value = null;
    }

    @Override
    public String toState() {
        if (this._value != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getValue() instanceof String) {
                stringBuilder.append('\"');
            }
            stringBuilder.append(this._value.toString());
            if (this.getValue() instanceof String) {
                stringBuilder.append('\"');
            }
            return stringBuilder.toString();
        }
        return "null";
    }

    public String toString() {
        return this.toState();
    }

    @Override
    public int compareTo(Operand<?> operand) {
        if (operand instanceof Option) {
            if (this instanceof Option) {
                String string = ((Option)operand).getShortOption() != null ? ((Option)operand).getShortOption() : ((Option)operand).getLongOption();
                String string2 = ((Option)((Object)this)).getShortOption() != null ? ((Option)((Object)this)).getShortOption() : ((Option)((Object)this)).getLongOption();
                return string2.compareTo(string);
            }
            if (this instanceof Operand) {
                return 1;
            }
        }
        if (operand instanceof Operand && this instanceof Option) {
            return -11;
        }
        if (this.getAlias() != null && operand.getAlias() != null) {
            return this.getAlias().compareTo(operand.getAlias());
        }
        return this.toSyntax().compareTo(operand.toSyntax());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void setValue(T t) {
        this._value = t;
    }

    protected void setArgs(String[] stringArray) {
        this._args = stringArray;
    }

    protected abstract T toType(String var1) throws ParseArgsException;
}

