/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractSyntaxable;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.struct.Relation;
import org.refcodes.textual.VerboseTextBuilder;

public abstract class AbstractOperand<T>
extends AbstractSyntaxable
implements Operand<T> {
    private Class<T> _type;
    private String _alias;
    private String _description;
    private String[] _args = null;
    protected T _value = null;

    public AbstractOperand(Class<T> aType, String aAlias, String aDescription) {
        this._type = aType;
        this._alias = aAlias;
        this._description = aDescription;
    }

    public AbstractOperand(Relation<String, T> aProperty, Class<T> aType) {
        this._alias = (String)aProperty.getKey();
        this._value = aProperty.getValue();
        this._type = aType;
    }

    public List<Operand<T>> parseArgs(String[] aArgs, String[] aOptions) throws ArgsSyntaxException {
        int first = -1;
        for (int i = aArgs.length - 1; i >= 0; --i) {
            if (CliUtility.isOptionArgument(aArgs[i]) || first != -1 && first + -1 != i) continue;
            first = i;
        }
        if (first != -1) {
            ArrayList<Operand<T>> theList = new ArrayList<Operand<T>>();
            theList.add(this);
            this.setValue(this.toType(aArgs[first]));
            this.setArgs(new String[]{aArgs[first]});
            return theList;
        }
        throw new UnknownArgsException(aArgs, "Unable to parse any args (not being prefixed with " + new VerboseTextBuilder().withElements((Object[])CommandArgPrefix.toPrefixes()).toString() + ").");
    }

    public String getDescription() {
        return this._description;
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        aOptEscCode = aOptEscCode == null ? "" : aOptEscCode;
        aParamEscCode = aParamEscCode == null ? "" : aParamEscCode;
        aResetEscCode = aResetEscCode == null ? "" : aResetEscCode;
        return CliUtility.toParameterSpec(this, aParamEscCode, aResetEscCode);
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    public Class<T> getType() {
        return this._type;
    }

    @Override
    public T getValue() {
        return this._value;
    }

    @Override
    public String[] getArgs() {
        return this._args;
    }

    public void reset() {
        this._args = null;
        this._value = null;
    }

    @Override
    public String toState() {
        if (this._value != null) {
            StringBuilder theBuilder = new StringBuilder();
            if (this.getValue() instanceof String) {
                theBuilder.append('\"');
            }
            theBuilder.append(this._value.toString());
            if (this.getValue() instanceof String) {
                theBuilder.append('\"');
            }
            return theBuilder.toString();
        }
        return "null";
    }

    public String toString() {
        return this.toState();
    }

    @Override
    public int compareTo(Operand<?> obj) {
        if (obj instanceof Option) {
            if (this instanceof Option) {
                String otherOption = ((Option)obj).getShortOption() != null ? ((Option)obj).getShortOption() : ((Option)obj).getLongOption();
                String thisOption = ((Option)((Object)this)).getShortOption() != null ? ((Option)((Object)this)).getShortOption() : ((Option)((Object)this)).getLongOption();
                return thisOption.compareTo(otherOption);
            }
            if (this instanceof Operand) {
                return 1;
            }
        }
        if (obj instanceof Operand && this instanceof Option) {
            return -11;
        }
        if (this.getAlias() != null && obj.getAlias() != null) {
            return this.getAlias().compareTo(obj.getAlias());
        }
        return this.toSyntax().compareTo(obj.toSyntax());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public CliSchema toSchema() {
        return new CliSchema(this.getClass(), this._alias, this._description, this._value);
    }

    protected void setValue(T aValue) {
        this._value = aValue;
    }

    protected void setArgs(String[] aArgs) {
        this._args = aArgs;
    }

    protected abstract T toType(String var1) throws ParseArgsException;
}

