/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;

public class AndCondition
extends AbstractCondition
implements Condition {
    private static final String RIGHT_TAG = " )";
    private static final String LEFT_TAG = "( ";
    private static final char GUN_POSIX_AND = ' ';
    private static final String LOGICAL_AND = " & ";

    public AndCondition(Syntaxable ... aArgs) {
        super("All (AND) nested syntaxables must match from the arguments.", aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions) throws ArgsSyntaxException {
        ArrayList theResult = new ArrayList();
        for (Syntaxable eChild : this.getChildren()) {
            List<Operand<?>> eOperands;
            try {
                eOperands = eChild.parseArgs(aArgs, aOptions);
            }
            catch (UnknownArgsException exc) {
                throw new UnknownArgsException(exc.getArgs(), "At least one mandatory syntax did not match the provided command line arguments, though all mandatories must match.", (Throwable)((Object)exc));
            }
            catch (AmbiguousArgsException exc) {
                throw new AmbiguousArgsException(exc.getArgs(), "At least one mandatory syntax did not match the provided command line arguments, though all mandatories must match.", (Throwable)((Object)exc));
            }
            if (eOperands != null && eOperands.size() != 0) {
                theResult.addAll(eOperands);
            }
            aArgs = CliUtility.toDiff(aArgs, eOperands);
        }
        return theResult;
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eChild : this.getChildren()) {
            if (theBuilder.length() != 0) {
                if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                    theBuilder.append(LOGICAL_AND);
                } else {
                    theBuilder.append(' ');
                }
            }
            theBuilder.append(eChild.toSyntax(aSyntaxNotation, aOptEscCode, aParamEscCode, aResetEscCode));
        }
        return theBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eChild : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append(LEFT_TAG);
            } else {
                theBuilder.append(LOGICAL_AND);
            }
            theBuilder.append(eChild.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(RIGHT_TAG);
        }
        return theBuilder.toString();
    }
}

