/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.refcodes.cli.AbstractOption;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.PropertyOption;
import org.refcodes.cli.Term;
import org.refcodes.struct.Relation;
import org.refcodes.struct.RelationImpl;

public abstract class AbstractPropertyOption<T>
extends AbstractOption<T>
implements PropertyOption<T> {
    private static final char PROPERTY_SEPARATOR = '=';

    public AbstractPropertyOption(Character aShortProperty, String aLongProperty, Class<T> aType, String aAlias, String aDescription) {
        super(aShortProperty, aLongProperty, aType, aAlias, aDescription);
        if (aShortProperty == null && (aLongProperty == null || aLongProperty.length() == 0)) {
            throw new IllegalArgumentException("At least the short option <" + (Serializable)(aShortProperty != null ? "'" + aShortProperty + "'" : aShortProperty) + "> must not be null or the long option <" + (String)(aLongProperty != null ? "\"" + aLongProperty + "\"" : aLongProperty) + "> must not be empty!");
        }
    }

    public AbstractPropertyOption(Character aShortProperty, String aLongProperty, Class<T> aType, String aAlias, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        super(aShortProperty, aLongProperty, aType, aAlias, aDescription, aConsumer);
        if (aShortProperty == null && (aLongProperty == null || aLongProperty.length() == 0)) {
            throw new IllegalArgumentException("At least the short option <" + (Serializable)(aShortProperty != null ? "'" + aShortProperty + "'" : aShortProperty) + "> must not be null or the long option <" + (String)(aLongProperty != null ? "\"" + aLongProperty + "\"" : aLongProperty) + "> must not be empty!");
        }
    }

    public AbstractPropertyOption(Relation<String, T> aProperty, Class<T> aType) {
        super(aProperty, aType);
    }

    public AbstractPropertyOption(Relation<String, T> aProperty, Class<T> aType, Consumer<? extends Operand<T>> aConsumer) {
        super(aProperty, aType, aConsumer);
    }

    public AbstractPropertyOption(String aLongProperty, Class<T> aType, String aDescription) {
        super(aLongProperty, aType, aDescription);
    }

    public AbstractPropertyOption(String aLongProperty, Class<T> aType, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        super(aLongProperty, aType, aDescription, aConsumer);
    }

    public AbstractPropertyOption(String aLongProperty, Class<T> aType, String aAlias, String aDescription) {
        super(aLongProperty, aType, aAlias, aDescription);
    }

    public AbstractPropertyOption(String aLongProperty, Class<T> aType, String aAlias, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        super(aLongProperty, aType, aAlias, aDescription, aConsumer);
    }

    protected AbstractPropertyOption(Character aShortProperty, String aLongProperty, Class<T> aType, String aDescription) {
        super(aShortProperty, aLongProperty, aType, aDescription);
    }

    protected AbstractPropertyOption(Character aShortProperty, String aLongProperty, Class<T> aType, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        super(aShortProperty, aLongProperty, aType, aDescription, aConsumer);
    }

    @Override
    public List<Operand<T>> parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        Relation<String, String> thePropertyArgument = this.toPropertyArgument(aArgs, aCliCtx);
        if (thePropertyArgument != null) {
            ArrayList<Operand<T>> theResult = new ArrayList<Operand<T>>();
            theResult.add(this);
            this.setParsedArgs(new String[]{(String)thePropertyArgument.getKey() + "=" + (String)thePropertyArgument.getValue()});
            this.setValue(this.toType((String)thePropertyArgument.getValue()));
            this._matchCount = theResult.size();
            return theResult;
        }
        if (AbstractPropertyOption.contains(aArgs, aCliCtx.toShortOption(this))) {
            this._exception = new ParseArgsException(aArgs, "Missing value for option \"" + aCliCtx.toShortOption(this) + "\" requiring a value.", (Term)this);
            throw this._exception;
        }
        if (AbstractPropertyOption.contains(aArgs, aCliCtx.toLongOption(this))) {
            this._exception = new ParseArgsException(aArgs, "Missing value for option \"" + aCliCtx.toLongOption(this) + "\" requiring a value.", (Term)this);
            throw this._exception;
        }
        this._exception = this.throwUnknowArgsException(aArgs, aCliCtx);
        throw this._exception;
    }

    @Override
    public String toSpec(CliContext aCliContext) {
        StringBuilder theBuilder = new StringBuilder();
        theBuilder.append(aCliContext.toOptionEscapeCode() + aCliContext.toOption(this) + aCliContext.toResetEscapeCode());
        String theArgumentSpec = aCliContext.toArgumentSpec(this);
        if (theArgumentSpec != null && theArgumentSpec.length() != 0 && theBuilder.length() > 0) {
            theBuilder.append('=');
        }
        theBuilder.append(theArgumentSpec);
        return theBuilder.toString();
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        return aCliCtx.toOptionEscapeCode() + aCliCtx.toOption(this) + aCliCtx.toResetEscapeCode() + (String)(this.getAlias() != null ? "=" + aCliCtx.toArgumentSpec(this) : "") + aCliCtx.toResetEscapeCode();
    }

    protected Relation<String, String> toPropertyArgument(String[] aArgs, CliContext aCliCtx) {
        if (aArgs.length > 0) {
            Relation<String, String> theAttribute = AbstractPropertyOption.toPropertyArgument(aArgs, aCliCtx.toShortOption(this));
            if (theAttribute != null) {
                return theAttribute;
            }
            theAttribute = AbstractPropertyOption.toPropertyArgument(aArgs, aCliCtx.toLongOption(this));
            if (theAttribute != null) {
                return theAttribute;
            }
        }
        return null;
    }

    protected static Relation<String, String> toPropertyArgument(String[] aArgs, String aOption) {
        if (aOption != null) {
            for (int i = 0; i < aArgs.length; ++i) {
                String eArg = aArgs[i];
                int eIndex = eArg.indexOf(61);
                if (eIndex == -1) continue;
                String eKey = eArg.substring(0, eIndex);
                String eValue = eArg.substring(eIndex + 1);
                if (!aOption.equals(eKey)) continue;
                return new RelationImpl((Object)eKey, (Object)eValue);
            }
        }
        return null;
    }
}

