/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;

public class AnyCondition
extends AbstractCondition
implements Condition {
    public AnyCondition(Term ... aArgs) {
        super("Any (OPTIONAL) syntax branches may optionally match from the command line arguments, though not all command line arguments are required to match.", aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        ArrayList theResult = new ArrayList();
        List<? extends Operand<?>> eOperands = null;
        UnknownArgsException theCause = null;
        for (Term eChild : this._children) {
            try {
                eOperands = eChild.parseArgs(aArgs, aOptions, aCliCtx);
                if (eOperands != null) {
                    theResult.addAll(eOperands);
                }
                aArgs = AnyCondition.toArgsDiff(aArgs, eOperands);
            }
            catch (UnknownArgsException e) {
                if (theCause == null) {
                    theCause = e;
                    continue;
                }
                theCause.addSuppressed((Throwable)((Object)e));
            }
        }
        if (theCause != null) {
            this._exception = new ArgsSyntaxException(aArgs, "At least one syntax branch did not match the command line arguments, anyhow the syntax branches may just optionally (ANY) be matched by the command line arguments!", (Throwable)((Object)theCause), (Term)this);
        }
        return theResult;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public String toString() {
        return this.toSchema().toString();
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        if (this._children != null && this._children.length > 0) {
            Object theSyntax = "";
            for (Term eChild : this._children) {
                if (((String)theSyntax).length() != 0) {
                    theSyntax = (String)theSyntax + " ";
                }
                theSyntax = (String)theSyntax + (aCliCtx.getSyntaxMetrics().getAnySymbol() != null && aCliCtx.getSyntaxMetrics().getAnySymbol().length() != 0 ? aCliCtx.getSyntaxMetrics().getAnySymbol() : "");
                theSyntax = (String)theSyntax + (String)(aCliCtx.getSyntaxMetrics().getBeginOptionalSymbol() != null && aCliCtx.getSyntaxMetrics().getBeginOptionalSymbol().length() != 0 ? aCliCtx.getSyntaxMetrics().getBeginOptionalSymbol() + " " : "");
                theSyntax = (String)theSyntax + eChild.toSyntax(aCliCtx);
                theSyntax = (String)theSyntax + (String)(aCliCtx.getSyntaxMetrics().getEndOptionalSymbol() != null && aCliCtx.getSyntaxMetrics().getEndOptionalSymbol().length() != 0 ? " " + aCliCtx.getSyntaxMetrics().getEndOptionalSymbol() : "");
            }
            return theSyntax;
        }
        return "";
    }

    @Override
    public ArgsSyntaxException getException() {
        return super.getException();
    }
}

