/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.BooleanProperty;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.DoubleProperty;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.IntProperty;
import org.refcodes.cli.LongOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.StringProperty;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.VerboseTextBuilder;

public class MessageTest {
    @Test
    public void testHeuristicMessageA1() {
        String[] theArgs = new String[]{"--string=someString", "--token=1234567890"};
        String theExpected = "No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Failed as of superfluous \"--token=1234567890\" argument, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--email\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!";
        String theHeurisiticExprected = "Failed as of superfluous \"--token=1234567890\" argument, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--email\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!";
        ArgsParser theParser = MessageTest.createArgsParserA();
        try {
            theParser.evalArgs(theArgs);
            Assertions.fail((String)("Expected an exception of type <" + ArgsSyntaxException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException e) {
            String theMessage = e.toMessage();
            String theHeuristicMessage = e.toHeuristicMessage();
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("toMessage() = " + theMessage);
                System.out.println("toHeuristicMessage() = " + theHeuristicMessage);
            }
            Assertions.assertEquals((Object)"No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Failed as of superfluous \"--token=1234567890\" argument, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--email\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!", (Object)theMessage);
            Assertions.assertEquals((Object)"Failed as of superfluous \"--token=1234567890\" argument, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--email\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!", (Object)theHeuristicMessage);
        }
    }

    @Test
    public void testHeuristicMessageA2() {
        String[] theArgs = new String[]{"--string=someString", "--email=someEmail", "--token=1234567890"};
        String theExpected = "No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Failed as of superfluous \"--email=someEmail\", \"--token=1234567890\" arguments, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!";
        String theHeurisiticExprected = "Failed as of superfluous \"--email=someEmail\", \"--token=1234567890\" arguments, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!";
        ArgsParser theParser = MessageTest.createArgsParserA();
        try {
            theParser.evalArgs(theArgs);
            Assertions.fail((String)("Expected an exception of type <" + ArgsSyntaxException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException e) {
            String theMessage = e.toMessage();
            String theHeuristicMessage = e.toHeuristicMessage();
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("toMessage() = " + theMessage);
                System.out.println("toHeuristicMessage() = " + theHeuristicMessage);
            }
            Assertions.assertEquals((Object)"No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Failed as of superfluous \"--email=someEmail\", \"--token=1234567890\" arguments, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!", (Object)theMessage);
            Assertions.assertEquals((Object)"Failed as of superfluous \"--email=someEmail\", \"--token=1234567890\" arguments, though the arguments must be matched completely (ALL) by the syntax branches! Possible cause: No option \"--name\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-h\" nor the long-option \"--help\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Neither the short-option \"-v\" nor the long-option \"--version\" were found in the command line arguments, provide at least one of them to match the according syntax branch!", (Object)theHeuristicMessage);
        }
    }

    @Test
    public void testHeuristicMessageB1() {
        String[] theArgs = new String[]{"-d", "-t"};
        String theExpected = "No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Also notable: At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Missing value for option \"-t\" requiring a value. Also notable: Neither the short-option \"-b\" nor the long-option \"--bytes\" were found in the command line arguments, provide at least one of them to match the according syntax branch! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: Neither the short-option \"-e\" nor the long-option \"--encrypt\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Failed as of superfluous \"-t\" argument, though the arguments must be matched completely (ALL) by the syntax branches! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No option \"--create-cert\" was found in the command line arguments, provide it to match the according syntax branch! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No option \"--cert-info\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-c\" nor the long-option \"--cert-file\" were found in the command line arguments, provide at least one of them to match the according syntax branch! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No option \"--create-spec\" was found in the command line arguments, provide it to match the according syntax branch! No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: No option \"--help\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: No option \"--encoded-length\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: No option \"--sysinfo\" was found in the command line arguments, provide it to match the according syntax branch! Caused by: Neither the short-option \"-e\" nor the long-option \"--encrypt\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Also notable: No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Missing value for option \"-t\" requiring a value. Also notable: Neither the short-option \"-b\" nor the long-option \"--bytes\" were found in the command line arguments, provide at least one of them to match the according syntax branch!";
        String theHeurisiticExprected = "Missing value for option \"-t\" requiring a value. Also notable: Neither the short-option \"-b\" nor the long-option \"--bytes\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Possible cause: Failed as of superfluous \"-t\" argument, though the arguments must be matched completely (ALL) by the syntax branches!";
        ArgsParser theParser = MessageTest.createArgsParserB();
        try {
            theParser.evalArgs(theArgs);
            Assertions.fail((String)("Expected an exception of type <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException e) {
            String theMessage = e.toMessage();
            String theHeuristicMessage = e.toHeuristicMessage();
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("toMessage() = " + theMessage);
                System.out.println("toHeuristicMessage() = " + theHeuristicMessage);
            }
            Assertions.assertEquals((Object)"No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Also notable: At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Missing value for option \"-t\" requiring a value. Also notable: Neither the short-option \"-b\" nor the long-option \"--bytes\" were found in the command line arguments, provide at least one of them to match the according syntax branch! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: Neither the short-option \"-e\" nor the long-option \"--encrypt\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Failed as of superfluous \"-t\" argument, though the arguments must be matched completely (ALL) by the syntax branches! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No option \"--create-cert\" was found in the command line arguments, provide it to match the according syntax branch! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No option \"--cert-info\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: Neither the short-option \"-c\" nor the long-option \"--cert-file\" were found in the command line arguments, provide at least one of them to match the according syntax branch! At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No option \"--create-spec\" was found in the command line arguments, provide it to match the according syntax branch! No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: No option \"--help\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments! Caused by: No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: No option \"--encoded-length\" was found in the command line arguments, provide it to match the according syntax branch! Also notable: No option \"--sysinfo\" was found in the command line arguments, provide it to match the according syntax branch! Caused by: Neither the short-option \"-e\" nor the long-option \"--encrypt\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Also notable: No syntax branch (fully) matched the command line arguments, though one (XOR) syntax branch must match! Caused by: Missing value for option \"-t\" requiring a value. Also notable: Neither the short-option \"-b\" nor the long-option \"--bytes\" were found in the command line arguments, provide at least one of them to match the according syntax branch!", (Object)theMessage);
            Assertions.assertEquals((Object)"Missing value for option \"-t\" requiring a value. Also notable: Neither the short-option \"-b\" nor the long-option \"--bytes\" were found in the command line arguments, provide at least one of them to match the according syntax branch! Possible cause: Failed as of superfluous \"-t\" argument, though the arguments must be matched completely (ALL) by the syntax branches!", (Object)theHeuristicMessage);
        }
    }

    private static ArgsParser createArgsParserA() {
        ArgsParser theParser = new ArgsParser();
        Flag theHelpFlag = CliSugar.flag((Character)Character.valueOf('h'), (String)"help", (String)"Shows the help ...");
        Flag theVersionFlag = CliSugar.flag((Character)Character.valueOf('v'), (String)"version", (String)"Shows the version ...");
        StringProperty theString1Arg = CliSugar.stringProperty((String)"string", (String)"...");
        StringProperty theString2Arg = CliSugar.stringProperty((String)"string", (String)"...");
        BooleanProperty theboolArg = CliSugar.booleanProperty((String)"bool", (String)"...");
        Flag theBoolFlag = CliSugar.flag((String)"bool", (String)"...");
        StringProperty theEMailArg = CliSugar.stringProperty((String)"email", (String)"...");
        StringProperty theNameArg = CliSugar.stringProperty((String)"name", (String)"...");
        StringProperty theTokenArg = CliSugar.stringProperty((String)"token", (String)"...");
        IntProperty theIntArg = CliSugar.intProperty((String)"int", (String)"...");
        DoubleProperty theDoubleArg = CliSugar.doubleProperty((String)"double", (String)"...");
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theString1Arg, CliSugar.optional((Term[])new Term[]{theString2Arg, CliSugar.xor((Term[])new Term[]{theboolArg, theBoolFlag, CliSugar.and((Term[])new Term[]{theEMailArg, theNameArg, theTokenArg})}), theIntArg, theDoubleArg})}), theHelpFlag, theVersionFlag});
        return theParser.withArgsSyntax((Term)theArgsSyntax).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
    }

    private static ArgsParser createArgsParserB() {
        ArgsParser theParser = new ArgsParser();
        EnumOption theEncodingArg = CliSugar.enumOption((String)"encoding", BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])BaseMetricsConfig.values())));
        EnumOption theCertModeArg = CliSugar.enumOption((String)"cert-mode", ChaosMode.class, (String)"CERT_MODE_PROPERTY", (String)("The chaos options (mode) to be used for the cert itself: " + VerboseTextBuilder.asString((Object[])ChaosMode.values())));
        EnumOption theChaosModeArg = CliSugar.enumOption((String)"chaos-mode", ChaosMode.class, (String)"CERT_MODE_PROPERTY", (String)("The mode to be used when encrypting/decrypting: " + VerboseTextBuilder.asString((Object[])ChaosMode.values())));
        EnumOption theContextArg = CliSugar.enumOption((String)"context", SystemContext.class, (String)"CONTEXT_PROPERTY", (String)("The system context providing the password: " + VerboseTextBuilder.asString((Object[])SystemContext.values())));
        Flag theBase64Flag = CliSugar.flag((String)"base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag theCertInfoFlag = CliSugar.flag((String)"cert-info", (String)"CERT_INFO_PROPERTY", (String)"Prints out information of a given cert.");
        Flag theCreateCertFlag = CliSugar.flag((String)"create-cert", (String)"CREATE_CERT_PROPERTY", (String)"Create an according cert record (file).");
        Flag theCreateSpecFlag = CliSugar.flag((String)"create-spec", (String)"CREATE_SPEC_PROPERTY", (String)"Create an according spec record (file).");
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)false);
        Flag theDecryptFlag = CliSugar.flag((Character)Character.valueOf('d'), (String)"decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the message (stream, file, text or bytes).");
        Flag theEncodedFlag = CliSugar.flag((String)"encoded-length", (String)"ENCODED_LENGTH_PROPERTY", (String)"Prints length in bytes of a single chaos key encoding (being the addional length of a salted encryption).");
        Flag theEncryptFlag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the message (stream, file, text or bytes).");
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        Flag theHexFlag = CliSugar.flag((String)"hex", (String)"HEX_PROPERTY", (String)"Use a hexadecimal representation of (binary) output.");
        Flag thePromptPasswordFlag = CliSugar.flag((String)"prompt", (String)"PROMPT_PASSWORD_PROPERTY", (String)"Prompt for the password to use for encryption or decryption.");
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        Flag theVerifyFlag = CliSugar.flag((String)"verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        Flag theCopyToFlag = CliSugar.flag((String)"copy-to", (String)"COPY_TO_PROPERTY", (String)("Copy the processed output data to the clipboard" + (Execution.isNativeImage() ? " (without warranty)" : "") + "."));
        Flag thePasteFromFlag = CliSugar.flag((String)"paste-from", (String)"PASTE_FROM_PROPERTY", (String)("Paste the input data to be processed from the clipboard" + (Execution.isNativeImage() ? " (without warranty)" : "") + "."));
        IntOption theChainLengthArg = CliSugar.intOption((String)"chain-length", (String)"CHAIN_LENGTH_PROPERTY", (String)"The length of the chaos key chain (e.g. number of nested chaos keys, defaults to <>)");
        IntOption theLineWidthArg = CliSugar.intOption((String)"line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.");
        DoubleOption theX0Arg = CliSugar.doubleOption((Character)Character.valueOf('x'), (String)"start-value", (String)"X0_PROPERTY", (String)"The chaos key's <x0> start value to use: < x0 \u2264 ");
        DoubleOption theAArg = CliSugar.doubleOption((Character)Character.valueOf('a'), (String)"parable-coefficient", (String)"A_PROPERTY", (String)"The chaos key's parable coefficient <a> to use: \u2264 a \u2264 ");
        LongOption theSArg = CliSugar.longOption((Character)Character.valueOf('s'), (String)"expansion-factor", (String)"S_PROPERTY", (String)"The chaos key's expansion factor <s> to use: \u2264 s \u2264 or \u2264 s \u2264 ");
        StringOption theBytesArg = CliSugar.stringOption((Character)Character.valueOf('b'), (String)"bytes", (String)"BYTES_PROPERTY", (String)"The message in bytes (e.g. \"127, 128, 0x10, 0xFF\") which to process.");
        StringOption theCertFileArg = CliSugar.stringOption((Character)Character.valueOf('c'), (String)"cert-file", (String)"CERT_FILE_PROPERTY", (String)"The cert file file which to use.");
        StringOption theInputFileArg = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        StringOption thePasswordArg = CliSugar.stringOption((Character)Character.valueOf('p'), (String)"password", (String)"PASSWORD_PROPERTY", (String)"The password to use for encryption or decryption.");
        StringOption theSpecFileArg = CliSugar.stringOption((String)"spec-file", (String)"SPEC_FILE_PROPERTY", (String)"The spec file file which to use.");
        StringOption theTextArg = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT_PROPERTY", (String)"The text message which to process.");
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theEncryptFlag, CliSugar.xor((Term[])new Term[]{theTextArg, theBytesArg}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theHexFlag, theBase64Flag, theEncodingArg}), CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg, CliSugar.and((Term[])new Term[]{theX0Arg, theAArg, theSArg})}), theChaosModeArg}), CliSugar.and((Term[])new Term[]{theCertFileArg, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg})})})}), theCopyToFlag, theVerifyFlag, theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{theDecryptFlag, CliSugar.xor((Term[])new Term[]{theTextArg, theBytesArg}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theBase64Flag, theEncodingArg}), theHexFlag, CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg, CliSugar.and((Term[])new Term[]{theX0Arg, theAArg, theSArg})}), theChaosModeArg}), CliSugar.and((Term[])new Term[]{theCertFileArg, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg})})})}), theCopyToFlag, theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{theEncryptFlag, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theInputFileArg, thePasteFromFlag}), CliSugar.xor((Term[])new Term[]{theOutputFileArg, theCopyToFlag}), CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theBase64Flag, theEncodingArg}), CliSugar.any((Term[])new Term[]{theLineWidthArg})}), CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg, CliSugar.and((Term[])new Term[]{theX0Arg, theAArg, theSArg})}), theChaosModeArg}), CliSugar.and((Term[])new Term[]{theCertFileArg, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg})})})}), theVerifyFlag, theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{theDecryptFlag, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theInputFileArg, thePasteFromFlag}), CliSugar.xor((Term[])new Term[]{theOutputFileArg, theCopyToFlag}), CliSugar.xor((Term[])new Term[]{theBase64Flag, theEncodingArg}), CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg, CliSugar.and((Term[])new Term[]{theX0Arg, theAArg, theSArg})}), theChaosModeArg}), CliSugar.and((Term[])new Term[]{theCertFileArg, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg})})})}), theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{theCreateCertFlag, CliSugar.any((Term[])new Term[]{theLineWidthArg, theCertFileArg, CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg}), CliSugar.any((Term[])new Term[]{theCertModeArg})}), CliSugar.xor((Term[])new Term[]{CliSugar.or((Term[])new Term[]{theChainLengthArg, theChaosModeArg}), theSpecFileArg}), theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{theCertInfoFlag, theCertFileArg, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg}), theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{theCreateSpecFlag, CliSugar.any((Term[])new Term[]{theSpecFileArg, theVerboseFlag, theDebugFlag})}), CliSugar.xor((Term[])new Term[]{theHelpFlag, CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theEncodedFlag, theSysInfoFlag}), CliSugar.any((Term[])new Term[]{theVerboseFlag, theDebugFlag})})})});
        return theParser.withArgsSyntax((Term)theArgsSyntax).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
    }

    public static enum BaseMetricsConfig {
        CONF_A,
        CONF_B,
        CONF_C;

    }

    static enum ChaosMode {
        X,
        Y,
        Z;

    }

    static enum SystemContext {
        S0,
        S1,
        S2;

    }
}

