/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.test.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.revapi.java.test.support.ArchiveProbeObject;
import org.revapi.java.test.support.FileJavaFileObject;
import org.revapi.java.test.support.MarkerAnnotationObject;
import org.revapi.java.test.support.SourceInClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jar
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(Jar.class);
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private Map<File, Semaphore> compiledStuff = new HashMap<File, Semaphore>();
    private ExecutorService compileProcess = Executors.newCachedThreadPool();

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Jar.this.compiledStuff.clear();
                try {
                    base.evaluate();
                }
                finally {
                    Jar.this.cleanUp();
                }
            }
        };
    }

    public Builder from() {
        return new Builder();
    }

    public void cleanUp() {
        for (Map.Entry<File, Semaphore> e : this.compiledStuff.entrySet()) {
            if (e.getValue() != null) {
                e.getValue().release();
            }
            try {
                Files.walkFileTree(e.getKey().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                LOG.warn("Failed to clean up directory " + e.getKey().getAbsolutePath(), (Throwable)ex);
            }
        }
    }

    private static final class EnvironmentImpl
    implements Environment {
        private Elements elements;
        private Types types;

        private EnvironmentImpl() {
        }

        @Override
        public Elements elements() {
            return this.elements;
        }

        @Override
        public Types types() {
            return this.types;
        }
    }

    public static interface Environment {
        public Elements elements();

        public Types types();
    }

    public final class BuildOutput {
        private final File jarFile;

        public BuildOutput(File jarFile) {
            this.jarFile = jarFile;
        }

        public File jarFile() {
            return this.jarFile;
        }

        public Environment analyze() {
            File dir = new File(this.jarFile.getParent(), "probe");
            if (!dir.mkdirs()) {
                throw new IllegalArgumentException("Failed to create directory " + dir.getAbsolutePath());
            }
            List<String> options = Arrays.asList("-cp", this.jarFile.getAbsolutePath(), "-d", dir.getAbsolutePath());
            ArrayList<SimpleJavaFileObject> sourceObjects = new ArrayList<SimpleJavaFileObject>(2);
            sourceObjects.add(new MarkerAnnotationObject());
            sourceObjects.add(new ArchiveProbeObject());
            StandardJavaFileManager fileManager = Jar.this.compiler.getStandardFileManager(null, Locale.getDefault(), Charset.forName("UTF-8"));
            JavaCompiler.CompilationTask task = Jar.this.compiler.getTask(new PrintWriter(System.out), fileManager, null, options, Collections.singletonList("Probe"), sourceObjects);
            final Semaphore cleanUpSemaphore = new Semaphore(0);
            final Semaphore initSemaphore = new Semaphore(0);
            final EnvironmentImpl ret = new EnvironmentImpl();
            task.setProcessors(Collections.singletonList(new AbstractProcessor(){

                @Override
                public SourceVersion getSupportedSourceVersion() {
                    return SourceVersion.latest();
                }

                @Override
                public Set<String> getSupportedAnnotationTypes() {
                    return new HashSet<String>(Collections.singletonList("__RevapiMarkerAnnotation"));
                }

                @Override
                public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                    if (roundEnv.processingOver()) {
                        ret.elements = this.processingEnv.getElementUtils();
                        ret.types = this.processingEnv.getTypeUtils();
                        initSemaphore.release();
                        try {
                            cleanUpSemaphore.acquire();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        return true;
                    }
                    return false;
                }
            }));
            Jar.this.compileProcess.submit(task);
            try {
                initSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Thread interrupted");
            }
            Jar.this.compiledStuff.put(this.jarFile.getParentFile(), cleanUpSemaphore);
            return ret;
        }
    }

    public final class Builder {
        private Map<URI, JavaFileObject> sources = new HashMap<URI, JavaFileObject>();
        private Map<URI, InputStream> resources = new HashMap<URI, InputStream>();

        private Builder() {
        }

        public Builder classPathSources(String root, String ... sources) {
            URI rootUri = this.toUri(root);
            for (String source : sources) {
                URI sourceUri = URI.create(source);
                URI location = rootUri.resolve(sourceUri);
                this.sources.put(sourceUri, new SourceInClassLoader(sourceUri, location));
            }
            return this;
        }

        public Builder classPathResources(String root, String ... resources) {
            URI rootUri = this.toUri(root);
            for (String resource : resources) {
                URI resourceUri = URI.create(resource);
                URI location = rootUri.resolve(resourceUri);
                this.resources.put(resourceUri, this.getClass().getResourceAsStream(location.getPath()));
            }
            return this;
        }

        public Builder fileSources(File root, File ... sources) {
            URI rootUri = root.toURI();
            for (File source : sources) {
                URI sourceUri = URI.create(source.getPath());
                URI location = rootUri.resolve(sourceUri);
                this.sources.put(sourceUri, new FileJavaFileObject(sourceUri, new File(location.getPath())));
            }
            return this;
        }

        public Builder fileResources(File root, File ... resources) {
            URI rootUri = root.toURI();
            for (File resource : resources) {
                URI resourceUri = URI.create(resource.getPath());
                URI location = rootUri.resolve(resourceUri);
                try {
                    this.resources.put(resourceUri, new FileInputStream(location.getPath()));
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return this;
        }

        public BuildOutput build() throws IOException {
            File dir = Files.createTempDirectory("revapi-java-spi", new FileAttribute[0]).toFile();
            File compiledSourcesOutput = new File(dir, "sources");
            if (!compiledSourcesOutput.mkdirs()) {
                throw new IllegalStateException("Could not create output location for compiling test sources.");
            }
            ArrayList<JavaFileObject> sourceObjects = new ArrayList<JavaFileObject>(this.sources.values());
            List<String> options = Arrays.asList("-d", compiledSourcesOutput.getAbsolutePath());
            JavaCompiler.CompilationTask firstCompilation = Jar.this.compiler.getTask(null, null, null, options, null, sourceObjects);
            if (!firstCompilation.call().booleanValue()) {
                throw new IllegalStateException("Failed to compile the sources");
            }
            for (Map.Entry<URI, InputStream> e : this.resources.entrySet()) {
                File target = new File(compiledSourcesOutput, e.getKey().getPath());
                if (!target.getParentFile().mkdirs()) {
                    throw new IllegalStateException("Failed to create directory " + target.getParentFile().getAbsolutePath());
                }
                Files.copy(e.getValue(), target.toPath(), new CopyOption[0]);
            }
            File compiledJar = new File(dir, "compiled.jar");
            try (final JarOutputStream out = new JarOutputStream(new FileOutputStream(compiledJar));){
                final Path root = compiledSourcesOutput.toPath();
                final HashSet added = new HashSet();
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if ("MANIFEST.MF".equals(file.getFileName().toString()) && "META-INF".equals(file.getParent().getFileName().toString())) {
                            ZipEntry entry = new ZipEntry("META-INF/");
                            out.putNextEntry(entry);
                            out.closeEntry();
                            entry = new ZipEntry("META-INF/MANIFEST.MF");
                            out.putNextEntry(entry);
                            Files.copy(file, out);
                            out.closeEntry();
                            added.add("META-INF/");
                            added.add("META-INF/MANIFEST.MF");
                        }
                        return super.visitFile(file, attrs);
                    }
                });
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        StringBuilder path = new StringBuilder();
                        Iterator<Path> it = root.relativize(file).iterator();
                        while (it.hasNext()) {
                            String currentPath;
                            Path p = it.next();
                            boolean isDir = it.hasNext();
                            path.append(p.toString());
                            if (isDir) {
                                path.append("/");
                            }
                            if (added.contains(currentPath = path.toString())) continue;
                            ZipEntry entry = new ZipEntry(currentPath);
                            out.putNextEntry(entry);
                            if (!isDir) {
                                Files.copy(file, out);
                            }
                            out.closeEntry();
                            added.add(currentPath);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            Jar.this.compiledStuff.put(dir, null);
            return new BuildOutput(compiledJar);
        }

        private URI toUri(String path) {
            if (path == null || path.isEmpty()) {
                return URI.create("/");
            }
            return URI.create(path);
        }
    }
}

