/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.test.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

final class SourceInClassLoader
extends SimpleJavaFileObject {
    private final URL url;

    public SourceInClassLoader(URI path, URI pathInClassloader) {
        super(path, JavaFileObject.Kind.SOURCE);
        this.url = this.getClass().getResource(pathInClassloader.getPath());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        int cnt;
        StringBuilder bld = new StringBuilder();
        Reader rdr = this.openReader(ignoreEncodingErrors);
        char[] buffer = new char[512];
        while ((cnt = rdr.read(buffer)) != -1) {
            bld.append(buffer, 0, cnt);
        }
        rdr.close();
        return bld;
    }

    @Override
    public NestingKind getNestingKind() {
        return NestingKind.TOP_LEVEL;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.url.openStream();
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new InputStreamReader(this.openInputStream(), "UTF-8");
    }
}

