/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceAnalyzer;
import org.revapi.Element;
import org.revapi.Report;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.compilation.CompilationValve;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.AnnotationElement;
import org.revapi.java.model.FieldElement;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.MethodParameterElement;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.UseSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaElementDifferenceAnalyzer
implements DifferenceAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(JavaElementDifferenceAnalyzer.class);
    private final Iterable<Check> checks;
    private final CompilationValve oldCompilationValve;
    private final CompilationValve newCompilationValve;
    private final AnalysisConfiguration analysisConfiguration;
    private final ResourceBundle messages;
    private final ProbingEnvironment oldEnvironment;
    private final ProbingEnvironment newEnvironment;
    private List<Difference> lastAnnotationResults;

    public JavaElementDifferenceAnalyzer(AnalysisContext analysisContext, ProbingEnvironment oldEnvironment, CompilationValve oldValve, ProbingEnvironment newEnvironment, CompilationValve newValve, Iterable<Check> checks, AnalysisConfiguration analysisConfiguration) {
        this.oldCompilationValve = oldValve;
        this.newCompilationValve = newValve;
        this.checks = checks;
        for (Check c : checks) {
            c.initialize(analysisContext);
            c.setOldTypeEnvironment((TypeEnvironment)oldEnvironment);
            c.setNewTypeEnvironment((TypeEnvironment)newEnvironment);
        }
        this.analysisConfiguration = analysisConfiguration;
        this.messages = ResourceBundle.getBundle("org.revapi.java.messages", analysisContext.getLocale());
        this.oldEnvironment = oldEnvironment;
        this.newEnvironment = newEnvironment;
    }

    public Comparator<? super Element> getCorrespondenceComparator() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                int ret = JavaElementFactory.compareByType(o1, o2);
                if (ret != 0) {
                    return ret;
                }
                if (o1 instanceof MethodElement) {
                    MethodElement m1 = (MethodElement)o1;
                    MethodElement m2 = (MethodElement)o2;
                    String sig1 = ((TypeElement)m1.getParent()).getCanonicalName() + "::" + ((ExecutableElement)m1.getModelElement()).getSimpleName().toString();
                    String sig2 = ((TypeElement)m2.getParent()).getCanonicalName() + "::" + ((ExecutableElement)m2.getModelElement()).getSimpleName().toString();
                    return sig1.compareTo(sig2);
                }
                return o1.compareTo((Object)o2);
            }
        };
    }

    public void open() {
    }

    public void close() {
        LOG.trace("Tearing down compilation results");
        this.oldCompilationValve.removeCompiledResults();
        this.newCompilationValve.removeCompiledResults();
    }

    public void beginAnalysis(@Nullable Element oldElement, @Nullable Element newElement) {
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            LOG.trace("Beginning analysis of {} and {}.", (Object)oldElement, (Object)newElement);
                            if (!this.conforms(oldElement, newElement, TypeElement.class)) break block6;
                            for (Check c : this.checks) {
                                c.visitClass(oldElement == null ? null : ((TypeElement)oldElement).getModelElement(), newElement == null ? null : ((TypeElement)newElement).getModelElement());
                            }
                            break block7;
                        }
                        if (!this.conforms(oldElement, newElement, AnnotationElement.class)) break block8;
                        if (this.lastAnnotationResults == null) {
                            this.lastAnnotationResults = new ArrayList<Difference>();
                        }
                        for (Check c : this.checks) {
                            List cps = c.visitAnnotation(oldElement == null ? null : ((AnnotationElement)oldElement).getAnnotation(), newElement == null ? null : ((AnnotationElement)newElement).getAnnotation());
                            if (cps == null) continue;
                            this.lastAnnotationResults.addAll(cps);
                        }
                        break block7;
                    }
                    if (!this.conforms(oldElement, newElement, FieldElement.class)) break block9;
                    for (Check c : this.checks) {
                        c.visitField(oldElement == null ? null : (VariableElement)((FieldElement)oldElement).getModelElement(), newElement == null ? null : (VariableElement)((FieldElement)newElement).getModelElement());
                    }
                    break block7;
                }
                if (!this.conforms(oldElement, newElement, MethodElement.class)) break block10;
                for (Check c : this.checks) {
                    c.visitMethod(oldElement == null ? null : (ExecutableElement)((MethodElement)oldElement).getModelElement(), newElement == null ? null : (ExecutableElement)((MethodElement)newElement).getModelElement());
                }
                break block7;
            }
            if (!this.conforms(oldElement, newElement, MethodParameterElement.class)) break block7;
            for (Check c : this.checks) {
                c.visitMethodParameter(oldElement == null ? null : (VariableElement)((MethodParameterElement)oldElement).getModelElement(), newElement == null ? null : (VariableElement)((MethodParameterElement)newElement).getModelElement());
            }
        }
    }

    public Report endAnalysis(@Nullable Element oldElement, @Nullable Element newElement) {
        if (this.conforms(oldElement, newElement, AnnotationElement.class)) {
            return new Report(Collections.emptyList(), oldElement, newElement);
        }
        ArrayList<Difference> differences = new ArrayList<Difference>();
        for (Check c : this.checks) {
            List p = c.visitEnd();
            if (p == null) continue;
            differences.addAll(p);
        }
        if (this.lastAnnotationResults != null && !this.lastAnnotationResults.isEmpty()) {
            differences.addAll(this.lastAnnotationResults);
            this.lastAnnotationResults.clear();
        }
        if (!differences.isEmpty()) {
            LOG.trace("Detected following problems: {}", differences);
        }
        LOG.trace("Ended analysis of {} and {}.", (Object)oldElement, (Object)newElement);
        ListIterator<Difference> it = differences.listIterator();
        while (it.hasNext()) {
            Difference d = (Difference)it.next();
            if (this.analysisConfiguration.getUseReportingCodes().contains(d.code)) {
                StringBuilder newDesc = new StringBuilder(d.description);
                this.appendUses(oldElement, this.oldEnvironment, newDesc);
                this.appendUses(newElement, this.newEnvironment, newDesc);
                d = Difference.builder().addAttachments((Iterable)d.attachments).addClassifications(d.classification).withCode(d.code).withName(d.name).withDescription(newDesc.toString()).build();
            }
            it.set(d);
        }
        return new Report(differences, oldElement, newElement);
    }

    private <T> boolean conforms(Object a, Object b, Class<T> cls) {
        boolean ca = a == null || cls.isAssignableFrom(a.getClass());
        boolean cb = b == null || cls.isAssignableFrom(b.getClass());
        return ca && cb;
    }

    private String join(Collection<UseSite> useSites) {
        StringBuilder bld = new StringBuilder();
        Iterator<UseSite> it = useSites.iterator();
        if (it.hasNext()) {
            this.append(bld, it.next());
        }
        while (it.hasNext()) {
            bld.append(", ");
            this.append(bld, it.next());
        }
        return bld.toString();
    }

    private void append(StringBuilder bld, UseSite use) {
        String message;
        switch (use.getUseType()) {
            case ANNOTATES: {
                message = "revapi.java.uses.annotates";
                break;
            }
            case HAS_TYPE: {
                message = "revapi.java.uses.hasType";
                break;
            }
            case IS_IMPLEMENTED: {
                message = "revapi.java.uses.isImplemented";
                break;
            }
            case IS_INHERITED: {
                message = "revapi.java.uses.isInherited";
                break;
            }
            case IS_THROWN: {
                message = "revapi.java.uses.isThrown";
                break;
            }
            case PARAMETER_TYPE: {
                message = "revapi.java.uses.parameterType";
                break;
            }
            case RETURN_TYPE: {
                message = "revapi.java.uses.returnType";
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid use type.");
            }
        }
        message = this.messages.getString(message);
        message = MessageFormat.format(message, use.getSite().getFullHumanReadableString());
        bld.append(message);
    }

    private void appendUses(Element element, ProbingEnvironment environment, StringBuilder bld) {
        if (element instanceof JavaTypeElement) {
            bld.append("\n");
            LOG.trace("Reporting uses of {}", (Object)element);
            javax.lang.model.element.TypeElement type = ((JavaTypeElement)element).getModelElement();
            Set<UseSite> useSites = environment.getUseSites(type);
            Iterator<UseSite> useIt = useSites.iterator();
            if (useIt.hasNext()) {
                this.appendUse(bld, useIt.next());
            }
            while (useIt.hasNext()) {
                bld.append(", ");
                this.appendUse(bld, useIt.next());
            }
        }
    }

    private void appendUse(StringBuilder bld, UseSite use) {
        List<UseSite> chain = this.getShortestPathToApiArchive(use);
        Iterator<UseSite> chainIt = chain.iterator();
        if (chainIt.hasNext()) {
            this.append(bld, chainIt.next());
        }
        while (chainIt.hasNext()) {
            bld.append(" <- ");
            this.append(bld, chainIt.next());
        }
    }

    private List<UseSite> getShortestPathToApiArchive(UseSite bottomUse) {
        return Collections.singletonList(bottomUse);
    }

    private static <T> boolean contains(T value, Iterable<? extends T> values) {
        Iterator<T> it = values.iterator();
        while (it.hasNext()) {
            if (!value.equals(it.next())) continue;
            return true;
        }
        return false;
    }
}

