/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.revapi.Archive;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.compilation.RawUseSite;
import org.revapi.java.model.MissingClassElement;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.UseSite;
import org.revapi.query.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClassTreeInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ClassTreeInitializer.class);
    private final ProbingEnvironment environment;
    private final AnalysisConfiguration.MissingClassReporting reporting;
    private final boolean ignoreMissingAnnotations;
    private final Set<File> bootstrapClasspath;
    private final HashMap<String, TypeElement> typeCache;
    private HashSet<String> bootstrapClasses;
    private final boolean ignoreAdditionalArchivesContributions;

    public ClassTreeInitializer(ProbingEnvironment environment, AnalysisConfiguration.MissingClassReporting missingClassReporting, boolean ignoreMissingAnnotations, Set<File> bootstrapClasspath, boolean ignoreAdditionalArchivesContributions) {
        this.environment = environment;
        this.reporting = missingClassReporting;
        this.ignoreMissingAnnotations = ignoreMissingAnnotations;
        this.typeCache = new HashMap();
        this.bootstrapClasspath = bootstrapClasspath;
        this.ignoreAdditionalArchivesContributions = ignoreAdditionalArchivesContributions;
    }

    public void initTree() throws IOException {
        InitTreeContext context = new InitTreeContext();
        long time = System.currentTimeMillis();
        for (Archive archive : this.environment.getApi().getArchives()) {
            LOG.trace("Processing archive {}", (Object)archive.getName());
            this.processArchive(archive, context);
        }
        this.removeClassesFromRtJar(context.additionalClassBinaryNames);
        context.onlyAddAdditional = true;
        if (!context.additionalClassBinaryNames.isEmpty() && this.environment.getApi().getSupplementaryArchives() != null) {
            for (Archive archive : this.environment.getApi().getSupplementaryArchives()) {
                LOG.trace("Processing archive {}", (Object)archive.getName());
                this.processArchive(archive, context);
                if (!context.additionalClassBinaryNames.isEmpty()) continue;
                break;
            }
        }
        if (!context.additionalClassBinaryNames.isEmpty()) {
            ArrayList<String> prettyNames = new ArrayList<String>(context.additionalClassBinaryNames);
            Collections.sort(prettyNames);
            if (this.reporting == null || this.reporting == AnalysisConfiguration.MissingClassReporting.ERROR) {
                throw new IllegalStateException("The following classes that contribute to the public API of " + this.environment.getApi() + " could not be located: " + prettyNames);
            }
            switch (this.reporting) {
                case IGNORE: {
                    LOG.warn("The following classes that contribute to the public API of " + this.environment.getApi() + " could not be located: " + prettyNames);
                    break;
                }
                case REPORT: {
                    for (String binary : context.additionalClassBinaryNames) {
                        this.addConditionally(null, binary, binary, null, true, context.additionalClassBinaryNames, context.dormantTypes);
                    }
                    break;
                }
            }
        }
        for (Map.Entry entry : context.innerClassPositions.entrySet()) {
            String ownerBinaryName = (String)entry.getKey();
            if (this.findByType(ownerBinaryName) != null) continue;
            for (TypeElement type : (Set)entry.getValue()) {
                this.environment.getTree().getRootsUnsafe().add(type);
            }
        }
        if (LOG.isInfoEnabled()) {
            time = System.currentTimeMillis() - time;
            final int[] num = new int[1];
            this.environment.getTree().searchUnsafe(JavaElement.class, true, new Filter<JavaElement>(){

                public boolean applies(@Nullable JavaElement element) {
                    num[0] = num[0] + 1;
                    return true;
                }

                public boolean shouldDescendInto(@Nullable Object element) {
                    return true;
                }
            }, null);
            LOG.info("Tree init took " + time + "ms. The resulting tree has " + num[0] + " elements.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Public API class tree in {} initialized to: {}", (Object)this.environment.getApi(), (Object)this.environment.getTree());
        }
    }

    private void processArchive(Archive a, InitTreeContext context) throws IOException {
        if (a.getName().toLowerCase().endsWith(".jar")) {
            this.processJarArchive(a, context);
        } else if (a.getName().toLowerCase().endsWith(".class")) {
            this.processClassFile(a, context);
        }
    }

    private void processJarArchive(Archive a, InitTreeContext context) throws IOException {
        try (ZipInputStream jar = new ZipInputStream(a.openStream());){
            ZipEntry entry = jar.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && entry.getName().toLowerCase().endsWith(".class")) {
                    this.processClassBytes(a, jar, context);
                }
                entry = jar.getNextEntry();
            }
        }
    }

    private void processClassFile(Archive a, InitTreeContext context) throws IOException {
        try (InputStream data = a.openStream();){
            this.processClassBytes(a, data, context);
        }
    }

    private void processClassBytes(final Archive currentArchive, InputStream data, final InitTreeContext context) throws IOException {
        ClassReader classReader = new ClassReader(data);
        classReader.accept(new ClassVisitor(262144){
            private boolean isPublicAPI;
            private String visitedClassInternalName;
            private String visitedClassBinaryName;
            private String[] visitedClassOwners;
            private boolean isInnerClass;
            private TreeSet<OuterNameInnerNamePair> innerNames;
            private boolean visitedClassDormant;
            private int visitedInnerClassAccess;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.visitedClassInternalName = name;
                this.visitedClassBinaryName = Type.getObjectType((String)name).getClassName();
                this.isPublicAPI = ClassTreeInitializer.isPublic(access);
                if (context.onlyAddAdditional && !this.isPublicAPI) {
                    this.isPublicAPI = context.additionalClassBinaryNames.contains(Type.getObjectType((String)name).getDescriptor());
                }
                boolean bl = this.visitedClassDormant = context.onlyAddAdditional && !context.additionalClassBinaryNames.contains(this.visitedClassBinaryName);
                if (this.isPublicAPI) {
                    this.reportUse(Type.getObjectType((String)superName), UseSite.Type.IS_INHERITED, RawUseSite.SiteType.CLASS, null, null, -1);
                    for (String iface : interfaces) {
                        this.reportUse(Type.getObjectType((String)iface), UseSite.Type.IS_IMPLEMENTED, RawUseSite.SiteType.CLASS, null, null, -1);
                    }
                }
                if (name.indexOf(36) >= 0) {
                    this.visitedClassOwners = name.split("\\$");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("visit(): name={}, signature={}, publicAPI={}, dormant={}, access=0x{}", new Object[]{name, signature, this.isPublicAPI, this.visitedClassDormant, Integer.toHexString(access)});
                }
            }

            public FieldVisitor visitField(int access, final String name, String desc, String signature, Object value) {
                if (this.isPublicAPI && ClassTreeInitializer.isPublic(access)) {
                    this.reportUse(Type.getType((String)desc), UseSite.Type.HAS_TYPE, RawUseSite.SiteType.FIELD, name, desc, -1);
                    return new FieldVisitor(262144){

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            this.reportUse(Type.getType((String)desc), UseSite.Type.ANNOTATES, RawUseSite.SiteType.FIELD, name, desc, -1);
                            return null;
                        }
                    };
                }
                return null;
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                LOG.trace("Visiting inner class spec {} {}", (Object)innerName, (Object)outerName);
                boolean isThisClass = this.visitedClassInternalName.equals(name);
                if (isThisClass) {
                    this.visitedInnerClassAccess = access;
                }
                boolean bl = this.isInnerClass = this.isInnerClass || isThisClass;
                if (isThisClass || this.isTransitiveOwnerOfVisitedClass(name)) {
                    if (this.innerNames == null) {
                        this.innerNames = new TreeSet();
                    }
                    this.innerNames.add(new OuterNameInnerNamePair(outerName, innerName));
                }
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (this.isPublicAPI) {
                    this.reportUse(Type.getType((String)desc), UseSite.Type.ANNOTATES, RawUseSite.SiteType.CLASS, null, null, -1);
                }
                return null;
            }

            public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
                LOG.trace("Visiting method {} {}", (Object)name, (Object)desc);
                if (this.isPublicAPI && ClassTreeInitializer.isPublic(access)) {
                    int ai;
                    Type[] argumentTypes = Type.getArgumentTypes((String)desc);
                    this.reportUse(Type.getReturnType((String)desc), UseSite.Type.RETURN_TYPE, RawUseSite.SiteType.METHOD, name, desc, -1);
                    int n = ai = this.isInnerClass && "<init>".equals(name) && (this.visitedInnerClassAccess & 8) == 0 ? 1 : 0;
                    while (ai < argumentTypes.length) {
                        Type t = argumentTypes[ai];
                        this.reportUse(t, UseSite.Type.PARAMETER_TYPE, RawUseSite.SiteType.METHOD_PARAMETER, name, desc, ai++);
                    }
                    if (exceptions != null && exceptions.length > 0) {
                        for (String ex : exceptions) {
                            this.reportUse(Type.getObjectType((String)ex), UseSite.Type.IS_THROWN, RawUseSite.SiteType.METHOD, name, desc, -1);
                        }
                    }
                    return new MethodVisitor(262144){

                        public AnnotationVisitor visitAnnotation(String annotationDesc, boolean visible) {
                            this.reportUse(Type.getType((String)annotationDesc), UseSite.Type.ANNOTATES, RawUseSite.SiteType.METHOD, name, desc, -1);
                            return null;
                        }

                        public AnnotationVisitor visitParameterAnnotation(int parameter, String parameterDesc, boolean visible) {
                            this.reportUse(Type.getType((String)parameterDesc), UseSite.Type.ANNOTATES, RawUseSite.SiteType.METHOD_PARAMETER, name, desc, parameter);
                            return null;
                        }
                    };
                }
                return null;
            }

            public void visitEnd() {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Visited {}, isAPI={}, isInner={}, onlyAdditional={}", new Object[]{this.visitedClassInternalName, this.isPublicAPI, this.isInnerClass, context.onlyAddAdditional});
                }
                if (context.onlyAddAdditional) {
                    LOG.trace("Found in additional API classes");
                }
                if (!this.isInnerClass) {
                    if (this.visitedClassDormant) {
                        this.addDormantClass(this.visitedClassBinaryName, this.visitedClassBinaryName);
                    } else {
                        ClassTreeInitializer.this.addConditionally(currentArchive, this.visitedClassBinaryName, this.visitedClassBinaryName, null, false, context.additionalClassBinaryNames, context.dormantTypes);
                    }
                } else {
                    String rootOwner = null;
                    ArrayList<String> owners = new ArrayList<String>();
                    Iterator<OuterNameInnerNamePair> it = this.innerNames.iterator();
                    if (it.hasNext()) {
                        OuterNameInnerNamePair names = it.next();
                        if (names.outerName != null && names.innerName != null) {
                            rootOwner = names.outerName.replace('/', '.');
                            owners.add(names.innerName);
                        }
                        while (it.hasNext()) {
                            names = it.next();
                            if (names.outerName == null || names.innerName == null) {
                                rootOwner = null;
                                break;
                            }
                            owners.add(names.innerName);
                        }
                        if (rootOwner != null) {
                            StringBuilder binaryName = new StringBuilder(rootOwner);
                            StringBuilder canonicalName = new StringBuilder(rootOwner);
                            if (context.onlyAddAdditional) {
                                String name;
                                for (int i = 0; i < owners.size() - 1; ++i) {
                                    name = (String)owners.get(i);
                                    binaryName.append('$').append(name);
                                    canonicalName.append('.').append(name);
                                }
                                String owningTypeBinaryName = binaryName.toString();
                                TypeElement owningType = ClassTreeInitializer.this.findByType(owningTypeBinaryName);
                                name = (String)owners.get(owners.size() - 1);
                                binaryName.append('$').append(name);
                                canonicalName.append('.').append(name);
                                if (owningType == null) {
                                    TypeElement innerClass;
                                    if (this.visitedClassDormant) {
                                        innerClass = this.addDormantClass(binaryName.toString(), canonicalName.toString());
                                    } else {
                                        innerClass = new TypeElement(ClassTreeInitializer.this.environment, currentArchive, binaryName.toString(), canonicalName.toString());
                                        ClassTreeInitializer.this.registerType(innerClass, context.additionalClassBinaryNames, context.dormantTypes);
                                    }
                                    Set<TypeElement> innerClasses = context.innerClassPositions.get(owningTypeBinaryName);
                                    if (innerClasses == null) {
                                        innerClasses = new HashSet<TypeElement>();
                                        context.innerClassPositions.put(owningTypeBinaryName, innerClasses);
                                    }
                                    innerClasses.add(innerClass);
                                } else {
                                    ClassTreeInitializer.this.addConditionally(currentArchive, binaryName.toString(), canonicalName.toString(), owningType, false, context.additionalClassBinaryNames, context.dormantTypes);
                                }
                            } else {
                                TypeElement owningType = ClassTreeInitializer.this.addConditionally(currentArchive, binaryName.toString(), canonicalName.toString(), null, false, context.additionalClassBinaryNames, context.dormantTypes);
                                for (String name : owners) {
                                    binaryName.append('$').append(name);
                                    canonicalName.append('.').append(name);
                                    owningType = ClassTreeInitializer.this.addConditionally(currentArchive, binaryName.toString(), canonicalName.toString(), owningType, false, context.additionalClassBinaryNames, context.dormantTypes);
                                }
                            }
                        }
                    }
                }
            }

            private TypeElement addDormantClass(String binaryName, String canonicalName) {
                TypeElementAndUseSites tus = context.dormantTypes.get(binaryName);
                if (tus == null) {
                    tus = new TypeElementAndUseSites(new TypeElement(ClassTreeInitializer.this.environment, currentArchive, binaryName, canonicalName));
                    context.dormantTypes.put(binaryName, tus);
                } else if (tus.type == null) {
                    tus.type = new TypeElement(ClassTreeInitializer.this.environment, currentArchive, binaryName, canonicalName);
                }
                return tus.type;
            }

            private void reportUse(Type t, UseSite.Type useType, RawUseSite.SiteType siteType, String siteName, String siteDescriptor, int sitePosition) {
                if (t.getSort() < 9) {
                    return;
                }
                if (ClassTreeInitializer.this.ignoreMissingAnnotations && useType == UseSite.Type.ANNOTATES) {
                    return;
                }
                String binaryName = t.getClassName();
                if (ClassTreeInitializer.this.comesFromRtJar(binaryName)) {
                    return;
                }
                if (ClassTreeInitializer.this.findByType(binaryName) == null) {
                    TypeElementAndUseSites dormantType;
                    if (!this.visitedClassDormant && (dormantType = context.dormantTypes.get(binaryName)) != null) {
                        if (dormantType.type != null && !dormantType.type.isInnerClass()) {
                            ClassTreeInitializer.this.registerType(dormantType.type, context.additionalClassBinaryNames, context.dormantTypes);
                            ClassTreeInitializer.this.environment.getTree().getRootsUnsafe().add(dormantType.type);
                        }
                        this.addUse(binaryName, useType, siteType, siteName, siteDescriptor, sitePosition);
                        return;
                    }
                    switch (t.getSort()) {
                        case 10: {
                            if (!ClassTreeInitializer.this.ignoreAdditionalArchivesContributions && !this.visitedClassDormant) {
                                context.additionalClassBinaryNames.add(binaryName);
                                LOG.trace("Adding to additional classes: {}", (Object)binaryName);
                            }
                            this.addUse(binaryName, useType, siteType, siteName, siteDescriptor, sitePosition);
                            break;
                        }
                        case 9: {
                            String desc = t.getDescriptor();
                            desc = desc.substring(desc.lastIndexOf(91) + 1);
                            this.reportUse(Type.getType((String)desc), useType, siteType, siteName, siteDescriptor, sitePosition);
                            break;
                        }
                        case 11: {
                            throw new AssertionError((Object)"A method type should not enter here.");
                        }
                    }
                } else {
                    LOG.trace("Not adding to additional classes: {}", (Object)binaryName);
                    context.additionalClassBinaryNames.remove(binaryName);
                    this.addUse(binaryName, useType, siteType, siteName, siteDescriptor, sitePosition);
                }
            }

            private void addUse(String binaryName, UseSite.Type useType, RawUseSite.SiteType siteType, String siteName, String siteDescriptor, int sitePosition) {
                Map<String, Set<RawUseSite>> useSites;
                if (this.visitedClassDormant) {
                    TypeElementAndUseSites tus = context.dormantTypes.get(this.visitedClassBinaryName);
                    if (tus == null) {
                        tus = new TypeElementAndUseSites();
                        context.dormantTypes.put(this.visitedClassBinaryName, tus);
                    }
                    useSites = tus.getUseSites();
                } else {
                    useSites = ClassTreeInitializer.this.environment.getUseSiteMap();
                }
                Set<RawUseSite> sites = useSites.get(binaryName);
                if (sites == null) {
                    sites = new HashSet<RawUseSite>();
                    useSites.put(binaryName, sites);
                }
                RawUseSite useSite = new RawUseSite(useType, siteType, this.visitedClassBinaryName, siteName, siteDescriptor, sitePosition);
                sites.add(useSite);
            }

            private boolean isTransitiveOwnerOfVisitedClass(String owningClass) {
                if (this.visitedClassOwners == null) {
                    return false;
                }
                if (owningClass.length() > this.visitedClassInternalName.length()) {
                    return false;
                }
                int startIdx = 0;
                int dollarIdx = owningClass.indexOf(36);
                int ownerIdx = 0;
                while (dollarIdx >= 0 && ownerIdx < this.visitedClassOwners.length) {
                    String owner = owningClass.substring(startIdx, dollarIdx);
                    if (!this.visitedClassOwners[ownerIdx++].equals(owner)) {
                        return false;
                    }
                    startIdx = dollarIdx + 1;
                    dollarIdx = owningClass.indexOf(36, startIdx);
                }
                if (ownerIdx < this.visitedClassOwners.length) {
                    return this.visitedClassOwners[ownerIdx].equals(owningClass.substring(startIdx));
                }
                return dollarIdx == -1;
            }
        }, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean comesFromRtJar(String typeBinaryName) {
        if (typeBinaryName.startsWith("java.")) {
            return true;
        }
        if (this.bootstrapClasses == null) {
            long time = 0L;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Building bootstrap classes cache");
                time = System.currentTimeMillis();
            }
            this.bootstrapClasses = new HashSet();
            for (File f : this.bootstrapClasspath) {
                ZipFile jar = null;
                try {
                    jar = new ZipFile(f);
                    Enumeration<? extends ZipEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (!name.endsWith(".class")) continue;
                        name = name.substring(0, name.length() - 6).replace('/', '.');
                        this.bootstrapClasses.add(name);
                    }
                    jar.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to analyze bootstrap class path entry at " + f.getAbsolutePath(), (Throwable)e);
                }
                finally {
                    try {
                        if (jar == null) continue;
                        jar.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close bootstrap classpath entry (" + f.getAbsolutePath() + ").", (Throwable)e);
                    }
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Bootstrap classpath cache built in " + (System.currentTimeMillis() - time) + "ms containing " + this.bootstrapClasses.size() + " entries.");
            }
        }
        return this.bootstrapClasses.contains(typeBinaryName);
    }

    private TypeElement addConditionally(Archive currentArchive, String binaryName, String canonicalName, TypeElement owningType, boolean asError, Set<String> additionalClasses, Map<String, TypeElementAndUseSites> dormantTypes) {
        boolean add = false;
        TypeElement type = this.findByType(binaryName);
        if (type == null) {
            add = true;
            TypeElement typeElement = type = asError ? new MissingClassElement(this.environment, binaryName, canonicalName) : new TypeElement(this.environment, currentArchive, binaryName, canonicalName);
        }
        if (add) {
            LOG.trace("Adding to tree: {}, under superType {}", (Object)type, (Object)owningType);
            if (owningType == null) {
                this.environment.getTree().getRootsUnsafe().add(type);
            } else {
                owningType.getChildren().add(type);
            }
            this.registerType(type, additionalClasses, dormantTypes);
        }
        return type;
    }

    private void registerType(TypeElement type, Set<String> additionalClasses, Map<String, TypeElementAndUseSites> dormantTypes) {
        boolean asError = type instanceof MissingClassElement;
        this.typeCache.put(type.getBinaryName(), type);
        TypeElementAndUseSites useSites = dormantTypes.remove(type.getBinaryName());
        if (useSites != null && !useSites.getUseSites().isEmpty()) {
            for (Map.Entry entry : useSites.getUseSites().entrySet()) {
                additionalClasses.add((String)entry.getKey());
                this.addUses((String)entry.getKey(), (Collection)entry.getValue());
            }
        }
        if (!asError) {
            additionalClasses.remove(type.getBinaryName());
        }
        for (JavaElement javaElement : type.getChildren()) {
            if (!(javaElement instanceof TypeElement)) continue;
            String binaryName = ((TypeElement)javaElement).getBinaryName();
            this.typeCache.put(binaryName, (TypeElement)javaElement);
            if (asError) continue;
            additionalClasses.remove(binaryName);
        }
    }

    private void addUses(String binaryName, Collection<RawUseSite> useSites) {
        Set<RawUseSite> sites = this.environment.getUseSiteMap().get(binaryName);
        if (sites == null) {
            sites = new HashSet<RawUseSite>();
            this.environment.getUseSiteMap().put(binaryName, sites);
        }
        sites.addAll(useSites);
    }

    private TypeElement findByType(String binaryName) {
        return this.typeCache.get(binaryName);
    }

    private static boolean isPublic(int access) {
        return (access & 0x1000) == 0 && (access & 0x40) == 0 && ((access & 1) != 0 || (access & 4) != 0);
    }

    private boolean removeClassesFromRtJar(Set<String> classes) {
        boolean changed = false;
        LOG.trace("Identified additional classes contributing to API not on classpath (maybe in rt.jar): {}", classes);
        Iterator<String> it = classes.iterator();
        while (it.hasNext()) {
            String binaryName = it.next();
            if (!this.comesFromRtJar(binaryName)) continue;
            changed = true;
            it.remove();
        }
        return changed;
    }

    private static class InitTreeContext {
        boolean onlyAddAdditional;
        final Set<String> additionalClassBinaryNames = new HashSet<String>();
        final TreeMap<String, Set<TypeElement>> innerClassPositions = new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return this.countDollars(a) - this.countDollars(b);
            }

            private int countDollars(String s) {
                int ret = 0;
                int startIdx = 0;
                do {
                    startIdx = s.indexOf(36, startIdx) + 1;
                    ++ret;
                } while (startIdx > 0);
                return ret;
            }
        });
        final Map<String, TypeElementAndUseSites> dormantTypes = new HashMap<String, TypeElementAndUseSites>();

        private InitTreeContext() {
        }
    }

    private static class TypeElementAndUseSites {
        TypeElement type;
        private Map<String, Set<RawUseSite>> useSites;

        TypeElementAndUseSites() {
        }

        TypeElementAndUseSites(TypeElement type) {
            this.type = type;
        }

        public Map<String, Set<RawUseSite>> getUseSites() {
            if (this.useSites == null) {
                this.useSites = new HashMap<String, Set<RawUseSite>>();
            }
            return this.useSites;
        }
    }

    private static class OuterNameInnerNamePair
    implements Comparable<OuterNameInnerNamePair> {
        final String outerName;
        final String innerName;

        private OuterNameInnerNamePair(String outerName, String innerName) {
            this.outerName = outerName;
            this.innerName = innerName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OuterNameInnerNamePair that = (OuterNameInnerNamePair)o;
            if (this.outerName != null ? !this.outerName.equals(that.outerName) : that.outerName != null) {
                return false;
            }
            return !(this.innerName != null ? !this.innerName.equals(that.innerName) : that.innerName != null);
        }

        public int hashCode() {
            int result = this.outerName != null ? this.outerName.hashCode() : 0;
            result = 31 * result + (this.innerName != null ? this.innerName.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(OuterNameInnerNamePair o) {
            int ret = OuterNameInnerNamePair.safeCompare(this.outerName, o.outerName);
            return ret != 0 ? ret : OuterNameInnerNamePair.safeCompare(this.innerName, o.innerName);
        }

        private static int safeCompare(String a, String b) {
            int ret = a == null ? (b == null ? 0 : 1) : (b == null ? -1 : a.compareTo(b));
            return ret;
        }
    }
}

