/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import javax.annotation.Nonnull;

final class IgnoreCompletionFailures {
    private IgnoreCompletionFailures() {
    }

    private static boolean isCompletionFailure(@Nonnull Throwable t) {
        return t.getClass().getName().endsWith("CompletionFailure");
    }

    static <R, T> R call(Fn1<R, T> action, T arg) {
        while (true) {
            try {
                return action.call(arg);
            }
            catch (Exception e) {
                Exception fail;
                if (IgnoreCompletionFailures.isCompletionFailure(fail = e)) continue;
                throw new IllegalStateException(fail);
            }
            break;
        }
    }

    static <R, T1, T2> R call(Fn2<R, T1, T2> action, T1 arg1, T2 arg2) {
        while (true) {
            try {
                return action.call(arg1, arg2);
            }
            catch (Exception e) {
                Exception fail;
                if (IgnoreCompletionFailures.isCompletionFailure(fail = e)) continue;
                throw new IllegalStateException(fail);
            }
            break;
        }
    }

    static <R, T1, T2, T3> R call(Fn3<R, T1, T2, T3> action, T1 arg1, T2 arg2, T3 arg3) {
        while (true) {
            try {
                return action.call(arg1, arg2, arg3);
            }
            catch (Exception e) {
                Exception fail;
                if (IgnoreCompletionFailures.isCompletionFailure(fail = e)) continue;
                throw new IllegalStateException(fail);
            }
            break;
        }
    }

    static interface Fn3<R, T1, T2, T3> {
        public R call(T1 var1, T2 var2, T3 var3) throws Exception;
    }

    static interface Fn2<R, T1, T2> {
        public R call(T1 var1, T2 var2) throws Exception;
    }

    static interface Fn1<R, T> {
        public R call(T var1) throws Exception;
    }
}

