/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.revapi.java.compilation.IgnoreCompletionFailures;
import org.revapi.java.model.MissingTypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MissingTypeAwareDelegatingElements
implements Elements {
    private static final Logger LOG = LoggerFactory.getLogger(MissingTypeAwareDelegatingElements.class);
    private final Elements elements;
    private final IgnoreCompletionFailures.Fn1<PackageElement, CharSequence> getPackageElement = new IgnoreCompletionFailures.Fn1<PackageElement, CharSequence>(){

        @Override
        public PackageElement call(CharSequence name) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.getPackageElement(name);
        }
    };
    private final IgnoreCompletionFailures.Fn1<TypeElement, CharSequence> getTypeElement = new IgnoreCompletionFailures.Fn1<TypeElement, CharSequence>(){

        @Override
        public TypeElement call(CharSequence name) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.getTypeElement(name);
        }
    };
    private final IgnoreCompletionFailures.Fn1<Map<? extends ExecutableElement, ? extends AnnotationValue>, AnnotationMirror> getElementValuesWithDefaults = new IgnoreCompletionFailures.Fn1<Map<? extends ExecutableElement, ? extends AnnotationValue>, AnnotationMirror>(){

        @Override
        public Map<? extends ExecutableElement, ? extends AnnotationValue> call(AnnotationMirror annotationMirror) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.getElementValuesWithDefaults(annotationMirror);
        }
    };
    private final IgnoreCompletionFailures.Fn1<String, Element> getDocComment = new IgnoreCompletionFailures.Fn1<String, Element>(){

        @Override
        public String call(Element element) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.getDocComment(element);
        }
    };
    private final IgnoreCompletionFailures.Fn1<Boolean, Element> isDeprecated = new IgnoreCompletionFailures.Fn1<Boolean, Element>(){

        @Override
        public Boolean call(Element element) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.isDeprecated(element);
        }
    };
    private final IgnoreCompletionFailures.Fn1<Name, TypeElement> getBinaryName = new IgnoreCompletionFailures.Fn1<Name, TypeElement>(){

        @Override
        public Name call(TypeElement type) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.getBinaryName(type);
        }
    };
    private final IgnoreCompletionFailures.Fn1<PackageElement, Element> getPackageOf = new IgnoreCompletionFailures.Fn1<PackageElement, Element>(){

        @Override
        public PackageElement call(Element element) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.getPackageOf(element);
        }
    };
    private final IgnoreCompletionFailures.Fn1<List<? extends Element>, TypeElement> getAllMembers = new IgnoreCompletionFailures.Fn1<List<? extends Element>, TypeElement>(){

        @Override
        public List<? extends Element> call(TypeElement element) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.getAllMembers(element);
        }
    };
    private final IgnoreCompletionFailures.Fn1<List<? extends AnnotationMirror>, Element> getAllAnnotationMirrors = new IgnoreCompletionFailures.Fn1<List<? extends AnnotationMirror>, Element>(){

        @Override
        public List<? extends AnnotationMirror> call(Element element) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.getAllAnnotationMirrors(element);
        }
    };
    private final IgnoreCompletionFailures.Fn2<Boolean, Element, Element> hides = new IgnoreCompletionFailures.Fn2<Boolean, Element, Element>(){

        @Override
        public Boolean call(Element hider, Element hidden) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.hides(hider, hidden);
        }
    };
    private final IgnoreCompletionFailures.Fn3<Boolean, ExecutableElement, ExecutableElement, TypeElement> overrides = new IgnoreCompletionFailures.Fn3<Boolean, ExecutableElement, ExecutableElement, TypeElement>(){

        @Override
        public Boolean call(ExecutableElement m1, ExecutableElement m2, TypeElement type) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.overrides(m1, m2, type);
        }
    };
    private final IgnoreCompletionFailures.Fn1<String, Object> getConstantExpression = new IgnoreCompletionFailures.Fn1<String, Object>(){

        @Override
        public String call(Object o) throws Exception {
            return MissingTypeAwareDelegatingElements.this.elements.getConstantExpression(o);
        }
    };
    private final IgnoreCompletionFailures.Fn2<Void, Writer, Element[]> printElements = new IgnoreCompletionFailures.Fn2<Void, Writer, Element[]>(){

        @Override
        public Void call(Writer writer, Element[] things) throws Exception {
            MissingTypeAwareDelegatingElements.this.elements.printElements(writer, things);
            return null;
        }
    };

    MissingTypeAwareDelegatingElements(Elements elements) {
        this.elements = elements;
    }

    @Override
    public PackageElement getPackageElement(CharSequence name) {
        return IgnoreCompletionFailures.call(this.getPackageElement, name);
    }

    @Override
    public TypeElement getTypeElement(CharSequence name) {
        return IgnoreCompletionFailures.call(this.getTypeElement, name);
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return IgnoreCompletionFailures.call(this.getElementValuesWithDefaults, a);
    }

    @Override
    public String getDocComment(Element e) {
        if (MissingTypeElement.isMissing(e)) {
            return "";
        }
        return IgnoreCompletionFailures.call(this.getDocComment, e);
    }

    @Override
    public boolean isDeprecated(Element e) {
        if (MissingTypeElement.isMissing(e)) {
            return false;
        }
        return IgnoreCompletionFailures.call(this.isDeprecated, e);
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        if (MissingTypeElement.isMissing(type)) {
            return type.getQualifiedName();
        }
        return IgnoreCompletionFailures.call(this.getBinaryName, type);
    }

    @Override
    public PackageElement getPackageOf(Element type) {
        if (MissingTypeElement.isMissing(type)) {
            String binaryName = ((MissingTypeElement)type).getQualifiedName().toString();
            int lastDot = binaryName.lastIndexOf(46);
            return this.elements.getPackageElement(binaryName.substring(0, lastDot));
        }
        return IgnoreCompletionFailures.call(this.getPackageOf, type);
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement type) {
        if (MissingTypeElement.isMissing(type)) {
            return Collections.emptyList();
        }
        return IgnoreCompletionFailures.call(this.getAllMembers, type);
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        if (MissingTypeElement.isMissing(e)) {
            return Collections.emptyList();
        }
        return IgnoreCompletionFailures.call(this.getAllAnnotationMirrors, e);
    }

    @Override
    public boolean hides(Element hider, Element hidden) {
        if (MissingTypeElement.isMissing(hider) || MissingTypeElement.isMissing(hidden)) {
            return false;
        }
        return IgnoreCompletionFailures.call(this.hides, hider, hidden);
    }

    @Override
    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        if (MissingTypeElement.isMissing(type)) {
            return false;
        }
        return IgnoreCompletionFailures.call(this.overrides, overrider, overridden, type);
    }

    @Override
    public String getConstantExpression(Object value) {
        return IgnoreCompletionFailures.call(this.getConstantExpression, value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        IgnoreCompletionFailures.call(this.printElements, w, elements);
    }

    @Override
    public Name getName(CharSequence cs) {
        try {
            return this.elements.getName(cs);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

