/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import org.revapi.java.spi.UseSite;

final class RawUseSite {
    private final UseSite.Type useType;
    private final String siteClass;
    private final String siteName;
    private final String siteDescriptor;
    private final SiteType siteType;
    private final int sitePosition;

    RawUseSite(UseSite.Type useType, SiteType siteType, String siteClass, String siteName, String siteDescriptor) {
        this(useType, siteType, siteClass, siteName, siteDescriptor, -1);
    }

    RawUseSite(UseSite.Type useType, SiteType siteType, String siteClass, String siteName, String siteDescriptor, int sitePosition) {
        this.useType = useType;
        this.siteType = siteType;
        this.siteClass = siteClass;
        this.siteName = siteName;
        this.siteDescriptor = siteDescriptor;
        this.sitePosition = sitePosition;
    }

    public UseSite.Type getUseType() {
        return this.useType;
    }

    public SiteType getSiteType() {
        return this.siteType;
    }

    public String getSiteClass() {
        return this.siteClass;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getSiteDescriptor() {
        return this.siteDescriptor;
    }

    public int getSitePosition() {
        return this.sitePosition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RawUseSite[");
        sb.append("siteClass='").append(this.siteClass).append('\'');
        sb.append(", siteDescriptor='").append(this.siteDescriptor).append('\'');
        sb.append(", siteName='").append(this.siteName).append('\'');
        sb.append(", sitePosition=").append(this.sitePosition);
        sb.append(", siteType=").append((Object)this.siteType);
        sb.append(", useType=").append(this.useType);
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawUseSite that = (RawUseSite)o;
        if (this.sitePosition != that.sitePosition) {
            return false;
        }
        if (!this.siteClass.equals(that.siteClass)) {
            return false;
        }
        if (this.siteDescriptor != null ? !this.siteDescriptor.equals(that.siteDescriptor) : that.siteDescriptor != null) {
            return false;
        }
        if (this.siteName != null ? !this.siteName.equals(that.siteName) : that.siteName != null) {
            return false;
        }
        if (this.siteType != that.siteType) {
            return false;
        }
        return this.useType == that.useType;
    }

    public int hashCode() {
        int result = this.useType.hashCode();
        result = 31 * result + this.siteClass.hashCode();
        result = 31 * result + (this.siteName != null ? this.siteName.hashCode() : 0);
        result = 31 * result + (this.siteDescriptor != null ? this.siteDescriptor.hashCode() : 0);
        result = 31 * result + this.siteType.hashCode();
        result = 31 * result + this.sitePosition;
        return result;
    }

    public static enum SiteType {
        CLASS,
        FIELD,
        METHOD,
        METHOD_PARAMETER;

    }
}

