/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.API;
import org.revapi.Element;
import org.revapi.java.model.TypeElement;
import org.revapi.query.Filter;
import org.revapi.simple.SimpleElementForest;

public final class JavaElementForest
extends SimpleElementForest {
    private Future<?> compilation;
    private static final ThreadLocal<Boolean> UNSAFE_MODE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public JavaElementForest(API api) {
        super(api);
    }

    public void setCompilationFuture(Future<?> compilation) {
        this.compilation = compilation;
    }

    @Nonnull
    public SortedSet<TypeElement> getRoots() {
        this.waitForCompilation();
        return super.getRoots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<TypeElement> getRootsUnsafe() {
        boolean wasUnsafe = UNSAFE_MODE.get();
        try {
            UNSAFE_MODE.set(true);
            SortedSet sortedSet = super.getRoots();
            return sortedSet;
        }
        finally {
            UNSAFE_MODE.set(wasUnsafe);
        }
    }

    public <T extends Element> void search(@Nonnull List<T> results, @Nonnull Class<T> resultType, @Nonnull SortedSet<? extends Element> currentLevel, boolean recurse, @Nullable Filter<? super T> filter) {
        this.waitForCompilation();
        super.search(results, resultType, currentLevel, recurse, filter);
    }

    @Nonnull
    public <T extends Element> List<T> search(@Nonnull Class<T> resultType, boolean recurse, @Nullable Filter<? super T> filter, @Nullable Element root) {
        this.waitForCompilation();
        return super.search(resultType, recurse, filter, root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Element> List<T> searchUnsafe(Class<T> resultType, boolean recurse, Filter<? super T> filter, Element root) {
        boolean wasUnsafe = UNSAFE_MODE.get();
        try {
            UNSAFE_MODE.set(true);
            List list = super.search(resultType, recurse, filter, root);
            return list;
        }
        finally {
            UNSAFE_MODE.set(wasUnsafe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean unsafe = UNSAFE_MODE.get();
        try {
            UNSAFE_MODE.set(true);
            String string = super.toString();
            return string;
        }
        finally {
            UNSAFE_MODE.set(unsafe);
        }
    }

    private void waitForCompilation() {
        try {
            if (this.compilation != null && !UNSAFE_MODE.get().booleanValue()) {
                this.compilation.get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting for compilation to finish.");
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to obtain class tree due to compilation failure.", e.getCause());
        }
    }
}

