/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.generics;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.Util;

public final class FormalTypeParametersChanged
extends CheckBase {
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS, Check.Type.METHOD);
    }

    protected void doVisitClass(@Nullable JavaTypeElement oldType, @Nullable JavaTypeElement newType) {
        this.doVisit((JavaModelElement)oldType, (JavaModelElement)newType);
    }

    protected void doVisitMethod(@Nullable JavaMethodElement oldMethod, @Nullable JavaMethodElement newMethod) {
        this.doVisit((JavaModelElement)oldMethod, (JavaModelElement)newMethod);
    }

    private void doVisit(@Nullable JavaModelElement oldElement, @Nullable JavaModelElement newElement) {
        if (!this.isBothAccessible(oldElement, newElement)) {
            return;
        }
        assert (oldElement != null);
        assert (newElement != null);
        Parameterizable oldEl = (Parameterizable)oldElement.getDeclaringElement();
        Parameterizable newEl = (Parameterizable)newElement.getDeclaringElement();
        List<? extends TypeParameterElement> oldPars = oldEl.getTypeParameters();
        List<? extends TypeParameterElement> newPars = newEl.getTypeParameters();
        if (oldPars.size() == 0 && oldPars.size() == newPars.size()) {
            return;
        }
        ArrayList<TypeParameterElement> added = new ArrayList<TypeParameterElement>();
        ArrayList<TypeParameterElement> removed = new ArrayList<TypeParameterElement>();
        LinkedHashMap<TypeParameterElement, TypeParameterElement> changed = new LinkedHashMap<TypeParameterElement, TypeParameterElement>();
        Iterator<? extends TypeParameterElement> oldIt = oldPars.iterator();
        Iterator<? extends TypeParameterElement> newIt = newPars.iterator();
        while (oldIt.hasNext() && newIt.hasNext()) {
            String newS;
            TypeParameterElement oldT = oldIt.next();
            TypeParameterElement newT = newIt.next();
            String oldS = Util.toUniqueString((TypeMirror)oldT.asType());
            if (oldS.equals(newS = Util.toUniqueString((TypeMirror)newT.asType()))) continue;
            changed.put(oldT, newT);
        }
        while (oldIt.hasNext()) {
            removed.add(oldIt.next());
        }
        while (newIt.hasNext()) {
            added.add(newIt.next());
        }
        if (!(added.isEmpty() && removed.isEmpty() && changed.isEmpty())) {
            this.pushActive((JavaElement)oldElement, (JavaElement)newElement, new Object[]{added, removed, changed});
        }
    }

    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements els = this.popIfActive();
        if (els == null) {
            return null;
        }
        List added = (List)els.context[0];
        List removed = (List)els.context[1];
        Map changed = (Map)els.context[2];
        Parameterizable oldT = (Parameterizable)((JavaModelElement)els.oldElement).getDeclaringElement();
        ArrayList<Difference> diffs = new ArrayList<Difference>();
        if (oldT.getTypeParameters().isEmpty()) {
            diffs.add(this.createDifference(Code.GENERICS_ELEMENT_NOW_PARAMETERIZED, Code.attachmentsFor((JavaElement)els.oldElement, (JavaElement)els.newElement, (String[])new String[0])));
        }
        for (TypeParameterElement typeParameterElement : added) {
            diffs.add(this.createDifferenceWithExplicitParams(Code.GENERICS_FORMAL_TYPE_PARAMETER_ADDED, Code.attachmentsFor((JavaElement)els.oldElement, (JavaElement)els.newElement, (String[])new String[0]), new String[]{Util.toHumanReadableString((AnnotatedConstruct)typeParameterElement)}));
        }
        for (TypeParameterElement typeParameterElement : removed) {
            diffs.add(this.createDifferenceWithExplicitParams(Code.GENERICS_FORMAL_TYPE_PARAMETER_REMOVED, Code.attachmentsFor((JavaElement)els.oldElement, (JavaElement)els.newElement, (String[])new String[0]), new String[]{Util.toHumanReadableString((AnnotatedConstruct)typeParameterElement)}));
        }
        for (Map.Entry entry : changed.entrySet()) {
            String oldP = Util.toHumanReadableString((AnnotatedConstruct)((AnnotatedConstruct)entry.getKey()));
            String newP = Util.toHumanReadableString((AnnotatedConstruct)((AnnotatedConstruct)entry.getValue()));
            diffs.add(this.createDifferenceWithExplicitParams(Code.GENERICS_FORMAL_TYPE_PARAMETER_CHANGED, Code.attachmentsFor((JavaElement)els.oldElement, (JavaElement)els.newElement, (String[])new String[]{"oldTypeParameter", oldP, "newTypeParameter", newP}), new String[]{oldP, newP}));
        }
        return diffs;
    }
}

