/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.SimpleElementVisitor8;
import org.revapi.Archive;
import org.revapi.Element;
import org.revapi.java.FlatFilter;
import org.revapi.java.compilation.ClassPathUseSite;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.FieldElement;
import org.revapi.java.model.JavaElementBase;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.MethodParameterElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.UseSite;
import org.revapi.java.spi.Util;

public class TypeElement
extends JavaElementBase<javax.lang.model.element.TypeElement, DeclaredType>
implements JavaTypeElement {
    private final String binaryName;
    private final String canonicalName;
    private Set<UseSite> useSites;
    private Set<ClassPathUseSite> rawUseSites;
    private boolean inApi;
    private boolean inApiThroughUse;

    public TypeElement(ProbingEnvironment env, Archive archive, String binaryName, String canonicalName) {
        super(env, archive, null, null);
        this.binaryName = binaryName;
        this.canonicalName = canonicalName;
    }

    public TypeElement(ProbingEnvironment env, Archive archive, javax.lang.model.element.TypeElement element, DeclaredType type) {
        super(env, archive, element, type);
        this.binaryName = env.getElementUtils().getBinaryName(element).toString();
        this.canonicalName = element.getQualifiedName().toString();
    }

    @Override
    @Nonnull
    protected String getHumanReadableElementType() {
        switch (((javax.lang.model.element.TypeElement)this.element).getKind()) {
            case ANNOTATION_TYPE: {
                return "@interface";
            }
            case CLASS: {
                return "class";
            }
            case ENUM: {
                return "enum";
            }
            case INTERFACE: {
                return "interface";
            }
        }
        return "class";
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public boolean isInAPI() {
        return this.inApi;
    }

    public boolean isInApiThroughUse() {
        return this.inApiThroughUse;
    }

    public Set<UseSite> getUseSites() {
        if (this.useSites == null) {
            this.useSites = this.rawUseSites == null ? Collections.emptySet() : this.rawUseSites.stream().map(u -> {
                JavaModelElement model = this.getModel(u.site, u.indexInParent);
                return model == null ? null : new UseSite(u.useType, (JavaElement)model);
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            this.rawUseSites = null;
        }
        return this.useSites;
    }

    public void setInApi(boolean inApi) {
        this.inApi = inApi;
    }

    public void setInApiThroughUse(boolean inApiThroughUse) {
        this.inApiThroughUse = inApiThroughUse;
    }

    public void setRawUseSites(Set<ClassPathUseSite> rawUseSites) {
        this.rawUseSites = rawUseSites;
    }

    @Override
    public int compareTo(@Nonnull Element o) {
        if (!o.getClass().equals(TypeElement.class)) {
            return JavaElementFactory.compareByType((Element)this, o);
        }
        return this.binaryName.compareTo(((TypeElement)o).binaryName);
    }

    @Override
    protected String createFullHumanReadableString() {
        Object rep = this.getModelRepresentation();
        return this.getHumanReadableElementType() + " " + (rep == null ? this.canonicalName : Util.toHumanReadableString(rep));
    }

    @Override
    protected String createComparableSignature() {
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " (archive = " + this.archive + ", in api = " + this.inApi + ", through use = " + this.inApiThroughUse + ")";
    }

    @Override
    public TypeElement clone() {
        return (TypeElement)super.clone();
    }

    private JavaModelElement getModel(javax.lang.model.element.Element element, final int indexInParent) {
        return element.accept(new SimpleElementVisitor8<JavaModelElement, Void>(){

            @Override
            public JavaModelElement visitVariable(VariableElement e, Void ignored) {
                if (e.getEnclosingElement() instanceof javax.lang.model.element.TypeElement) {
                    TypeElement type = TypeElement.this.environment.getTypeMap().get(e.getEnclosingElement());
                    if (type == null) {
                        return null;
                    }
                    List fs = type.searchChildren(FieldElement.class, false, FlatFilter.by(f -> ((VariableElement)f.getDeclaringElement()).equals(e)));
                    return (JavaModelElement)fs.get(0);
                }
                if (e.getEnclosingElement() instanceof ExecutableElement) {
                    javax.lang.model.element.Element methodEl = e.getEnclosingElement();
                    TypeElement type = TypeElement.this.environment.getTypeMap().get(methodEl.getEnclosingElement());
                    if (type == null) {
                        return null;
                    }
                    List ms = type.searchChildren(MethodElement.class, false, FlatFilter.by(m -> ((ExecutableElement)m.getDeclaringElement()).equals(methodEl)));
                    MethodElement method = (MethodElement)((Object)ms.get(0));
                    List params = method.searchChildren(MethodParameterElement.class, false, FlatFilter.by(p -> true));
                    return (JavaModelElement)params.get(indexInParent);
                }
                return null;
            }

            @Override
            public JavaModelElement visitType(javax.lang.model.element.TypeElement e, Void ignored) {
                return TypeElement.this.environment.getTypeMap().get(e);
            }

            @Override
            public JavaModelElement visitExecutable(ExecutableElement e, Void ignored) {
                TypeElement type = TypeElement.this.environment.getTypeMap().get(e.getEnclosingElement());
                if (type == null) {
                    return null;
                }
                List ms = type.searchChildren(MethodElement.class, false, FlatFilter.by(m -> ((ExecutableElement)m.getDeclaringElement()).equals(e)));
                return (JavaModelElement)ms.get(0);
            }
        }, null);
    }
}

