/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.revapi.classif.TestResult;
import org.revapi.classif.util.Globbed;

public final class Glob<T extends Globbed> {
    private final MatchState<T> startState;
    private final List<T> matches;

    public Glob(List<T> matches) {
        this.matches = matches;
        MatchState start = new MatchState();
        ArrayList currents = new ArrayList(2);
        currents.add(start);
        for (Globbed m : matches) {
            MatchState next;
            if (m.isMatchAll()) {
                next = new MatchState();
                currents.forEach(ms -> ((MatchState)ms).nexts.put(m, next));
                next.nexts.put(m, next);
                currents.add(next);
                continue;
            }
            next = new MatchState();
            currents.forEach(ms -> ((MatchState)ms).nexts.put(m, next));
            currents.clear();
            currents.add(next);
        }
        currents.forEach(ms -> ((MatchState)ms).terminal = true);
        this.startState = start;
    }

    public List<T> getMatches() {
        return this.matches;
    }

    public <X> TestResult test(TestResult.BiPredicate<T, X> test, Iterable<X> elements) {
        ArrayList<MatchState<T>> branches = new ArrayList<MatchState<T>>(2);
        branches.add(this.startState);
        boolean[] isDeferred = new boolean[]{false};
        for (Object t : elements) {
            List next = branches.stream().flatMap(ms -> ((MatchState)ms).nexts.entrySet().stream().map(e -> {
                if (((Globbed)e.getKey()).isMatchAll() || ((Globbed)e.getKey()).isMatchAny()) {
                    return (MatchState)e.getValue();
                }
                switch (test.test(e.getKey(), t)) {
                    case DEFERRED: {
                        isDeferred[0] = true;
                    }
                    case PASSED: {
                        return (MatchState)e.getValue();
                    }
                }
                return null;
            }).filter(Objects::nonNull)).collect(Collectors.toList());
            if (isDeferred[0]) break;
            branches.clear();
            branches.addAll(next);
        }
        return isDeferred[0] ? TestResult.DEFERRED : TestResult.fromBoolean(branches.stream().anyMatch(ms -> ((MatchState)ms).terminal));
    }

    public <X> TestResult testUnordered(TestResult.BiPredicate<T, X> test, Iterable<X> elements) {
        return this.testUnorderedWithOptionals(test, elements, Collections.emptyList());
    }

    public <X> TestResult testUnorderedWithOptionals(TestResult.BiPredicate<T, X> test, Iterable<X> mandatory, Iterable<X> optional) {
        UnorderedMatchState<Globbed, X> state = new UnorderedMatchState<Globbed, X>(test, mandatory, optional, this.matches);
        if (state.isDegenerate()) {
            return TestResult.NOT_PASSED;
        }
        int nofMatches = state.numberOfConcreteMatches() + state.matchAnys;
        Iterator<int[]> indices = state.potentiallyMatchingPermutations();
        TestResult bestResult = TestResult.fromBoolean(!indices.hasNext() && state.numberOfConcreteMatches() == 0 && (state.matchAll || state.matchAnys >= state.mandatories && state.matchAnys <= state.list.size()));
        if (bestResult == TestResult.PASSED) {
            return bestResult;
        }
        while (indices.hasNext()) {
            TestResult permutationResult;
            int[] resultIndices = indices.next();
            Iterator<T> mit = state.concreteMatches().iterator();
            TestResult mandatoryResult = null;
            TestResult optionalResult = null;
            int mandatorySize = 0;
            int optionalSize = 0;
            for (int i = 0; i < resultIndices.length; ++i) {
                boolean increaseCount;
                boolean resMandatory;
                TestResult res;
                Ctx<X> r;
                if (mit.hasNext()) {
                    r = state.getResult((Globbed)mit.next(), resultIndices[i]);
                    res = r.testResult;
                    resMandatory = r.mandatory;
                    increaseCount = true;
                } else {
                    r = state.getUnevaluated(resultIndices[i]);
                    res = TestResult.PASSED;
                    resMandatory = r.mandatory;
                    increaseCount = false;
                }
                if (resMandatory) {
                    TestResult testResult = mandatoryResult = mandatoryResult == null ? res : mandatoryResult.and(res);
                    if (!increaseCount) continue;
                    ++mandatorySize;
                    continue;
                }
                TestResult testResult = optionalResult = optionalResult == null ? res : optionalResult.and(res);
                if (!increaseCount) continue;
                ++optionalSize;
            }
            if (mandatoryResult == null) {
                mandatoryResult = TestResult.fromBoolean(mandatorySize == 0);
            }
            if (optionalResult == null) {
                optionalResult = TestResult.fromBoolean(optionalSize == 0);
            }
            if ((bestResult = bestResult.or(permutationResult = state.matchAll ? mandatoryResult.and(optionalResult) : (nofMatches < mandatorySize ? TestResult.NOT_PASSED : (nofMatches == mandatorySize ? mandatoryResult : mandatoryResult.and(optionalResult))))) != TestResult.PASSED) continue;
            break;
        }
        return bestResult;
    }

    private static <T> Stream<T> stream(Iterable<T> it) {
        return StreamSupport.stream(it.spliterator(), false);
    }

    private static final class UnorderedMatchState<T extends Globbed, X> {
        final TestResult.BiPredicate<T, X> test;
        final List<Ctx<X>> list;
        final int matchAnys;
        final int mandatories;
        final boolean matchAll;
        final boolean nonMatchingTest;
        final Map<T, List<Ctx<X>>> individualResults;

        UnorderedMatchState(TestResult.BiPredicate<T, X> test, Iterable<X> mandatories, Iterable<X> optionals, List<T> matches) {
            this.test = test;
            int[] tmp = new int[1];
            this.list = Stream.concat(Glob.stream(mandatories).map(e -> {
                tmp[0] = tmp[0] + 1;
                return new Ctx<Object>(e, true);
            }), Glob.stream(optionals).map(e -> new Ctx<Object>(e, false))).collect(Collectors.toList());
            this.mandatories = tmp[0];
            boolean matchAll = false;
            int matchAnys = 0;
            this.individualResults = new LinkedHashMap<T, List<Ctx<X>>>();
            boolean hasNonMatchingTest = false;
            for (Globbed m : matches) {
                if (m.isMatchAll()) {
                    matchAll = true;
                    continue;
                }
                if (m.isMatchAny()) {
                    ++matchAnys;
                    continue;
                }
                ArrayList l = new ArrayList(this.list.size());
                TestResult overall = TestResult.NOT_PASSED;
                for (Ctx<X> c : this.list) {
                    Ctx copy = new Ctx(c.element, c.mandatory);
                    l.add(copy);
                    copy.testResult = test.test(m, c.element);
                    overall = overall.or(copy.testResult);
                }
                hasNonMatchingTest |= overall == TestResult.NOT_PASSED;
                this.individualResults.put(m, l);
            }
            this.matchAnys = matchAnys;
            this.matchAll = matchAll;
            this.nonMatchingTest = hasNonMatchingTest;
        }

        boolean isDegenerate() {
            if (this.nonMatchingTest) {
                return true;
            }
            int nofMatches = this.individualResults.size() + this.matchAnys;
            return nofMatches > this.list.size() || !this.matchAll && nofMatches < this.mandatories;
        }

        int numberOfConcreteMatches() {
            return this.individualResults.size();
        }

        Set<T> concreteMatches() {
            return this.individualResults.keySet();
        }

        Ctx<X> getUnevaluated(int index) {
            return this.list.get(index);
        }

        Ctx<X> getResult(T match, int index) {
            return this.individualResults.get(match).get(index);
        }

        Iterator<int[]> potentiallyMatchingPermutations() {
            if (this.individualResults.isEmpty()) {
                return new Iterator<int[]>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public int[] next() {
                        throw new NoSuchElementException();
                    }
                };
            }
            return new Iterator<int[]>(){
                final int[][] iterables;
                final int[] iterationPositions;
                final int[] ret;
                HashSet<Integer> permutationChecker;
                boolean consumed;
                {
                    this.iterables = (int[][])individualResults.values().stream().map(ctxs -> {
                        int[] all = new int[ctxs.size()];
                        int allIdx = 0;
                        for (int i = 0; i < ctxs.size(); ++i) {
                            Ctx c = (Ctx)ctxs.get(i);
                            if (!c.testResult.toBoolean(true)) continue;
                            all[allIdx++] = i;
                        }
                        int[] ret = new int[allIdx];
                        System.arraycopy(all, 0, ret, 0, allIdx);
                        return ret;
                    }).toArray(x$0 -> new int[x$0][]);
                    this.iterationPositions = new int[this.iterables.length];
                    this.iterationPositions[0] = -1;
                    this.ret = new int[this.iterables.length];
                    this.permutationChecker = new HashSet(this.iterationPositions.length);
                    this.consumed = true;
                }

                @Override
                public boolean hasNext() {
                    if (this.consumed) {
                        do {
                            boolean canHaveNext = false;
                            for (int i = 0; i < this.iterationPositions.length; ++i) {
                                if (this.iterationPositions[i] >= this.iterables[i].length - 1) continue;
                                canHaveNext = true;
                                break;
                            }
                            if (!canHaveNext) {
                                return false;
                            }
                            this.computeNext();
                        } while (!this.isValidPermutation());
                        this.consumed = false;
                    }
                    return true;
                }

                @Override
                public int[] next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    for (int i = 0; i < this.ret.length; ++i) {
                        this.ret[i] = this.iterables[i][this.iterationPositions[i]];
                    }
                    this.consumed = true;
                    return this.ret;
                }

                private void computeNext() {
                    if (!this.consumed) {
                        return;
                    }
                    for (int i = 0; i < this.iterationPositions.length; ++i) {
                        if (this.iterationPositions[i] != -1 && this.iterationPositions[i] >= this.iterables[i].length - 1) continue;
                        int n = i;
                        this.iterationPositions[n] = this.iterationPositions[n] + 1;
                        for (int j = 0; j < i; ++j) {
                            this.iterationPositions[j] = 0;
                        }
                        break;
                    }
                }

                private boolean isValidPermutation() {
                    this.permutationChecker.clear();
                    for (int i = 0; i < this.iterationPositions.length; ++i) {
                        boolean newlyAdded = this.permutationChecker.add(this.iterables[i][this.iterationPositions[i]]);
                        if (newlyAdded) continue;
                        return false;
                    }
                    return true;
                }
            };
        }
    }

    private static class Ctx<X> {
        final boolean mandatory;
        final X element;
        TestResult testResult;

        Ctx(X element, boolean mandatory) {
            this(element, mandatory, null);
        }

        Ctx(X element, boolean mandatory, TestResult testResult) {
            this.mandatory = mandatory;
            this.element = element;
            this.testResult = testResult;
        }
    }

    private static final class MatchState<T extends Globbed> {
        private final Map<T, MatchState<T>> nexts = new IdentityHashMap<T, MatchState<T>>(4);
        private boolean terminal;

        private MatchState() {
        }
    }
}

