/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaTypeElement;

public final class Added
extends CheckBase {
    private Set<Archive> primaryApi;

    @Override
    public void initialize(@Nonnull AnalysisContext analysisContext) {
        super.initialize(analysisContext);
        this.primaryApi = new HashSet<Archive>(2);
        analysisContext.getNewApi().getArchives().forEach(this.primaryApi::add);
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types != null) {
            LinkedHashMap<String, String> attachments = Code.attachmentsFor((JavaTypeElement)types.oldElement, (JavaTypeElement)types.newElement, new String[0]);
            Difference difference = this.primaryApi.contains(((JavaTypeElement)types.newElement).getArchive()) ? this.createDifference(Code.CLASS_ADDED, attachments) : this.createDifference(Code.CLASS_EXTERNAL_CLASS_EXPOSED_IN_API, attachments);
            return Collections.singletonList(difference);
        }
        return null;
    }

    @Override
    protected void doVisitClass(JavaTypeElement oldType, JavaTypeElement newType) {
        if (oldType == null && newType != null && this.isAccessible(newType)) {
            this.pushActive(null, newType, new Object[0]);
        }
    }

    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }
}

