/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.SimpleElementVisitor8;
import org.revapi.Archive;
import org.revapi.java.compilation.ClassPathUseSite;
import org.revapi.java.compilation.InheritedUseSite;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.compilation.UseSitePath;
import org.revapi.java.model.FieldElement;
import org.revapi.java.model.JavaElementBase;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.MethodParameterElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.UseSite;
import org.revapi.java.spi.Util;

public class TypeElement
extends JavaElementBase<javax.lang.model.element.TypeElement, DeclaredType>
implements JavaTypeElement {
    private static final Set<UseSite> USE_SITES_REPLACED_BY_REFERENCES = new HashSet<UseSite>();
    private static final Map<UseSite.Type, Map<TypeElement, Set<JavaModelElement>>> USED_TYPES_REPLACED_BY_REFERENCES = new HashMap<UseSite.Type, Map<TypeElement, Set<JavaModelElement>>>();
    private final String binaryName;
    private final String canonicalName;
    private Set<UseSite> useSites;
    private Set<ClassPathUseSite> rawUseSites;
    private boolean inApi;
    private boolean inApiThroughUse;
    private Map<UseSite.Type, Map<TypeElement, Set<JavaModelElement>>> usedTypes;
    private Map<UseSite.Type, Map<TypeElement, Set<UseSitePath>>> rawUsedTypes;

    TypeElement(ProbingEnvironment env, Archive archive, String binaryName, String canonicalName) {
        super(env, archive, null, null);
        this.binaryName = binaryName;
        this.canonicalName = canonicalName;
    }

    public TypeElement(ProbingEnvironment env, Archive archive, javax.lang.model.element.TypeElement element, DeclaredType type) {
        super(env, archive, element, type);
        this.binaryName = env.getElementUtils().getBinaryName(element).toString();
        this.canonicalName = element.getQualifiedName().toString();
    }

    @Override
    @Nonnull
    protected String getHumanReadableElementType() {
        switch (((javax.lang.model.element.TypeElement)this.element).getKind()) {
            case ANNOTATION_TYPE: {
                return "@interface";
            }
            case CLASS: {
                return "class";
            }
            case ENUM: {
                return "enum";
            }
            case INTERFACE: {
                return "interface";
            }
        }
        return "class";
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    public boolean isInAPI() {
        return this.inApi;
    }

    @Override
    public boolean isInApiThroughUse() {
        return this.inApiThroughUse;
    }

    public Set<UseSite> getUseSites() {
        if (this.useSites == null) {
            if (this.rawUseSites == null) {
                this.useSites = new HashSet<UseSite>(1);
            } else {
                this.useSites = new HashSet<UseSite>();
                for (ClassPathUseSite u : this.rawUseSites) {
                    JavaModelElement model = u instanceof InheritedUseSite ? this.getModel(u.site, ((InheritedUseSite)u).inheritor, u.indexInParent) : this.getModel(u.site, null, u.indexInParent);
                    if (model == null) continue;
                    this.useSites.add(new UseSite(u.useType, model));
                }
            }
            this.rawUseSites = null;
        }
        return this.useSites;
    }

    public Map<UseSite.Type, Map<TypeElement, Set<JavaModelElement>>> getUsedTypes() {
        if (this.usedTypes == null) {
            this.usedTypes = new HashMap<UseSite.Type, Map<TypeElement, Set<JavaModelElement>>>();
            if (this.rawUsedTypes != null) {
                for (Map.Entry<UseSite.Type, Map<TypeElement, Set<UseSitePath>>> e : this.rawUsedTypes.entrySet()) {
                    for (Map.Entry<TypeElement, Set<UseSitePath>> sites : e.getValue().entrySet()) {
                        TypeElement type = sites.getKey();
                        HashSet<JavaModelElement> users = new HashSet<JavaModelElement>();
                        for (UseSitePath path : sites.getValue()) {
                            JavaModelElement model;
                            int index = -1;
                            if (path.useSite instanceof VariableElement && path.useSite.getEnclosingElement() instanceof ExecutableElement) {
                                index = ((ExecutableElement)path.useSite.getEnclosingElement()).getParameters().indexOf(path.useSite);
                            }
                            TypeElement owner = null;
                            if (path.owner != null) {
                                owner = (TypeElement)this.getModel(path.owner, null, -1);
                            }
                            if ((model = this.getModel(path.useSite, owner, index)) == null) continue;
                            users.add(model);
                        }
                        this.usedTypes.computeIfAbsent(e.getKey(), __ -> new HashMap()).put(type, users);
                    }
                }
            }
        }
        return this.usedTypes;
    }

    public void setRawUsedTypes(Map<UseSite.Type, Map<TypeElement, Set<UseSitePath>>> usedTypes) {
        this.rawUsedTypes = usedTypes;
    }

    public void setInApi(boolean inApi) {
        this.inApi = inApi;
    }

    public void setInApiThroughUse(boolean inApiThroughUse) {
        this.inApiThroughUse = inApiThroughUse;
    }

    public void setRawUseSites(Set<ClassPathUseSite> rawUseSites) {
        this.rawUseSites = rawUseSites;
    }

    public void initReferences() {
        if (this.useSites != USE_SITES_REPLACED_BY_REFERENCES) {
            for (UseSite us : this.getUseSites()) {
                this.getReferencingElements().add(us);
            }
            this.useSites = USE_SITES_REPLACED_BY_REFERENCES;
            this.usedTypes = USED_TYPES_REPLACED_BY_REFERENCES;
            this.rawUseSites = null;
            this.rawUsedTypes = null;
        }
    }

    @Override
    public int compareTo(@Nonnull JavaElement o) {
        if (!o.getClass().equals(TypeElement.class)) {
            return JavaElementFactory.compareByType(this, o);
        }
        return this.binaryName.compareTo(((TypeElement)o).binaryName);
    }

    @Override
    protected String createFullHumanReadableString() {
        Object rep = this.getModelRepresentation();
        return this.getHumanReadableElementType() + " " + (rep == null ? this.canonicalName : Util.toHumanReadableString(rep));
    }

    @Override
    protected String createComparableSignature() {
        return null;
    }

    @Override
    public TypeElement clone() {
        return (TypeElement)super.clone();
    }

    private JavaModelElement getModel(Element element, final TypeElement owner, final int indexInParent) {
        return element.accept(new SimpleElementVisitor8<JavaModelElement, Void>(){

            @Override
            public JavaModelElement visitVariable(VariableElement e, Void ignored) {
                if (e.getEnclosingElement() instanceof javax.lang.model.element.TypeElement) {
                    TypeElement type = this.findModelType(e.getEnclosingElement());
                    if (type == null) {
                        return null;
                    }
                    return type.lookupChildElement(FieldElement.class, FieldElement.createComparableSignature(e));
                }
                if (e.getEnclosingElement() instanceof ExecutableElement) {
                    Element methodEl = e.getEnclosingElement();
                    TypeElement type = this.findModelType(methodEl.getEnclosingElement());
                    if (type == null) {
                        return null;
                    }
                    MethodElement method = type.lookupChildElement(MethodElement.class, MethodElement.createComparableSignature((ExecutableElement)methodEl, methodEl.asType()));
                    return method == null ? null : (JavaModelElement)method.stream(MethodParameterElement.class, false).skip(indexInParent).findFirst().orElse(null);
                }
                return null;
            }

            @Override
            public JavaModelElement visitType(javax.lang.model.element.TypeElement e, Void ignored) {
                return this.findModelType(e);
            }

            @Override
            public JavaModelElement visitExecutable(ExecutableElement e, Void ignored) {
                TypeElement type = this.findModelType(e.getEnclosingElement());
                if (type == null) {
                    return null;
                }
                return type.lookupChildElement(MethodElement.class, MethodElement.createComparableSignature(e, e.asType()));
            }

            private TypeElement findModelType(Element enclosingElement) {
                if (owner == null) {
                    return TypeElement.this.environment.getTypeMap().get(enclosingElement);
                }
                return owner;
            }
        }, null);
    }
}

