/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.progress;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.util.Supplier;
import org.revapi.classif.StructuralMatcher;
import org.revapi.classif.TestResult;
import org.revapi.classif.progress.MatchingProgress;
import org.revapi.classif.progress.StatementMatch;
import org.revapi.classif.progress.WalkInstruction;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.util.LogUtil;
import org.revapi.classif.util.execution.Node;

final class MultiMatchingProgress<M>
extends MatchingProgress<M> {
    private static final Logger LOG = LogManager.getLogger(MultiMatchingProgress.class);
    private final List<Node<StatementMatch<M>>> roots;
    private final Deque<WalkContext<M>> statementStack = new ArrayDeque<WalkContext<M>>();
    private final StructuralMatcher.Configuration config;
    private final Set<WalkContext<M>> undecided;
    private final List<Node<StatementMatch<M>>> returningStatements;
    private final Map<String, Node<StatementMatch<M>>> definingStatements;

    MultiMatchingProgress(StructuralMatcher.Configuration configuration, List<Node<StatementMatch<M>>> statements) {
        this.config = configuration;
        this.roots = new ArrayList<Node<StatementMatch<M>>>();
        this.returningStatements = new ArrayList<Node<StatementMatch<M>>>();
        this.definingStatements = new HashMap<String, Node<StatementMatch<M>>>();
        statements.forEach(s -> {
            String var;
            if (s.getParent() == null) {
                this.roots.add((Node<StatementMatch<M>>)s);
            }
            if (((StatementMatch)s.getObject()).getContext().isReturn()) {
                this.returningStatements.add((Node<StatementMatch<M>>)s);
            }
            if ((var = ((StatementMatch)s.getObject()).getContext().getDefinedVariable()) != null) {
                this.definingStatements.put(var, (Node<StatementMatch<M>>)s);
            }
        });
        this.undecided = Collections.newSetFromMap(new IdentityHashMap());
    }

    @Override
    public WalkInstruction start(M model) {
        EntryMessage methodTrace = LOG.traceEntry(LogUtil.traceParams(LOG, "this", (Object)this, "model", model));
        WalkContext<M> parentCtx = this.statementStack.isEmpty() ? null : Objects.requireNonNull(this.statementStack.peek());
        Collection<Node<StatementMatch<M>>> currentStatements = parentCtx == null ? this.roots : parentCtx.nextStatements;
        ArrayList<Object> nextStatements = new ArrayList<Object>();
        boolean mustHaveChildren = true;
        TestResult res = TestResult.NOT_PASSED;
        for (Node<StatementMatch<M>> sm : currentStatements) {
            TestResult sr = sm.getObject().independentTest(model);
            if (sm.getObject().getContext().isReturn()) {
                res = res.or(sr);
            }
            if (!sm.out().isEmpty() || !sm.in().isEmpty()) {
                res = TestResult.DEFERRED;
            }
            nextStatements.addAll(sm.getChildren());
            mustHaveChildren = mustHaveChildren && !sm.getChildren().isEmpty();
        }
        if (!this.config.isStrictHierarchy()) {
            nextStatements.addAll(this.roots);
        }
        boolean descend = !this.config.isStrictHierarchy() || !nextStatements.isEmpty();
        this.statementStack.push(new WalkContext(parentCtx, model, res, mustHaveChildren, nextStatements));
        return LOG.traceExit(methodTrace, WalkInstruction.of(descend, res));
    }

    @Override
    public TestResult finish(M model) {
        EntryMessage methodTrace = LOG.traceEntry(LogUtil.traceParams(LOG, "this", (Object)this, "model", model));
        if (this.statementStack.isEmpty()) {
            throw LOG.traceExit(methodTrace, new IllegalStateException("Unbalanced start/finish calls."));
        }
        WalkContext<M> ctx = this.statementStack.pop();
        if (ctx.model != model) {
            throw LOG.traceExit(methodTrace, new IllegalStateException("Unbalanced start/finish calls."));
        }
        if (ctx.mustHaveChildren && !ctx.childrenEncountered) {
            ctx.finishResult = TestResult.NOT_PASSED;
        }
        if (ctx.finishResult == TestResult.NOT_PASSED) {
            LOG.trace("start of model {} didn't pass, so bailing out quickly.", (Object)model);
            return LOG.traceExit(methodTrace, TestResult.NOT_PASSED);
        }
        if (ctx.parent != null) {
            ctx.parent.finishResult = ctx.parent.finishResult.and(ctx.finishResult);
            ctx.parent.childrenEncountered = true;
        }
        if (ctx.finishResult == TestResult.DEFERRED) {
            this.undecided.add(ctx);
        }
        return ctx.finishResult;
    }

    @Override
    public Map<M, TestResult> finish() {
        EntryMessage methodTrace = LOG.traceEntry(LogUtil.traceParams(LOG, "this", (Object)this));
        if (this.undecided.isEmpty()) {
            return LOG.traceExit(methodTrace, Collections.emptyMap());
        }
        ArrayList<String> vars = new ArrayList<String>(this.definingStatements.keySet());
        List candidates = this.definingStatements.values().stream().map(n -> ((StatementMatch)n.getObject()).getCandidates()).map(c -> c.isEmpty() ? Collections.singleton(null) : c).collect(Collectors.toList());
        Map ret = this.undecided.stream().map(wc -> wc.model).collect(Collectors.toMap(Function.identity(), model -> {
            for (Node<StatementMatch<M>> st : this.returningStatements) {
                Iterator combinations = this.combinations(candidates);
                while (combinations.hasNext()) {
                    List combination = combinations.next();
                    HashMap binding = new HashMap(vars.size());
                    for (int i = 0; i < vars.size(); ++i) {
                        binding.put(vars.get(i), combination.get(i));
                    }
                    StatementMatch<M> match = st.getObject();
                    TestResult combinationResult = this.testBinding(st, model, binding, new IdentityHashMap<Node<StatementMatch<M>>, Map<M, TestResult>>());
                    if (combinationResult != TestResult.PASSED) continue;
                    return TestResult.PASSED;
                }
            }
            return TestResult.NOT_PASSED;
        }));
        return LOG.traceExit(methodTrace, ret);
    }

    private TestResult testBinding(Node<StatementMatch<M>> statementNode, M model, Map<String, M> binding, Map<Node<StatementMatch<M>>, Map<M, TestResult>> cache) {
        EntryMessage methodTrace = LOG.traceEntry(LogUtil.traceParams(LOG, "this", (Object)this, "statementNode", statementNode, "model", model, "binding", binding));
        TestResult cached = (TestResult)((Object)cache.computeIfAbsent(statementNode, __ -> new HashMap()).get(model));
        if (cached != null) {
            LOG.trace("Found cached result {} for {}", (Object)cached, (Object)statementNode);
            return LOG.traceExit(methodTrace, cached);
        }
        if (cache.get(statementNode).containsKey(model)) {
            LOG.trace("Evaluation loop detected on {}", (Object)statementNode);
            return LOG.traceExit(methodTrace, TestResult.PASSED);
        }
        cache.get(statementNode).put(model, null);
        StatementMatch<M> match = statementNode.getObject();
        TestResult ret = match.test(model, match.getContext().require(binding).getMatchContext()).and(() -> {
            EntryMessage trace = LOG.traceEntry("Matching children", new Supplier[0]);
            if (statementNode.getChildren().isEmpty()) {
                LOG.trace("No children on statement {}", (Object)statementNode);
                return LOG.traceExit(trace, TestResult.PASSED);
            }
            for (Node child : statementNode.getChildren()) {
                StatementMatch childSt = (StatementMatch)child.getObject();
                boolean somePassed = false;
                for (Object candidate : childSt.getCandidates()) {
                    MatchContext ctx = childSt.getContext().require(binding).getMatchContext();
                    Element parent = ctx.getModelInspector().toElement(candidate).getEnclosingElement();
                    if (parent == null || !model.equals(ctx.getModelInspector().fromElement(parent)) || this.testBinding(child, candidate, binding, cache) != TestResult.PASSED) continue;
                    somePassed = true;
                    break;
                }
                if (somePassed) continue;
                LOG.trace("No candidate on child {} passes with binding {}", (Object)child, (Object)binding);
                return LOG.traceExit(trace, TestResult.NOT_PASSED);
            }
            return LOG.traceExit(trace, TestResult.PASSED);
        }).and(() -> {
            EntryMessage trace = LOG.traceEntry("Matching dependencies", new Supplier[0]);
            if (statementNode.in().isEmpty()) {
                LOG.trace("No dependencies found on {}", (Object)statementNode);
                return LOG.traceExit(trace, TestResult.PASSED);
            }
            TestResult result = this.requireDependencies(model, statementNode, binding, cache);
            return LOG.traceExit(trace, result);
        }).and(() -> {
            EntryMessage trace = LOG.traceEntry("Matching dependents", new Supplier[0]);
            if (statementNode.out().isEmpty()) {
                LOG.trace("No dependents on statement {}", (Object)statementNode);
                return LOG.traceExit(trace, TestResult.PASSED);
            }
            String var = match.getContext().getDefinedVariable();
            if (model != binding.get(var)) {
                LOG.trace("Current model {} is not bound as {} on the current statement {}. Dependents cannot pass.", (Object)model, (Object)var, (Object)statementNode);
                return LOG.traceExit(trace, TestResult.NOT_PASSED);
            }
            TestResult result = TestResult.PASSED;
            for (Node<StatementMatch<M>> node : statementNode.out()) {
                StatementMatch depSt = (StatementMatch)node.getObject();
                boolean someCandidatePasses = false;
                for (Object depCandidate : depSt.getCandidates()) {
                    if (this.testBinding(node, depCandidate, binding, cache) != TestResult.PASSED) continue;
                    someCandidatePasses = true;
                    break;
                }
                if (someCandidatePasses) continue;
                LOG.trace("No candidate match of {} matches with binding {}.", (Object)node, (Object)binding);
                result = TestResult.NOT_PASSED;
                break;
            }
            return LOG.traceExit(trace, result);
        });
        cache.get(statementNode).put(model, ret);
        return LOG.traceExit(methodTrace, ret);
    }

    private TestResult requireDependencies(M model, Node<StatementMatch<M>> statementNode, Map<String, M> binding, Map<Node<StatementMatch<M>>, Map<M, TestResult>> cache) {
        HashMap<String, TestResult> results = new HashMap<String, TestResult>();
        for (Node<StatementMatch<M>> dep : statementNode.in()) {
            String var = dep.getObject().getContext().getDefinedVariable();
            if (dep.getObject().getCandidates().contains(binding.get(var))) {
                results.put(var, this.testBinding(dep, binding.get(var), binding, cache));
                continue;
            }
            results.put(var, TestResult.NOT_PASSED);
        }
        return statementNode.getObject().test(model, statementNode.getObject().getContext().withResults(results).getMatchContext());
    }

    @Override
    public void reset() {
        this.statementStack.clear();
        this.undecided.clear();
        this.roots.forEach(this::resetStatement);
    }

    private void resetStatement(Node<StatementMatch<M>> st) {
        st.getObject().reset();
        for (Node child : st.getChildren()) {
            this.resetStatement(child);
        }
    }

    private <T> Iterator<List<T>> combinations(final Collection<? extends Collection<T>> source) {
        return new Iterator<List<T>>(){
            final List<Collection<T>> sources;
            final List<Iterator<T>> current;
            List<T> last;
            {
                this.sources = new ArrayList(source);
                this.current = source.stream().map(Collection::iterator).collect(Collectors.toList());
                this.last = null;
            }

            @Override
            public boolean hasNext() {
                for (Iterator it : this.current) {
                    if (!it.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public List<T> next() {
                if (this.last == null) {
                    return this.first();
                }
                for (int i = 0; i < this.last.size(); ++i) {
                    Iterator it = this.current.get(i);
                    if (it.hasNext()) {
                        this.last.set(i, it.next());
                        return this.last;
                    }
                    it = this.sources.get(i).iterator();
                    this.current.set(i, it);
                    this.last.set(i, it.next());
                }
                throw new NoSuchElementException();
            }

            private List<T> first() {
                if (this.last == null) {
                    this.last = this.current.stream().map(Iterator::next).collect(Collectors.toCollection(ArrayList::new));
                }
                return this.last;
            }
        };
    }

    private static class WalkContext<M> {
        final WalkContext<M> parent;
        final M model;
        final TestResult startResult;
        TestResult finishResult;
        final boolean mustHaveChildren;
        boolean childrenEncountered;
        final Collection<Node<StatementMatch<M>>> nextStatements;

        private WalkContext(WalkContext<M> parent, M model, TestResult startResult, boolean shouldHaveChildren, Collection<Node<StatementMatch<M>>> nextStatements) {
            this.parent = parent;
            this.model = model;
            this.startResult = startResult;
            this.nextStatements = nextStatements;
            this.mustHaveChildren = shouldHaveChildren;
            this.finishResult = startResult;
        }
    }
}

