/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.statement;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.NameMatch;
import org.revapi.classif.match.declaration.AnnotationsMatch;
import org.revapi.classif.match.declaration.ModifiersMatch;
import org.revapi.classif.match.declaration.UsesMatch;
import org.revapi.classif.match.instance.TypeReferenceMatch;
import org.revapi.classif.progress.StatementMatch;
import org.revapi.classif.progress.context.MatchContext;
import org.revapi.classif.statement.AbstractStatement;

public final class FieldStatement
extends AbstractStatement {
    private final NameMatch name;
    private final TypeReferenceMatch fieldType;
    private final TypeReferenceMatch declaringType;
    private final UsesMatch fieldConstraints;

    public FieldStatement(String definedVariable, List<String> referencedVariables, AnnotationsMatch annotations, ModifiersMatch modifiers, boolean isMatch, boolean negation, NameMatch name, TypeReferenceMatch fieldType, TypeReferenceMatch declaringType, UsesMatch fieldConstraints) {
        super(definedVariable, referencedVariables, isMatch, annotations, modifiers, negation);
        this.name = name;
        this.fieldType = fieldType;
        this.declaringType = declaringType;
        this.fieldConstraints = fieldConstraints;
    }

    @Override
    public <M> StatementMatch<M> createMatch() {
        return new StatementMatch<M>(){

            @Override
            public TestResult testVariable(M var, MatchContext<M> ctx) {
                Element element = ctx.getModelInspector().toElement(var);
                TypeMirror type = ctx.getModelInspector().toMirror(var);
                TestResult res = TestResult.fromBoolean(FieldStatement.this.name.matches(element.getSimpleName().toString()));
                if (FieldStatement.this.fieldType != null) {
                    res = res.and(FieldStatement.this.fieldType.testInstance(type, ctx));
                }
                if (FieldStatement.this.declaringType != null) {
                    res = res.and(FieldStatement.this.declaringType.testInstance(element.getEnclosingElement().asType(), ctx));
                }
                if (FieldStatement.this.fieldConstraints != null) {
                    res = res.and(FieldStatement.this.fieldConstraints.testDeclaration(element, type, ctx));
                }
                return FieldStatement.this.negation ? res.negate() : res;
            }

            @Override
            public String toString() {
                StringBuilder bld = new StringBuilder(FieldStatement.this.toStringPrefix());
                if (FieldStatement.this.fieldType != null) {
                    bld.append(FieldStatement.this.fieldType.toString());
                }
                if (FieldStatement.this.declaringType != null) {
                    if (bld.length() > 0) {
                        bld.append(" ");
                    }
                    bld.append(FieldStatement.this.declaringType.toString());
                    bld.append("::");
                }
                if (FieldStatement.this.isMatch()) {
                    if (bld.length() > 0) {
                        bld.append(" ");
                    }
                    bld.append("^");
                }
                FieldStatement.this.insertVariable(bld);
                if (FieldStatement.this.negation) {
                    bld.append("!");
                }
                bld.append(FieldStatement.this.name.toString());
                if (FieldStatement.this.fieldConstraints != null) {
                    bld.append(FieldStatement.this.fieldConstraints.toString());
                }
                return bld.toString();
            }
        };
    }
}

