/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.revapi.API;
import org.revapi.Archive;
import org.revapi.java.compilation.MissingTypeAwareDelegatingElements;
import org.revapi.java.compilation.MissingTypeAwareDelegatingTypes;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.model.JavaElementForest;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.TypeEnvironment;

public final class ProbingEnvironment
implements TypeEnvironment {
    private final API api;
    private volatile ProcessingEnvironment processingEnvironment;
    private final CountDownLatch compilationProgressLatch = new CountDownLatch(1);
    private final CountDownLatch compilationEnvironmentTeardownLatch = new CountDownLatch(1);
    private final JavaElementForest tree;
    private Map<javax.lang.model.element.TypeElement, TypeElement> typeMap;
    private Map<javax.lang.model.element.TypeElement, Set<javax.lang.model.element.TypeElement>> derivedTypes = new HashMap<javax.lang.model.element.TypeElement, Set<javax.lang.model.element.TypeElement>>();
    private Map<javax.lang.model.element.TypeElement, Set<javax.lang.model.element.TypeElement>> superTypes = new HashMap<javax.lang.model.element.TypeElement, Set<javax.lang.model.element.TypeElement>>();

    public ProbingEnvironment(API api) {
        this.api = api;
        this.tree = new JavaElementForest(api);
    }

    public API getApi() {
        return this.api;
    }

    public CountDownLatch getCompilationTeardownLatch() {
        return this.compilationEnvironmentTeardownLatch;
    }

    public CountDownLatch getCompilationProgressLatch() {
        return this.compilationProgressLatch;
    }

    public JavaElementForest getTree() {
        return this.tree;
    }

    public void setProcessingEnvironment(ProcessingEnvironment env) {
        this.processingEnvironment = env;
    }

    public boolean hasProcessingEnvironment() {
        return this.processingEnvironment != null;
    }

    public boolean isScanningComplete() {
        return this.typeMap != null;
    }

    @Override
    @Nonnull
    public Elements getElementUtils() {
        if (this.processingEnvironment == null) {
            throw new IllegalStateException("Types instance not yet available. It is too early to call this method. Wait until after the archives are visited and the API model constructed.");
        }
        return new MissingTypeAwareDelegatingElements(this.processingEnvironment.getElementUtils());
    }

    @Override
    @Nonnull
    public Types getTypeUtils() {
        if (this.processingEnvironment == null) {
            throw new IllegalStateException("Types instance not yet available. It is too early to call this method. Wait until after the archives are visited and the API model constructed.");
        }
        return new MissingTypeAwareDelegatingTypes(this.processingEnvironment.getTypeUtils());
    }

    void setTypeMap(Map<javax.lang.model.element.TypeElement, TypeElement> typeMap) {
        this.typeMap = Collections.unmodifiableMap(typeMap);
    }

    public Map<javax.lang.model.element.TypeElement, TypeElement> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public JavaTypeElement getModelElement(javax.lang.model.element.TypeElement javaType) {
        JavaTypeElement ret;
        JavaTypeElement javaTypeElement = ret = this.typeMap == null ? null : (JavaTypeElement)this.typeMap.get(javaType);
        if (ret != null) {
            return ret;
        }
        return (JavaTypeElement)((Object)JavaElementFactory.elementFor(javaType, javaType.asType(), this, new Archive(){

            @Nonnull
            public String getName() {
                return "<unknown>";
            }

            @Nonnull
            public InputStream openStream() throws IOException {
                throw new IOException("Not supported.");
            }
        }));
    }

    public Set<javax.lang.model.element.TypeElement> getDerivedTypes(javax.lang.model.element.TypeElement superType) {
        return this.derivedTypes.getOrDefault(superType, Collections.emptySet());
    }

    void setSuperTypes(javax.lang.model.element.TypeElement derivedType, Collection<javax.lang.model.element.TypeElement> superTypes) {
        this.superTypes.computeIfAbsent(derivedType, x -> new HashSet(superTypes));
        superTypes.forEach(t -> this.derivedTypes.computeIfAbsent((javax.lang.model.element.TypeElement)t, x -> new HashSet()).add(derivedType));
        for (javax.lang.model.element.TypeElement superType : superTypes) {
            Set<javax.lang.model.element.TypeElement> grandTypes = this.superTypes.get(superType);
            if (grandTypes == null) continue;
            this.setSuperTypes(derivedType, grandTypes);
        }
    }
}

