/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.annotations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import org.revapi.Difference;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class AttributeValueChanged
extends CheckBase {
    @Override
    protected List<Difference> doVisitAnnotation(AnnotationMirror oldAnnotation, AnnotationMirror newAnnotation) {
        String name;
        if (oldAnnotation == null || newAnnotation == null) {
            return null;
        }
        ArrayList<Difference> result = new ArrayList<Difference>();
        Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> oldAttrs = Util.keyAnnotationAttributesByName(oldAnnotation.getElementValues());
        Map<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> newAttrs = Util.keyAnnotationAttributesByName(newAnnotation.getElementValues());
        for (Map.Entry<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> oldE : oldAttrs.entrySet()) {
            name = oldE.getKey();
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> oldValue = oldE.getValue();
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> newValue = newAttrs.get(name);
            if (newValue == null) {
                result.add(this.createDifference(Code.ANNOTATION_ATTRIBUTE_REMOVED, (Object[])new String[]{name, Util.toHumanReadableString(oldAnnotation.getAnnotationType())}, new Object[]{oldValue.getKey(), oldAnnotation}));
            } else if (!Util.isEqual(oldValue.getValue(), newValue.getValue())) {
                result.add(this.createDifference(Code.ANNOTATION_ATTRIBUTE_VALUE_CHANGED, (Object[])new String[]{name, Util.toHumanReadableString(oldAnnotation.getAnnotationType()), Util.toHumanReadableString(oldValue.getValue()), Util.toHumanReadableString(newValue.getValue())}, new Object[]{oldValue.getKey(), oldAnnotation, oldValue.getValue(), newValue.getValue()}));
            }
            newAttrs.remove(name);
        }
        for (Map.Entry<String, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> newE : newAttrs.entrySet()) {
            name = newE.getKey();
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> newValue = newE.getValue();
            Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> oldValue = oldAttrs.get(name);
            if (oldValue != null) continue;
            result.add(this.createDifference(Code.ANNOTATION_ATTRIBUTE_ADDED, (Object[])new String[]{name, Util.toHumanReadableString(newAnnotation.getAnnotationType())}, new Object[]{newValue.getKey(), newAnnotation}));
        }
        return result.isEmpty() ? null : result;
    }
}

