/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.spi;

import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.revapi.CompatibilityType;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;

public enum Code {
    MISSING_IN_OLD_API("java.missing.oldClass", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null),
    MISSING_IN_NEW_API("java.missing.newClass", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null),
    ELEMENT_NO_LONGER_DEPRECATED("java.element.noLongerDeprecated", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    ELEMENT_NOW_DEPRECATED("java.element.nowDeprecated", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    CLASS_VISIBILITY_INCREASED("java.class.visibilityIncreased", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    CLASS_VISIBILITY_REDUCED("java.class.visibilityReduced", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    CLASS_KIND_CHANGED("java.class.kindChanged", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    CLASS_NO_LONGER_FINAL("java.class.noLongerFinal", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    CLASS_NOW_FINAL("java.class.nowFinal", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    CLASS_NO_LONGER_ABSTRACT("java.class.noLongerAbstract", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    CLASS_NOW_ABSTRACT("java.class.nowAbstract", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    CLASS_ADDED("java.class.added", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    CLASS_REMOVED("java.class.removed", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    CLASS_NO_LONGER_IMPLEMENTS_INTERFACE("java.class.noLongerImplementsInterface", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    CLASS_NOW_IMPLEMENTS_INTERFACE("java.class.nowImplementsInterface", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    CLASS_FINAL_CLASS_INHERITS_FROM_NEW_CLASS("java.class.finalClassInheritsFromNewClass", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    CLASS_NON_FINAL_CLASS_INHERITS_FROM_NEW_CLASS("java.class.nonFinalClassInheritsFromNewClass", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null),
    CLASS_NOW_CHECKED_EXCEPTION("java.class.nowCheckedException", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null),
    CLASS_NO_LONGER_INHERITS_FROM_CLASS("java.class.noLongerInheritsFromClass", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    CLASS_NON_PUBLIC_PART_OF_API("java.class.nonPublicPartOfAPI", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING),
    CLASS_SUPER_TYPE_TYPE_PARAMETERS_CHANGED("java.class.superTypeTypeParametersChanged", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null),
    CLASS_EXTERNAL_CLASS_EXPOSED_IN_API("java.class.externalClassExposedInAPI", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    CLASS_EXTERNAL_CLASS_NO_LONGER_EXPOSED_IN_API("java.class.externalClassNoLongerExposedInAPI", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    ANNOTATION_ADDED("java.annotation.added", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    ANNOTATION_REMOVED("java.annotation.removed", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    ANNOTATION_ATTRIBUTE_VALUE_CHANGED("java.annotation.attributeValueChanged", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    ANNOTATION_ATTRIBUTE_ADDED("java.annotation.attributeAdded", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    ANNOTATION_ATTRIBUTE_REMOVED("java.annotation.attributeRemoved", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    ANNOTATION_NO_LONGER_INHERITED("java.annotation.noLongerInherited", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    ANNOTATION_NOW_INHERITED("java.annotation.nowInherited", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    ANNOTATION_NO_LONGER_PRESENT("java.annotation.noLongerPresent", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    FIELD_ADDED_STATIC_FIELD("java.field.addedStaticField", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    FIELD_ADDED("java.field.added", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    FIELD_REMOVED("java.field.removed", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    FIELD_CONSTANT_REMOVED("java.field.removedWithConstant", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    FIELD_CONSTANT_VALUE_CHANGED("java.field.constantValueChanged", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING),
    FIELD_NOW_CONSTANT("java.field.nowConstant", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    FIELD_NO_LONGER_CONSTANT("java.field.noLongerConstant", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    FIELD_NOW_FINAL("java.field.nowFinal", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    FIELD_NO_LONGER_FINAL("java.field.noLongerFinal", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    FIELD_NO_LONGER_STATIC("java.field.noLongerStatic", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    FIELD_NOW_STATIC("java.field.nowStatic", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING, null),
    FIELD_TYPE_CHANGED("java.field.typeChanged", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    FIELD_SERIAL_VERSION_UID_UNCHANGED("java.field.serialVersionUIDUnchanged", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    FIELD_VISIBILITY_INCREASED("java.field.visibilityIncreased", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    FIELD_VISIBILITY_REDUCED("java.field.visibilityReduced", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    FIELD_ENUM_CONSTANT_ORDER_CHANGED("java.field.enumConstantOrderChanged", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    METHOD_DEFAULT_VALUE_ADDED("java.method.defaultValueAdded", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_DEFAULT_VALUE_CHANGED("java.method.defaultValueChanged", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    METHOD_DEFAULT_VALUE_REMOVED("java.method.defaultValueRemoved", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING),
    METHOD_ADDED_TO_INTERFACE("java.method.addedToInterface", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    METHOD_DEFAULT_METHOD_ADDED_TO_INTERFACE("java.method.defaultMethodAddedToInterface", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_ATTRIBUTE_WITH_NO_DEFAULT_ADDED_TO_ANNOTATION_TYPE("java.method.attributeWithNoDefaultAddedToAnnotationType", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING),
    METHOD_ATTRIBUTE_WITH_DEFAULT_ADDED_TO_ANNOTATION_TYPE("java.method.attributeWithDefaultAddedToAnnotationType", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_ABSTRACT_METHOD_ADDED("java.method.abstractMethodAdded", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_ADDED("java.method.added", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_FINAL_METHOD_ADDED_TO_NON_FINAL_CLASS("java.method.finalMethodAddedToNonFinalClass", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null),
    METHOD_REMOVED("java.method.removed", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_OVERRIDING_METHOD_REMOVED("java.method.overridingMethodRemoved", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_REPLACED_BY_ABSTRACT_METHOD_IN_SUPERCLASS("java.method.replacedByAbstractMethodInSuperClass", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_NON_FINAL_METHOD_REPLACED_BY_FINAL_IN_SUPERCLASS("java.method.nonFinalReplacedByFinalInSuperclass", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null),
    METHOD_ATTRIBUTE_REMOVED_FROM_ANNOTATION_TYPE("java.method.attributeRemovedFromAnnotationType", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_NO_LONGER_FINAL("java.method.noLongerFinal", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_NOW_FINAL("java.method.nowFinal", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_VISIBILITY_INCREASED("java.method.visibilityIncreased", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_VISIBILITY_REDUCED("java.method.visibilityReduced", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_RETURN_TYPE_CHANGED("java.method.returnTypeChanged", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_RETURN_TYPE_TYPE_PARAMETERS_CHANGED("java.method.returnTypeTypeParametersChanged", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_NUMBER_OF_PARAMETERS_CHANGED("java.method.numberOfParametersChanged", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_PARAMETER_TYPE_CHANGED("java.method.parameterTypeChanged", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_NO_LONGER_STATIC("java.method.noLongerStatic", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_NOW_STATIC("java.method.nowStatic", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_CHECKED_EXCEPTION_ADDED("java.method.exception.checkedAdded", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_RUNTIME_EXCEPTION_ADDED("java.method.exception.runtimeAdded", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_CHECKED_EXCEPTION_REMOVED("java.method.exception.checkedRemoved", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_RUNTIME_EXCEPTION_REMOVED("java.method.exception.runtimeRemoved", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    METHOD_NO_LONGER_DEFAULT("java.method.noLongerDefault", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null),
    METHOD_NOW_DEFAULT("java.method.nowDefault", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null),
    GENERICS_ELEMENT_NOW_PARAMETERIZED("java.generics.elementNowParameterized", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING),
    GENERICS_FORMAL_TYPE_PARAMETER_ADDED("java.generics.formalTypeParameterAdded", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null),
    GENERICS_FORMAL_TYPE_PARAMETER_REMOVED("java.generics.formalTypeParameterRemoved", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null),
    GENERICS_FORMAL_TYPE_PARAMETER_CHANGED("java.generics.formalTypeParameterChanged", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null);

    private final String code;
    private final EnumMap<CompatibilityType, DifferenceSeverity> classification;
    private static WeakHashMap<Locale, WeakReference<Messages>> messagesCache;

    private Code(String code, DifferenceSeverity sourceSeverity, DifferenceSeverity binarySeverity, DifferenceSeverity semanticSeverity) {
        this.code = code;
        this.classification = new EnumMap(CompatibilityType.class);
        this.addClassification(CompatibilityType.SOURCE, sourceSeverity);
        this.addClassification(CompatibilityType.BINARY, binarySeverity);
        this.addClassification(CompatibilityType.SEMANTIC, semanticSeverity);
    }

    public static Code fromCode(String code) {
        for (Code c : Code.values()) {
            if (!c.code.equals(code)) continue;
            return c;
        }
        return null;
    }

    public String code() {
        return this.code;
    }

    public Difference createDifference(@Nonnull Locale locale) {
        Message message = Code.getMessages(locale).get(this.code);
        Difference.Builder bld = (Difference.Builder)((Difference.Builder)((Difference.Builder)Difference.builder().withCode(this.code)).withName(message.name)).withDescription(message.description);
        for (Map.Entry<CompatibilityType, DifferenceSeverity> e : this.classification.entrySet()) {
            bld.addClassification(e.getKey(), e.getValue());
        }
        return bld.build();
    }

    public Difference createDifference(@Nonnull Locale locale, Object[] params, Object ... attachments) {
        Message message = Code.getMessages(locale).get(this.code);
        String description = MessageFormat.format(message.description, params);
        Difference.Builder bld = (Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)Difference.builder().withCode(this.code)).withName(message.name)).withDescription(description)).addAttachments(attachments);
        for (Map.Entry<CompatibilityType, DifferenceSeverity> e : this.classification.entrySet()) {
            bld.addClassification(e.getKey(), e.getValue());
        }
        return bld.build();
    }

    private static synchronized Messages getMessages(Locale locale) {
        WeakReference<Messages> messageRef = messagesCache.get(locale);
        if (messageRef == null || messageRef.get() == null) {
            messageRef = new WeakReference<Messages>(new Messages(locale));
            messagesCache.put(locale, messageRef);
        }
        return (Messages)messageRef.get();
    }

    private void addClassification(CompatibilityType compatibilityType, DifferenceSeverity severity) {
        if (severity != null) {
            this.classification.put(compatibilityType, severity);
        }
    }

    static {
        messagesCache = new WeakHashMap();
    }

    private static class Messages {
        private final ResourceBundle names;
        private final ResourceBundle descriptions;

        public Messages(Locale locale) {
            this.descriptions = ResourceBundle.getBundle("org.revapi.java.checks.descriptions", locale);
            this.names = ResourceBundle.getBundle("org.revapi.java.checks.names", locale);
        }

        Message get(String key) {
            String name = this.names.getString(key);
            String description = this.descriptions.getString(key);
            return new Message(name, description);
        }
    }

    private static class Message {
        final String name;
        final String description;

        private Message(String name, String description) {
            this.description = description;
            this.name = name;
        }
    }
}

