/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class ReturnTypeChanged
extends CheckBase {
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD);
    }

    protected void doVisitMethod(@Nullable ExecutableElement oldMethod, @Nullable ExecutableElement newMethod) {
        String newRet;
        if (oldMethod == null || newMethod == null || this.isBothPrivate(oldMethod, newMethod)) {
            return;
        }
        String oldRet = Util.toUniqueString((TypeMirror)oldMethod.getReturnType());
        if (!oldRet.equals(newRet = Util.toUniqueString((TypeMirror)newMethod.getReturnType()))) {
            this.pushActive(oldMethod, newMethod, new Object[0]);
        }
    }

    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return null;
        }
        TypeMirror oldReturnType = ((ExecutableElement)methods.oldElement).getReturnType();
        TypeMirror newReturnType = ((ExecutableElement)methods.newElement).getReturnType();
        TypeMirror erasedOldType = this.getOldTypeEnvironment().getTypeUtils().erasure(oldReturnType);
        TypeMirror erasedNewType = this.getNewTypeEnvironment().getTypeUtils().erasure(newReturnType);
        String oldR = Util.toUniqueString((TypeMirror)oldReturnType);
        String newR = Util.toUniqueString((TypeMirror)newReturnType);
        String oldER = Util.toUniqueString((TypeMirror)erasedOldType);
        String newER = Util.toUniqueString((TypeMirror)erasedNewType);
        Code code = null;
        if (!oldER.equals(newER)) {
            code = Code.METHOD_RETURN_TYPE_CHANGED;
        } else if (!oldR.equals(newR)) {
            code = Code.METHOD_RETURN_TYPE_TYPE_PARAMETERS_CHANGED;
        }
        String oldHR = Util.toHumanReadableString((AnnotatedConstruct)oldReturnType);
        String newHR = Util.toHumanReadableString((AnnotatedConstruct)newReturnType);
        return code == null ? null : Collections.singletonList(this.createDifference(code, new Object[]{oldHR, newHR}));
    }
}

