/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.revapi.Archive;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.compilation.RawUseSite;
import org.revapi.java.compilation.TypeTreeConstructor;
import org.revapi.java.model.MissingClassElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.UseSite;
import org.revapi.query.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClassTreeInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ClassTreeInitializer.class);
    private final ProbingEnvironment environment;
    private final AnalysisConfiguration.MissingClassReporting reporting;
    private final boolean ignoreMissingAnnotations;
    private final Set<File> bootstrapClasspath;
    private final boolean skipUseTracking;

    public ClassTreeInitializer(ProbingEnvironment environment, AnalysisConfiguration.MissingClassReporting missingClassReporting, boolean ignoreMissingAnnotations, boolean skipUseTracking, Set<File> bootstrapClasspath) {
        this.environment = environment;
        this.reporting = missingClassReporting;
        this.ignoreMissingAnnotations = ignoreMissingAnnotations;
        this.bootstrapClasspath = bootstrapClasspath;
        this.skipUseTracking = skipUseTracking;
    }

    public void initTree() throws IOException {
        TypeTreeConstructor.Results results;
        InitTreeContext context = new InitTreeContext(new TypeTreeConstructor(this.environment, this.bootstrapClasspath));
        long time = System.currentTimeMillis();
        for (Archive a : this.environment.getApi().getArchives()) {
            LOG.trace("Processing archive {}", (Object)a.getName());
            this.processArchive(a, context);
        }
        if (context.typeTreeConstructor.hasUnknownClasses() && this.environment.getApi().getSupplementaryArchives() != null) {
            context.processingSupplementaryArchives = true;
            for (Archive a : this.environment.getApi().getSupplementaryArchives()) {
                LOG.trace("Processing archive {}", (Object)a.getName());
                this.processArchive(a, context);
                if (context.typeTreeConstructor.hasUnknownClasses()) continue;
                break;
            }
        }
        if (!(results = context.typeTreeConstructor.construct()).getUnknownTypeBinaryNames().isEmpty()) {
            ArrayList<String> prettyNames = new ArrayList<String>(results.getUnknownTypeBinaryNames());
            Collections.sort(prettyNames);
            if (this.reporting == null || this.reporting == AnalysisConfiguration.MissingClassReporting.ERROR) {
                throw new IllegalStateException("The following classes that contribute to the public API of " + this.environment.getApi() + " could not be located: " + prettyNames);
            }
            switch (this.reporting) {
                case IGNORE: {
                    LOG.warn("The following classes that contribute to the public API of " + this.environment.getApi() + " could not be located: " + prettyNames);
                    break;
                }
                case REPORT: {
                    for (String binary : results.getUnknownTypeBinaryNames()) {
                        MissingClassElement t = new MissingClassElement(this.environment, binary, binary);
                        this.environment.getTree().getRootsUnsafe().add(t);
                    }
                    break;
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            time = System.currentTimeMillis() - time;
            final int[] num = new int[1];
            this.environment.getTree().searchUnsafe(JavaElement.class, true, new Filter<JavaElement>(){

                public boolean applies(@Nullable JavaElement element) {
                    num[0] = num[0] + 1;
                    return true;
                }

                public boolean shouldDescendInto(@Nullable Object element) {
                    return true;
                }
            }, null);
            LOG.trace("Tree init took " + time + "ms. The resulting tree has " + num[0] + " elements.");
            LOG.trace("Public API class tree in {} initialized to: {}", (Object)this.environment.getApi(), (Object)this.environment.getTree());
        }
    }

    private void processArchive(Archive a, InitTreeContext context) throws IOException {
        try (BufferedInputStream buf = new BufferedInputStream(a.openStream());){
            buf.mark(4);
            byte[] magic = new byte[4];
            int cnt = buf.read(magic);
            if (cnt < 4) {
                LOG.info("Unsupported type of data - neither a Java class file or a JAR file: " + a.getName());
                return;
            }
            if (magic[0] == 80 && magic[1] == 75 && magic[2] == 3 && magic[3] == 4) {
                buf.reset();
                this.processJarArchive(a, buf, context);
            } else if (magic[0] == 202 && magic[1] == 254 && magic[2] == 186 && magic[3] == 190) {
                buf.reset();
                try {
                    this.processClassBytes(a, buf, context);
                }
                catch (Exception e) {
                    LOG.error("Failed to process class '" + a.getName() + "'. This is a bug, please report it.", (Throwable)e);
                }
            } else {
                LOG.info("Unsupported type of data - neither a Java class file or a JAR file: " + a.getName());
            }
        }
    }

    private void processJarArchive(Archive a, InputStream openStream, InitTreeContext context) throws IOException {
        ZipInputStream jar = new ZipInputStream(openStream);
        ZipEntry entry = jar.getNextEntry();
        while (entry != null) {
            if (!entry.isDirectory() && entry.getName().toLowerCase().endsWith(".class")) {
                try {
                    this.processClassBytes(a, jar, context);
                }
                catch (Exception e) {
                    LOG.error("Failed to process class '" + entry.getName() + "' in archive '" + a.getName() + "'." + " This is a bug, please report it.", (Throwable)e);
                }
            }
            entry = jar.getNextEntry();
        }
    }

    private void processClassBytes(final Archive currentArchive, InputStream data, final InitTreeContext context) throws IOException {
        ClassReader classReader = new ClassReader(data);
        classReader.accept(new ClassVisitor(327680){
            private String visitedClassInternalName;
            private String visitedClassBinaryName;
            private String[] visitedClassOwners;
            private boolean isInnerClass;
            private int visitedInnerClassAccess;
            private TypeTreeConstructor.ClassProcessor classProcessor;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.visitedClassInternalName = name;
                this.visitedClassBinaryName = Type.getObjectType((String)name).getClassName();
                boolean visible = ClassTreeInitializer.isAccessible(access);
                boolean isPublicAPI = !context.processingSupplementaryArchives && visible;
                this.classProcessor = context.typeTreeConstructor.createApiClassProcessor(currentArchive, this.visitedClassBinaryName, isPublicAPI);
                this.reportUse(Type.getObjectType((String)superName), UseSite.Type.IS_INHERITED, RawUseSite.SiteType.CLASS, null, null, -1);
                for (String iface : interfaces) {
                    this.reportUse(Type.getObjectType((String)iface), UseSite.Type.IS_IMPLEMENTED, RawUseSite.SiteType.CLASS, null, null, -1);
                }
                if (name.indexOf(36) >= 0) {
                    this.visitedClassOwners = name.split("\\$");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("visit(): name={}, signature={}, access=0x{}", new Object[]{name, signature, Integer.toHexString(access)});
                }
            }

            public FieldVisitor visitField(int access, final String name, String desc, String signature, Object value) {
                if (ClassTreeInitializer.isAccessible(access)) {
                    this.reportUse(Type.getType((String)desc), UseSite.Type.HAS_TYPE, RawUseSite.SiteType.FIELD, name, desc, -1);
                    return new FieldVisitor(327680){

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            this.reportUse(Type.getType((String)desc), UseSite.Type.ANNOTATES, RawUseSite.SiteType.FIELD, name, desc, -1);
                            return null;
                        }
                    };
                }
                return null;
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                LOG.trace("Visiting inner class spec {} {}", (Object)innerName, (Object)outerName);
                boolean isThisClass = this.visitedClassInternalName.equals(name);
                if (isThisClass) {
                    this.visitedInnerClassAccess = access;
                }
                boolean bl = this.isInnerClass = this.isInnerClass || isThisClass;
                if (isThisClass || this.isTransitiveOwnerOfVisitedClass(name)) {
                    this.classProcessor.getInnerClassHierarchyConstructor().addName(outerName, innerName);
                }
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                this.reportUse(Type.getType((String)desc), UseSite.Type.ANNOTATES, RawUseSite.SiteType.CLASS, null, null, -1);
                return null;
            }

            public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
                LOG.trace("Visiting method {} {}", (Object)name, (Object)desc);
                if (ClassTreeInitializer.isAccessible(access)) {
                    int ai;
                    Type[] argumentTypes = Type.getArgumentTypes((String)desc);
                    this.reportUse(Type.getReturnType((String)desc), UseSite.Type.RETURN_TYPE, RawUseSite.SiteType.METHOD, name, desc, -1);
                    int n = ai = this.isInnerClass && "<init>".equals(name) && (this.visitedInnerClassAccess & 8) == 0 ? 1 : 0;
                    while (ai < argumentTypes.length) {
                        Type t = argumentTypes[ai];
                        this.reportUse(t, UseSite.Type.PARAMETER_TYPE, RawUseSite.SiteType.METHOD_PARAMETER, name, desc, ai++);
                    }
                    if (exceptions != null && exceptions.length > 0) {
                        for (String ex : exceptions) {
                            this.reportUse(Type.getObjectType((String)ex), UseSite.Type.IS_THROWN, RawUseSite.SiteType.METHOD, name, desc, -1);
                        }
                    }
                    return new MethodVisitor(327680){

                        public AnnotationVisitor visitAnnotation(String annotationDesc, boolean visible) {
                            this.reportUse(Type.getType((String)annotationDesc), UseSite.Type.ANNOTATES, RawUseSite.SiteType.METHOD, name, desc, -1);
                            return null;
                        }

                        public AnnotationVisitor visitParameterAnnotation(int parameter, String parameterDesc, boolean visible) {
                            this.reportUse(Type.getType((String)parameterDesc), UseSite.Type.ANNOTATES, RawUseSite.SiteType.METHOD_PARAMETER, name, desc, parameter);
                            return null;
                        }
                    };
                }
                return null;
            }

            public void visitEnd() {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Visited {}, isInner={}, onlyAdditional={}", new Object[]{this.visitedClassInternalName, this.isInnerClass, context.processingSupplementaryArchives});
                }
                this.classProcessor.commitClass();
            }

            private void reportUse(Type t, UseSite.Type useType, RawUseSite.SiteType siteType, String siteName, String siteDescriptor, int sitePosition) {
                if (ClassTreeInitializer.this.skipUseTracking) {
                    return;
                }
                if (t.getSort() < 9) {
                    return;
                }
                if (ClassTreeInitializer.this.ignoreMissingAnnotations && useType == UseSite.Type.ANNOTATES) {
                    return;
                }
                String binaryName = t.getClassName();
                RawUseSite useSite = new RawUseSite(useType, siteType, this.visitedClassBinaryName, siteName, siteDescriptor, sitePosition);
                switch (t.getSort()) {
                    case 10: {
                        this.classProcessor.addUse(binaryName, useSite);
                        break;
                    }
                    case 9: {
                        String desc = t.getDescriptor();
                        desc = desc.substring(desc.lastIndexOf(91) + 1);
                        this.reportUse(Type.getType((String)desc), useType, siteType, siteName, siteDescriptor, sitePosition);
                        break;
                    }
                    case 11: {
                        throw new AssertionError((Object)"A method type should not enter here.");
                    }
                }
            }

            private boolean isTransitiveOwnerOfVisitedClass(String owningClass) {
                if (this.visitedClassOwners == null) {
                    return false;
                }
                if (owningClass.length() > this.visitedClassInternalName.length()) {
                    return false;
                }
                int startIdx = 0;
                int dollarIdx = owningClass.indexOf(36);
                int ownerIdx = 0;
                while (dollarIdx >= 0 && ownerIdx < this.visitedClassOwners.length) {
                    String owner = owningClass.substring(startIdx, dollarIdx);
                    if (!this.visitedClassOwners[ownerIdx++].equals(owner)) {
                        return false;
                    }
                    startIdx = dollarIdx + 1;
                    dollarIdx = owningClass.indexOf(36, startIdx);
                }
                if (ownerIdx < this.visitedClassOwners.length) {
                    return this.visitedClassOwners[ownerIdx].equals(owningClass.substring(startIdx));
                }
                return dollarIdx == -1;
            }
        }, 1);
    }

    private static boolean isAccessible(int access) {
        return (access & 0x1000) == 0 && (access & 0x40) == 0 && ((access & 1) != 0 || (access & 4) != 0);
    }

    private static class InitTreeContext {
        boolean processingSupplementaryArchives;
        final TypeTreeConstructor typeTreeConstructor;

        private InitTreeContext(TypeTreeConstructor typeTreeConstructor) {
            this.typeTreeConstructor = typeTreeConstructor;
        }
    }
}

