/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class Removed
extends CheckBase {
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD);
    }

    protected void doVisitMethod(@Nullable ExecutableElement oldMethod, @Nullable ExecutableElement newMethod) {
        if (oldMethod != null && newMethod == null && this.isAccessible(oldMethod, this.getOldTypeEnvironment())) {
            this.pushActive(oldMethod, null, new Object[0]);
        }
    }

    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return null;
        }
        Difference difference = null;
        ExecutableElement oldMethod = (ExecutableElement)methods.oldElement;
        TypeElement type = (TypeElement)oldMethod.getEnclosingElement();
        boolean oldMethodAbstract = oldMethod.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean oldMethodFinal = oldMethod.getModifiers().contains((Object)Modifier.FINAL);
        String methodSignature = this.getMethodSignature(oldMethod.getSimpleName(), (ExecutableType)this.getOldTypeEnvironment().getTypeUtils().erasure(oldMethod.asType()));
        TypeElement newType = this.getNewTypeEnvironment().getElementUtils().getTypeElement(type.getQualifiedName());
        if (newType == null) {
            throw new IllegalStateException("Failed to find the type " + type.getQualifiedName() + " in the new version" + " of API even though a method from it has been detected as removed.");
        }
        List superClasses = Util.getAllSuperClasses((Types)this.getNewTypeEnvironment().getTypeUtils(), (TypeMirror)newType.asType());
        block0: for (TypeMirror superClass : superClasses) {
            Element superClassEl = ((DeclaredType)superClass).asElement();
            List<ExecutableElement> superMethods = ElementFilter.methodsIn(superClassEl.getEnclosedElements());
            for (ExecutableElement superMethod : superMethods) {
                String superMethodSignature = this.getMethodSignature(superMethod.getSimpleName(), (ExecutableType)this.getNewTypeEnvironment().getTypeUtils().erasure(superMethod.asType()));
                if (!superMethodSignature.equals(methodSignature)) continue;
                if (!oldMethodAbstract && superMethod.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    difference = this.createDifference(Code.METHOD_REPLACED_BY_ABSTRACT_METHOD_IN_SUPERCLASS, new String[]{Util.toHumanReadableString((AnnotatedConstruct)superClass)}, new Object[]{superMethod});
                    break block0;
                }
                if (!oldMethodFinal && superMethod.getModifiers().contains((Object)Modifier.FINAL)) {
                    difference = this.createDifference(Code.METHOD_NON_FINAL_METHOD_REPLACED_BY_FINAL_IN_SUPERCLASS, new String[]{Util.toHumanReadableString((AnnotatedConstruct)superClass)}, new Object[]{superMethod});
                    break block0;
                }
                difference = this.createDifference(Code.METHOD_OVERRIDING_METHOD_REMOVED, new Object[0]);
                break block0;
            }
        }
        if (difference == null) {
            difference = this.createDifference(Code.METHOD_REMOVED, new Object[0]);
        }
        return Collections.singletonList(difference);
    }

    private String getMethodSignature(@Nonnull CharSequence methodName, @Nonnull ExecutableType erasedMethod) {
        StringBuilder bld = new StringBuilder(methodName);
        bld.append("(");
        for (TypeMirror typeMirror : erasedMethod.getParameterTypes()) {
            bld.append(Util.toUniqueString((TypeMirror)typeMirror)).append(";");
        }
        bld.append(")");
        bld.append(Util.toUniqueString((TypeMirror)erasedMethod.getReturnType()));
        return bld.toString();
    }
}

