/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.revapi.Archive;
import org.revapi.java.compilation.InclusionFilter;
import org.revapi.java.compilation.InnerClass;
import org.revapi.java.compilation.InnerClassHierarchyConstructor;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.compilation.RawUseSite;
import org.revapi.java.compilation.TypeRecord;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.UseSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TypeTreeConstructor {
    private static final Logger LOG = LoggerFactory.getLogger(TypeTreeConstructor.class);
    private final Set<String> unseenClassesBinaryNames = new HashSet<String>();
    private final Map<String, TypeRecord> typesByBinaryName = new HashMap<String, TypeRecord>();
    private final ProbingEnvironment environment;
    private final Set<File> bootstrapClasspath;
    private Set<String> bootstrapClasses;
    private final InclusionFilter inclusionFilter;

    TypeTreeConstructor(ProbingEnvironment environment, Set<File> bootstrapClasspath, InclusionFilter inclusionFilter) {
        this.environment = environment;
        this.bootstrapClasspath = bootstrapClasspath;
        this.inclusionFilter = inclusionFilter;
    }

    public ClassProcessor createApiClassProcessor(Archive classArchive, String classBinaryName, boolean apiType) {
        return new ClassProcessor(classArchive, classBinaryName, apiType);
    }

    public boolean hasUnknownClasses() {
        return !this.unseenClassesBinaryNames.isEmpty();
    }

    public Results construct() {
        Comparator<TypeRecord> nestingComparator = new Comparator<TypeRecord>(){

            @Override
            public int compare(TypeRecord o1, TypeRecord o2) {
                return o1.getNestingDepth() - o2.getNestingDepth();
            }
        };
        ArrayList<TypeRecord> allTypes = new ArrayList<TypeRecord>(this.typesByBinaryName.values());
        Collections.sort(allTypes, nestingComparator);
        ArrayList<String> unknownTypes = new ArrayList<String>();
        for (TypeRecord t : allTypes) {
            if (t.isApiType()) {
                if (t.isExplicitlyExcluded()) {
                    this.environment.addExplicitExclusion(t.getType().getCanonicalName());
                    continue;
                }
                if (!this.inclusionFilter.defaultCase() && !t.isExplicitlyIncluded()) continue;
                if (t.getType() == null) {
                    unknownTypes.add(t.getBinaryName());
                    continue;
                }
                if (t.getOwner() == null) {
                    this.environment.getTree().getRootsUnsafe().add(t.getType());
                } else if (this.checkInTree(t.getOwner()) == null) {
                    boolean include = true;
                    if (!t.isExplicitlyIncluded()) {
                        for (TypeRecord parent = t.getOwner(); parent != null; parent = parent.getOwner()) {
                            if (!parent.isExplicitlyExcluded()) continue;
                            include = false;
                            break;
                        }
                    }
                    if (include) {
                        this.environment.getTree().getRootsUnsafe().add(t.getType());
                    }
                }
                if (t.hasUseSites()) {
                    HashSet<RawUseSite> significantUseSites = new HashSet<RawUseSite>();
                    for (RawUseSite r : t.getUseSites()) {
                        TypeRecord tr = this.typesByBinaryName.get(r.getSiteClass());
                        if (tr == null || !tr.isApiType()) continue;
                        significantUseSites.add(r);
                    }
                    this.environment.getUseSiteMap().put(t.getBinaryName(), significantUseSites);
                }
            }
            if (!t.isSomeSubclassAccessible()) continue;
            this.environment.setAccessibleSubclasses(t.getBinaryName(), t.getAccessibleSubclasses());
        }
        return new Results(unknownTypes);
    }

    private TypeRecord checkInTree(TypeRecord t) {
        if (t == null) {
            return null;
        }
        SortedSet<TypeElement> roots = this.environment.getTree().getRootsUnsafe();
        if (t.getOwner() == null) {
            return roots.contains((Object)t.getType()) ? t : null;
        }
        if (roots.contains((Object)t.getType())) {
            return t;
        }
        return this.checkInTree(t.getOwner());
    }

    private TypeRecord getOrCreateTypeRecord(String typeBinaryName) {
        TypeRecord rec = this.typesByBinaryName.get(typeBinaryName);
        if (rec == null) {
            rec = new TypeRecord(typeBinaryName);
            this.typesByBinaryName.put(typeBinaryName, rec);
            this.unseenClassesBinaryNames.add(typeBinaryName);
        }
        return rec;
    }

    private TypeElement createTypeElement(Archive archive, String binaryName, String canonicalName) {
        return new TypeElement(this.environment, archive, binaryName, canonicalName);
    }

    private boolean isOnBootstrapClasspath(String typeBinaryName) {
        if (typeBinaryName.startsWith("java.")) {
            return true;
        }
        try {
            Class<?> cls = Class.forName(typeBinaryName);
            ClassLoader cl = cls.getClassLoader();
            return cl == null || cl.equals(ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
    }

    private static boolean movesToApi(Collection<UseSite.Type> useTypes) {
        for (UseSite.Type useType : useTypes) {
            if (!TypeTreeConstructor.movesToApi(useType)) continue;
            return true;
        }
        return false;
    }

    private static boolean movesToApi(UseSite.Type useType) {
        switch (useType) {
            case ANNOTATES: 
            case CONTAINS: {
                return false;
            }
        }
        return true;
    }

    final class ClassProcessor {
        private final Archive archive;
        private final String classBinaryName;
        private final boolean apiType;
        private InnerClassHierarchyConstructor innerClassHierarchyConstructor;
        private final List<AbstractMap.SimpleEntry<String, RawUseSite>> detectedUses = new ArrayList<AbstractMap.SimpleEntry<String, RawUseSite>>();

        private ClassProcessor(Archive archive, String classBinaryName, boolean apiType) {
            this.archive = archive;
            this.classBinaryName = classBinaryName;
            this.apiType = apiType;
        }

        public InnerClassHierarchyConstructor getInnerClassHierarchyConstructor() {
            if (this.innerClassHierarchyConstructor == null) {
                this.innerClassHierarchyConstructor = new InnerClassHierarchyConstructor();
            }
            return this.innerClassHierarchyConstructor;
        }

        public void addUse(String usedTypeBinaryName, RawUseSite useSite) {
            this.detectedUses.add(new AbstractMap.SimpleEntry<String, RawUseSite>(usedTypeBinaryName, useSite));
        }

        private void processUse(Map.Entry<String, RawUseSite> usedTypeAndUseSite) {
            String usedTypeBinaryName = usedTypeAndUseSite.getKey();
            RawUseSite useSite = usedTypeAndUseSite.getValue();
            if (TypeTreeConstructor.this.isOnBootstrapClasspath(usedTypeBinaryName)) {
                return;
            }
            TypeRecord rec = TypeTreeConstructor.this.getOrCreateTypeRecord(usedTypeBinaryName);
            if (LOG.isTraceEnabled() && this.apiType && !rec.isApiType()) {
                LOG.trace("Class {} drags {} into API by use {}", new Object[]{this.classBinaryName, usedTypeBinaryName, useSite});
            }
            rec.setApiType(rec.isApiType() || this.apiType);
            rec.setApiThroughUse(rec.isApiThroughUse() || this.apiType);
            if (rec.isApiType()) {
                if (rec.getType() == null) {
                    TypeTreeConstructor.this.unseenClassesBinaryNames.add(usedTypeBinaryName);
                }
                this.addUsedTypesToApi(rec, new HashSet<TypeRecord>());
            }
            rec.getUseSites().add(useSite);
            TypeRecord userRec = TypeTreeConstructor.this.getOrCreateTypeRecord(useSite.getSiteClass());
            Map<TypeRecord, EnumSet<UseSite.Type>> usedTypes = userRec.getUsedTypes();
            EnumSet<UseSite.Type> useTypes = usedTypes.get(rec);
            if (useTypes == null) {
                useTypes = EnumSet.noneOf(UseSite.Type.class);
                usedTypes.put(rec, useTypes);
            }
            useTypes.add(useSite.getUseType());
        }

        public void commitClass() {
            String canonicalName;
            TypeRecord rec = TypeTreeConstructor.this.getOrCreateTypeRecord(this.classBinaryName);
            TypeTreeConstructor.this.unseenClassesBinaryNames.remove(this.classBinaryName);
            List<InnerClass> innerClassHierarchy = null;
            if (this.innerClassHierarchyConstructor != null) {
                innerClassHierarchy = this.innerClassHierarchyConstructor.process();
            }
            if (this.innerClassHierarchyConstructor == null) {
                canonicalName = this.classBinaryName;
            } else if (!innerClassHierarchy.isEmpty()) {
                canonicalName = innerClassHierarchy.get(innerClassHierarchy.size() - 1).getCanonicalName();
            } else {
                return;
            }
            if (TypeTreeConstructor.this.inclusionFilter.rejects(this.classBinaryName, canonicalName)) {
                rec.setExplicitlyExcluded(true);
            } else {
                this.detectedUses.forEach(this::processUse);
            }
            rec.setExplicitlyIncluded(TypeTreeConstructor.this.inclusionFilter.accepts(this.classBinaryName, canonicalName));
            rec.setApiType(rec.isApiType() || this.apiType);
            if (rec.isApiType()) {
                this.addUsedTypesToApi(rec, new HashSet<TypeRecord>());
            }
            if (rec.getType() != null) {
                return;
            }
            if (innerClassHierarchy == null) {
                TypeElement type = TypeTreeConstructor.this.createTypeElement(this.archive, this.classBinaryName, this.classBinaryName);
                rec.setType(type);
                this.initChildren(rec, 1);
            } else {
                if (innerClassHierarchy.isEmpty()) {
                    return;
                }
                TypeRecord owner = null;
                int nestingDepth = 0;
                for (InnerClass ic : innerClassHierarchy) {
                    TypeRecord type = this.partiallyCommitInnerClass(ic, owner, nestingDepth++);
                    if (owner != null) {
                        this.addUse(owner.getBinaryName(), new RawUseSite(UseSite.Type.CONTAINS, RawUseSite.SiteType.CLASS, type.getBinaryName(), null, null));
                        this.initChildren(owner, nestingDepth);
                    } else {
                        this.initChildren(type, nestingDepth + 1);
                    }
                    owner = type;
                }
            }
        }

        private void initChildren(TypeRecord owner, int nestingDepth) {
            if (owner.getType() == null) {
                throw new IllegalStateException("At this point in time, owner should have its type set.");
            }
            for (JavaElement c : owner.getType().getChildren()) {
                if (!(c instanceof TypeElement)) continue;
                TypeElement t = (TypeElement)c;
                TypeRecord r = TypeTreeConstructor.this.getOrCreateTypeRecord(t.getBinaryName());
                r.setOwner(owner);
                r.setType(t);
                r.setNestingDepth(nestingDepth);
            }
        }

        private TypeRecord partiallyCommitInnerClass(InnerClass ic, TypeRecord owner, int nestingDepth) {
            TypeRecord rec = TypeTreeConstructor.this.getOrCreateTypeRecord(ic.getBinaryName());
            if (rec.getType() == null) {
                TypeElement type = TypeTreeConstructor.this.createTypeElement(this.archive, ic.getBinaryName(), ic.getCanonicalName());
                rec.setType(type);
            }
            rec.setOwner(owner);
            rec.setNestingDepth(nestingDepth);
            return rec;
        }

        private void addUsedTypesToApi(TypeRecord userType, Set<TypeRecord> visitedTypes) {
            if (!userType.hasUsedTypes()) {
                return;
            }
            for (Map.Entry<TypeRecord, EnumSet<UseSite.Type>> usedType : userType.getUsedTypes().entrySet()) {
                if (!TypeTreeConstructor.movesToApi(usedType.getValue())) continue;
                TypeRecord rec = usedType.getKey();
                if (LOG.isTraceEnabled() && !rec.isApiType()) {
                    LOG.trace("Class {} drags {} into API because of use types {}", new Object[]{userType.getBinaryName(), rec.getBinaryName(), usedType.getValue()});
                }
                rec.setApiType(true);
                rec.setApiThroughUse(true);
                if (usedType.getValue().contains(UseSite.Type.IS_INHERITED) || usedType.getValue().contains(UseSite.Type.IS_IMPLEMENTED)) {
                    rec.addAccessibleSubclass(userType);
                }
                if (visitedTypes.contains(rec)) continue;
                visitedTypes.add(rec);
                this.addUsedTypesToApi(rec, visitedTypes);
            }
        }
    }

    public static final class Results {
        private final List<String> unknownTypeBinaryNames;

        private Results(List<String> unknownTypeBinaryNames) {
            this.unknownTypeBinaryNames = unknownTypeBinaryNames;
        }

        public List<String> getUnknownTypeBinaryNames() {
            return this.unknownTypeBinaryNames;
        }
    }
}

