/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractBadFieldNameChecker
extends SubscriptionBaseVisitor {
    protected static final String DEFAULT_FORMAT_KEY = "format";
    protected static final String DEFAULT_FORMAT_DESCRIPTION = "Regular expression used to check the field names against.";
    protected static final String DEFAULT_FORMAT_VALUE = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.getFormat(), 32);
        }
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            VariableTree field;
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !this.isFieldModifierConcernedByRule((field = (VariableTree)member).modifiers()) || this.pattern.matcher(field.simpleName().name()).matches()) continue;
            this.addIssue((Tree)field, String.format("Rename this field \"%s\" to match the regular expression '%s'.", field.simpleName().name(), this.getFormat()));
        }
    }

    protected abstract String getFormat();

    protected abstract boolean isFieldModifierConcernedByRule(ModifiersTree var1);
}

